/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.common.css.compiler.passes.CollectConstantDefinitions;
import com.google.gwt.thirdparty.common.css.compiler.passes.ConstantDefinitions;
import java.util.ArrayList;

public class ConstantResolver
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;
    private CssTree cssTree;
    private ConstantDefinitions constantDefinitions;

    public ConstantResolver(CssTree cssTree, MutatingVisitController visitController) {
        this.cssTree = cssTree;
        this.visitController = visitController;
    }

    public boolean enterDefinition(CssDefinitionNode node) {
        ArrayList<CssValueNode> newParameters = new ArrayList<CssValueNode>();
        for (CssValueNode parameter : node.getParameters()) {
            if (parameter instanceof CssConstantReferenceNode) {
                CssConstantReferenceNode cssConstantParameter = (CssConstantReferenceNode)parameter;
                String constantName = cssConstantParameter.getValue();
                CssDefinitionNode constantDefinition = this.constantDefinitions.getConstantDefinition(constantName);
                newParameters.addAll(constantDefinition.getParameters());
                continue;
            }
            newParameters.add(parameter);
        }
        node.setParameters(newParameters);
        return true;
    }

    public void runPass() {
        CollectConstantDefinitions constantDefinitionsCollector = new CollectConstantDefinitions(this.cssTree);
        constantDefinitionsCollector.runPass();
        this.constantDefinitions = constantDefinitionsCollector.getConstantDefinitions();
        this.visitController.startVisit((CssTreeVisitor)this);
    }
}

