/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.NoSuchElementException;

class FiniteWidgetIterator
implements Iterator<Widget> {
    private int index = -1;
    private final WidgetProvider provider;
    private final int widgetCount;

    public FiniteWidgetIterator(WidgetProvider provider, int widgetCount) {
        this.provider = provider;
        this.widgetCount = widgetCount;
    }

    @Override
    public boolean hasNext() {
        for (int i = this.index + 1; i < this.widgetCount; ++i) {
            IsWidget w = this.provider.get(i);
            if (w == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Widget next() {
        for (int i = this.index + 1; i < this.widgetCount; ++i) {
            this.index = i;
            IsWidget w = this.provider.get(i);
            if (w == null) continue;
            return w.asWidget();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.index < 0 || this.index >= this.widgetCount) {
            throw new IllegalStateException();
        }
        IsWidget w = this.provider.get(this.index);
        if (w == null) {
            throw new IllegalStateException("Widget was already removed.");
        }
        w.asWidget().removeFromParent();
    }

    public static interface WidgetProvider {
        public IsWidget get(int var1);
    }
}

