/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "vi" locale.
 */
public class LocalizedNamesImpl_vi extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "VN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "EG",
        "IE",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AG",
        "AT",
        "SA",
        "AR",
        "AM",
        "AW",
        "AZ",
        "IN",
        "BS",
        "BH",
        "PL",
        "BD",
        "BB",
        "BY",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BE",
        "BO",
        "BA",
        "BW",
        "PT",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "UM",
        "AE",
        "CM",
        "KH",
        "CA",
        "CV",
        "BQ",
        "EA",
        "TD",
        "CL",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "DO",
        "CZ",
        "CF",
        "KW",
        "CI",
        "HR",
        "CU",
        "CW",
        "DG",
        "DJ",
        "DM",
        "TW",
        "DK",
        "AC",
        "BV",
        "CP",
        "CX",
        "HM",
        "IM",
        "NF",
        "AS",
        "HK",
        "MO",
        "DE",
        "EC",
        "SV",
        "ER",
        "EE",
        "ET",
        "FJ",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GL",
        "GD",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "HT",
        "NL",
        "KR",
        "US",
        "HN",
        "HU",
        "GR",
        "IS",
        "ID",
        "IR",
        "IQ",
        "IL",
        "JM",
        "JE",
        "JO",
        "KZ",
        "KE",
        "KI",
        "XK",
        "KG",
        "PS",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "EU",
        "LT",
        "LU",
        "MK",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "ME",
        "MS",
        "MZ",
        "MN",
        "MM",
        "AQ",
        "NA",
        "ZA",
        "SS",
        "NR",
        "NO",
        "NP",
        "NC",
        "NZ",
        "RU",
        "JP",
        "NI",
        "NE",
        "NG",
        "NU",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "FR",
        "FI",
        "PH",
        "PF",
        "PR",
        "QA",
        "AX",
        "MP",
        "IC",
        "KY",
        "CC",
        "CK",
        "FK",
        "FO",
        "MH",
        "GS",
        "PN",
        "SB",
        "TC",
        "VG",
        "VI",
        "GF",
        "RE",
        "RO",
        "RW",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "CY",
        "SK",
        "SI",
        "SO",
        "LK",
        "SD",
        "SR",
        "SJ",
        "SZ",
        "SY",
        "TJ",
        "TZ",
        "AN",
        "ES",
        "EH",
        "TH",
        "VA",
        "TR",
        "IO",
        "TF",
        "SE",
        "CH",
        "TL",
        "TG",
        "TK",
        "TO",
        "KP",
        "TT",
        "TA",
        "CN",
        "TN",
        "TM",
        "TV",
        "AU",
        "UG",
        "UA",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "QO",
        "GB",
        "WF",
        "IT",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Thế giới");
    namesMap.put("002", "Châu Phi");
    namesMap.put("003", "Bắc Mỹ");
    namesMap.put("005", "Nam Mỹ");
    namesMap.put("009", "Châu Đại Dương");
    namesMap.put("011", "Tây Phi");
    namesMap.put("013", "Trung Mỹ");
    namesMap.put("014", "Đông Phi");
    namesMap.put("015", "Bắc Phi");
    namesMap.put("017", "Trung Phi");
    namesMap.put("018", "Miền Nam Châu Phi");
    namesMap.put("019", "Châu Mỹ");
    namesMap.put("021", "Miền Bắc Châu Mỹ");
    namesMap.put("029", "Ca-ri-bê");
    namesMap.put("030", "Đông Á");
    namesMap.put("034", "Nam Á");
    namesMap.put("035", "Đông Nam Á");
    namesMap.put("039", "Nam Âu");
    namesMap.put("053", "Úc và New Zealand");
    namesMap.put("057", "Vùng Micronesian");
    namesMap.put("142", "Châu Á");
    namesMap.put("143", "Trung Á");
    namesMap.put("145", "Tây Á");
    namesMap.put("150", "Âu Châu");
    namesMap.put("151", "Đông Âu");
    namesMap.put("154", "Miền Bắc Châu Âu");
    namesMap.put("155", "Tây Âu");
    namesMap.put("419", "Châu Mỹ La-tinh");
    namesMap.put("AC", "Đảo Ascension");
    namesMap.put("AE", "Các Tiểu Vương quốc Ả Rập Thống nhất");
    namesMap.put("AG", "Antigua và Barbuda");
    namesMap.put("AL", "Albani");
    namesMap.put("AN", "Tây Ấn Hà Lan");
    namesMap.put("AQ", "Nam Cực");
    namesMap.put("AS", "Đảo Somoa thuộc Mỹ");
    namesMap.put("AT", "Áo");
    namesMap.put("AU", "Úc");
    namesMap.put("AX", "Quần đảo Åland");
    namesMap.put("BA", "Bosnia và Herzegovina");
    namesMap.put("BE", "Bỉ");
    namesMap.put("BG", "Bungari");
    namesMap.put("BQ", "Caribe Hà Lan");
    namesMap.put("BV", "Đảo Bouvet");
    namesMap.put("CC", "Quần đảo Cocos");
    namesMap.put("CD", "Congo - Kinshasa");
    namesMap.put("CF", "Cộng hòa Trung Phi");
    namesMap.put("CG", "Congo - Brazzaville");
    namesMap.put("CH", "Thụy Sĩ");
    namesMap.put("CK", "Quần đảo Cook");
    namesMap.put("CN", "Trung Quốc");
    namesMap.put("CP", "Đảo Clipperton");
    namesMap.put("CX", "Đảo Giáng Sinh");
    namesMap.put("CY", "Síp");
    namesMap.put("CZ", "Cộng hòa Séc");
    namesMap.put("DE", "Đức");
    namesMap.put("DK", "Đan Mạch");
    namesMap.put("DO", "Cộng hòa Dominica");
    namesMap.put("EA", "Ceuta và Melilla");
    namesMap.put("EG", "Ai Cập");
    namesMap.put("EH", "Tây Sahara");
    namesMap.put("ES", "Tây Ban Nha");
    namesMap.put("EU", "Liên Minh Châu Âu");
    namesMap.put("FI", "Phần Lan");
    namesMap.put("FK", "Quần đảo Falkland");
    namesMap.put("FO", "Quần đảo Faroe");
    namesMap.put("FR", "Pháp");
    namesMap.put("GB", "Vương quốc Anh");
    namesMap.put("GF", "Quiana thuộc Pháp");
    namesMap.put("GQ", "Guinea Xích Đạo");
    namesMap.put("GR", "Hy Lạp");
    namesMap.put("GS", "Quần đảo Nam Georgia và Nam Sandwich");
    namesMap.put("HK", "Đặc khu hành chính Hồng Kông - Trung Quốc");
    namesMap.put("HM", "Đảo Heard và Quần đảo McDonald");
    namesMap.put("HU", "Hungari");
    namesMap.put("IC", "Quần đảo Canary");
    namesMap.put("IE", "Ai-len");
    namesMap.put("IM", "Đảo Man");
    namesMap.put("IN", "Ấn Độ");
    namesMap.put("IO", "Thuộc địa Anh tại Ấn Độ Dương");
    namesMap.put("IQ", "I-rắc");
    namesMap.put("IT", "Ý");
    namesMap.put("JP", "Nhật Bản");
    namesMap.put("KH", "Campuchia");
    namesMap.put("KN", "Saint Kitts và Nevis");
    namesMap.put("KP", "Triều Tiên");
    namesMap.put("KR", "Hàn Quốc");
    namesMap.put("KW", "Cô-oét");
    namesMap.put("KY", "Quần đảo Cayman");
    namesMap.put("LA", "Lào");
    namesMap.put("LB", "Li-băng");
    namesMap.put("LR", "LIberia");
    namesMap.put("LT", "Lít-va");
    namesMap.put("LY", "Li-bi");
    namesMap.put("MA", "Ma-rốc");
    namesMap.put("MH", "Quần đảo Marshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar (Miến Điện)");
    namesMap.put("MN", "Mông Cổ");
    namesMap.put("MO", "Đặc khu hành chính Macao - Trung Quốc");
    namesMap.put("MP", "Quần đảo Bắc Mariana");
    namesMap.put("NF", "Đảo Norfolk");
    namesMap.put("NL", "Hà Lan");
    namesMap.put("NO", "Na Uy");
    namesMap.put("PF", "Polynesia thuộc Pháp");
    namesMap.put("PH", "Philippin");
    namesMap.put("PL", "Ba Lan");
    namesMap.put("PM", "Saint Pierre và Miquelon");
    namesMap.put("PN", "Quần đảo Pitcairn");
    namesMap.put("PS", "Lãnh thổ Palestine");
    namesMap.put("PT", "Bồ Đào Nha");
    namesMap.put("QO", "Vùng xa xôi thuộc Châu Đại Dương");
    namesMap.put("RU", "Nga");
    namesMap.put("SA", "Ả Rập Xê-út");
    namesMap.put("SB", "Quần đảo Solomon");
    namesMap.put("SE", "Thụy Điển");
    namesMap.put("SJ", "Svalbard và Jan Mayen");
    namesMap.put("SO", "Somali");
    namesMap.put("SS", "Nam Sudan");
    namesMap.put("ST", "São Tomé và Príncipe");
    namesMap.put("TC", "Quần đảo Turk và Caicos");
    namesMap.put("TF", "Thuộc địa Miền Nam của Pháp");
    namesMap.put("TH", "Thái Lan");
    namesMap.put("TR", "Thổ Nhĩ Kỳ");
    namesMap.put("TT", "Trinidad và Tobago");
    namesMap.put("TW", "Đài Loan");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "Các đảo nhỏ xa trung tâm thuộc Mỹ");
    namesMap.put("US", "Hoa Kỳ");
    namesMap.put("VA", "Thành Vatican");
    namesMap.put("VC", "Saint Vincent và Grenadines");
    namesMap.put("VG", "Quần đảo Virgin thuộc Anh");
    namesMap.put("VI", "Quần đảo Virgin thuộc Mỹ");
    namesMap.put("VN", "Việt Nam");
    namesMap.put("WF", "Wallis và Futuna");
    namesMap.put("ZA", "Nam Phi");
    namesMap.put("ZZ", "Vùng Chưa biết hoặc không Hợp lệ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Thế giới",
        "002": "Châu Phi",
        "003": "Bắc Mỹ",
        "005": "Nam Mỹ",
        "009": "Châu Đại Dương",
        "011": "Tây Phi",
        "013": "Trung Mỹ",
        "014": "Đông Phi",
        "015": "Bắc Phi",
        "017": "Trung Phi",
        "018": "Miền Nam Châu Phi",
        "019": "Châu Mỹ",
        "021": "Miền Bắc Châu Mỹ",
        "029": "Ca-ri-bê",
        "030": "Đông Á",
        "034": "Nam Á",
        "035": "Đông Nam Á",
        "039": "Nam Âu",
        "053": "Úc và New Zealand",
        "057": "Vùng Micronesian",
        "142": "Châu Á",
        "143": "Trung Á",
        "145": "Tây Á",
        "150": "Âu Châu",
        "151": "Đông Âu",
        "154": "Miền Bắc Châu Âu",
        "155": "Tây Âu",
        "419": "Châu Mỹ La-tinh",
        "AC": "Đảo Ascension",
        "AE": "Các Tiểu Vương quốc Ả Rập Thống nhất",
        "AG": "Antigua và Barbuda",
        "AL": "Albani",
        "AN": "Tây Ấn Hà Lan",
        "AQ": "Nam Cực",
        "AS": "Đảo Somoa thuộc Mỹ",
        "AT": "Áo",
        "AU": "Úc",
        "AX": "Quần đảo Åland",
        "BA": "Bosnia và Herzegovina",
        "BE": "Bỉ",
        "BG": "Bungari",
        "BQ": "Caribe Hà Lan",
        "BV": "Đảo Bouvet",
        "CC": "Quần đảo Cocos",
        "CD": "Congo - Kinshasa",
        "CF": "Cộng hòa Trung Phi",
        "CG": "Congo - Brazzaville",
        "CH": "Thụy Sĩ",
        "CK": "Quần đảo Cook",
        "CN": "Trung Quốc",
        "CP": "Đảo Clipperton",
        "CX": "Đảo Giáng Sinh",
        "CY": "Síp",
        "CZ": "Cộng hòa Séc",
        "DE": "Đức",
        "DK": "Đan Mạch",
        "DO": "Cộng hòa Dominica",
        "EA": "Ceuta và Melilla",
        "EG": "Ai Cập",
        "EH": "Tây Sahara",
        "ES": "Tây Ban Nha",
        "EU": "Liên Minh Châu Âu",
        "FI": "Phần Lan",
        "FK": "Quần đảo Falkland",
        "FO": "Quần đảo Faroe",
        "FR": "Pháp",
        "GB": "Vương quốc Anh",
        "GF": "Quiana thuộc Pháp",
        "GQ": "Guinea Xích Đạo",
        "GR": "Hy Lạp",
        "GS": "Quần đảo Nam Georgia và Nam Sandwich",
        "HK": "Đặc khu hành chính Hồng Kông - Trung Quốc",
        "HM": "Đảo Heard và Quần đảo McDonald",
        "HU": "Hungari",
        "IC": "Quần đảo Canary",
        "IE": "Ai-len",
        "IM": "Đảo Man",
        "IN": "Ấn Độ",
        "IO": "Thuộc địa Anh tại Ấn Độ Dương",
        "IQ": "I-rắc",
        "IT": "Ý",
        "JP": "Nhật Bản",
        "KH": "Campuchia",
        "KN": "Saint Kitts và Nevis",
        "KP": "Triều Tiên",
        "KR": "Hàn Quốc",
        "KW": "Cô-oét",
        "KY": "Quần đảo Cayman",
        "LA": "Lào",
        "LB": "Li-băng",
        "LR": "LIberia",
        "LT": "Lít-va",
        "LY": "Li-bi",
        "MA": "Ma-rốc",
        "MH": "Quần đảo Marshall",
        "MK": "Macedonia",
        "MM": "Myanmar (Miến Điện)",
        "MN": "Mông Cổ",
        "MO": "Đặc khu hành chính Macao - Trung Quốc",
        "MP": "Quần đảo Bắc Mariana",
        "NF": "Đảo Norfolk",
        "NL": "Hà Lan",
        "NO": "Na Uy",
        "PF": "Polynesia thuộc Pháp",
        "PH": "Philippin",
        "PL": "Ba Lan",
        "PM": "Saint Pierre và Miquelon",
        "PN": "Quần đảo Pitcairn",
        "PS": "Lãnh thổ Palestine",
        "PT": "Bồ Đào Nha",
        "QO": "Vùng xa xôi thuộc Châu Đại Dương",
        "RU": "Nga",
        "SA": "Ả Rập Xê-út",
        "SB": "Quần đảo Solomon",
        "SE": "Thụy Điển",
        "SJ": "Svalbard và Jan Mayen",
        "SO": "Somali",
        "SS": "Nam Sudan",
        "ST": "São Tomé và Príncipe",
        "TC": "Quần đảo Turk và Caicos",
        "TF": "Thuộc địa Miền Nam của Pháp",
        "TH": "Thái Lan",
        "TR": "Thổ Nhĩ Kỳ",
        "TT": "Trinidad và Tobago",
        "TW": "Đài Loan",
        "UA": "Ukraina",
        "UM": "Các đảo nhỏ xa trung tâm thuộc Mỹ",
        "US": "Hoa Kỳ",
        "VA": "Thành Vatican",
        "VC": "Saint Vincent và Grenadines",
        "VG": "Quần đảo Virgin thuộc Anh",
        "VI": "Quần đảo Virgin thuộc Mỹ",
        "VN": "Việt Nam",
        "WF": "Wallis và Futuna",
        "ZA": "Nam Phi",
        "ZZ": "Vùng Chưa biết hoặc không Hợp lệ"
    };
  }-*/;
}
