/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.builder.shared;

import com.google.gwt.dom.builder.shared.HtmlBuilderImpl;
import com.google.gwt.dom.builder.shared.StylesBuilder;
import com.google.gwt.dom.client.Style;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.safecss.shared.SafeStylesUtils;
import com.google.gwt.safehtml.shared.SafeUri;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class HtmlStylesBuilder
implements StylesBuilder {
    private static Map<String, String> camelCaseMap;
    private static RegExp camelCaseWord;
    private static RegExp caseWord;
    private final HtmlBuilderImpl delegate;

    static String toHyphenatedForm(String name) {
        if (camelCaseWord == null) {
            camelCaseMap = new HashMap<String, String>();
            camelCaseWord = RegExp.compile("([A-Za-z])([^A-Z]*)", "g");
            caseWord = RegExp.compile("[A-Z]([^A-Z]*)");
        }
        if (name.contains("-")) {
            return name;
        }
        String hyphenated = camelCaseMap.get(name);
        if (hyphenated == null) {
            MatchResult matches;
            hyphenated = "";
            while ((matches = camelCaseWord.exec(name)) != null) {
                String word = matches.getGroup(0);
                if (caseWord.exec(word) == null) {
                    hyphenated = hyphenated + word;
                    continue;
                }
                hyphenated = hyphenated + "-" + matches.getGroup(1).toLowerCase(Locale.ROOT);
                if (matches.getGroupCount() <= 1) continue;
                hyphenated = hyphenated + matches.getGroup(2);
            }
            camelCaseMap.put(name, hyphenated);
        }
        return hyphenated;
    }

    HtmlStylesBuilder(HtmlBuilderImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public StylesBuilder backgroundImage(SafeUri uri) {
        return this.delegate.styleProperty(SafeStylesUtils.forBackgroundImage(uri));
    }

    @Override
    public StylesBuilder borderStyle(Style.BorderStyle value) {
        return this.delegate.styleProperty(SafeStylesUtils.forBorderStyle(value));
    }

    @Override
    public StylesBuilder borderWidth(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forBorderWidth(value, unit));
    }

    @Override
    public StylesBuilder bottom(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forBottom(value, unit));
    }

    @Override
    public StylesBuilder cursor(Style.Cursor value) {
        return this.delegate.styleProperty(SafeStylesUtils.forCursor(value));
    }

    @Override
    public StylesBuilder display(Style.Display value) {
        return this.delegate.styleProperty(SafeStylesUtils.forDisplay(value));
    }

    @Override
    public void endStyle() {
        this.delegate.endStyle();
    }

    @Override
    public StylesBuilder floatprop(Style.Float value) {
        return this.delegate.styleProperty(SafeStylesUtils.forFloat(value));
    }

    @Override
    public StylesBuilder fontSize(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forFontSize(value, unit));
    }

    @Override
    public StylesBuilder fontStyle(Style.FontStyle value) {
        return this.delegate.styleProperty(SafeStylesUtils.forFontStyle(value));
    }

    @Override
    public StylesBuilder fontWeight(Style.FontWeight value) {
        return this.delegate.styleProperty(SafeStylesUtils.forFontWeight(value));
    }

    @Override
    public StylesBuilder height(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forHeight(value, unit));
    }

    @Override
    public StylesBuilder left(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forLeft(value, unit));
    }

    @Override
    public StylesBuilder lineHeight(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forLineHeight(value, unit));
    }

    @Override
    public StylesBuilder listStyleType(Style.ListStyleType value) {
        return this.delegate.styleProperty(SafeStylesUtils.forListStyleType(value));
    }

    @Override
    public StylesBuilder margin(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forMargin(value, unit));
    }

    @Override
    public StylesBuilder marginBottom(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forMarginBottom(value, unit));
    }

    @Override
    public StylesBuilder marginLeft(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forMarginLeft(value, unit));
    }

    @Override
    public StylesBuilder marginRight(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forMarginRight(value, unit));
    }

    @Override
    public StylesBuilder marginTop(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forMarginTop(value, unit));
    }

    @Override
    public StylesBuilder opacity(double value) {
        return this.delegate.styleProperty(SafeStylesUtils.forOpacity(value));
    }

    @Override
    public StylesBuilder outlineStyle(Style.OutlineStyle value) {
        return this.delegate.styleProperty(SafeStylesUtils.forOutlineStyle(value));
    }

    @Override
    public StylesBuilder outlineWidth(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forOutlineWidth(value, unit));
    }

    @Override
    public StylesBuilder overflow(Style.Overflow value) {
        return this.delegate.styleProperty(SafeStylesUtils.forOverflow(value));
    }

    @Override
    public StylesBuilder overflowX(Style.Overflow value) {
        return this.delegate.styleProperty(SafeStylesUtils.forOverflowX(value));
    }

    @Override
    public StylesBuilder overflowY(Style.Overflow value) {
        return this.delegate.styleProperty(SafeStylesUtils.forOverflowY(value));
    }

    @Override
    public StylesBuilder padding(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forPadding(value, unit));
    }

    @Override
    public StylesBuilder paddingBottom(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forPaddingBottom(value, unit));
    }

    @Override
    public StylesBuilder paddingLeft(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forPaddingLeft(value, unit));
    }

    @Override
    public StylesBuilder paddingRight(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forPaddingRight(value, unit));
    }

    @Override
    public StylesBuilder paddingTop(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forPaddingTop(value, unit));
    }

    @Override
    public StylesBuilder position(Style.Position value) {
        return this.delegate.styleProperty(SafeStylesUtils.forPosition(value));
    }

    @Override
    public StylesBuilder right(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forRight(value, unit));
    }

    @Override
    public StylesBuilder tableLayout(Style.TableLayout value) {
        return this.delegate.styleProperty(SafeStylesUtils.forTableLayout(value));
    }

    @Override
    public StylesBuilder textAlign(Style.TextAlign value) {
        return this.delegate.styleProperty(SafeStylesUtils.forTextAlign(value));
    }

    @Override
    public StylesBuilder textDecoration(Style.TextDecoration value) {
        return this.delegate.styleProperty(SafeStylesUtils.forTextDecoration(value));
    }

    @Override
    public StylesBuilder textIndent(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forTextIndent(value, unit));
    }

    @Override
    public StylesBuilder textJustify(Style.TextJustify value) {
        return this.delegate.styleProperty(SafeStylesUtils.forTextJustify(value));
    }

    @Override
    public StylesBuilder textOverflow(Style.TextOverflow value) {
        return this.delegate.styleProperty(SafeStylesUtils.forTextOverflow(value));
    }

    @Override
    public StylesBuilder textTransform(Style.TextTransform value) {
        return this.delegate.styleProperty(SafeStylesUtils.forTextTransform(value));
    }

    @Override
    public StylesBuilder top(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forTop(value, unit));
    }

    @Override
    public StylesBuilder trustedBackgroundColor(String value) {
        return this.delegate.styleProperty(SafeStylesUtils.forTrustedBackgroundColor(value));
    }

    @Override
    public StylesBuilder trustedBackgroundImage(String value) {
        return this.delegate.styleProperty(SafeStylesUtils.forTrustedBackgroundImage(value));
    }

    @Override
    public StylesBuilder trustedBorderColor(String value) {
        return this.delegate.styleProperty(SafeStylesUtils.forTrustedBorderColor(value));
    }

    @Override
    public StylesBuilder trustedColor(String value) {
        return this.delegate.styleProperty(SafeStylesUtils.forTrustedColor(value));
    }

    @Override
    public StylesBuilder trustedOutlineColor(String value) {
        return this.delegate.styleProperty(SafeStylesUtils.forTrustedOutlineColor(value));
    }

    @Override
    public StylesBuilder trustedProperty(String name, double value, Style.Unit unit) {
        name = HtmlStylesBuilder.toHyphenatedForm(name);
        return this.delegate.styleProperty(SafeStylesUtils.fromTrustedNameAndValue(name, value, unit));
    }

    @Override
    public StylesBuilder trustedProperty(String name, String value) {
        name = HtmlStylesBuilder.toHyphenatedForm(name);
        return this.delegate.styleProperty(SafeStylesUtils.fromTrustedNameAndValue(name, value));
    }

    @Override
    public StylesBuilder verticalAlign(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forVerticalAlign(value, unit));
    }

    @Override
    public StylesBuilder verticalAlign(Style.VerticalAlign value) {
        return this.delegate.styleProperty(SafeStylesUtils.forVerticalAlign(value));
    }

    @Override
    public StylesBuilder visibility(Style.Visibility value) {
        return this.delegate.styleProperty(SafeStylesUtils.forVisibility(value));
    }

    @Override
    public StylesBuilder width(double value, Style.Unit unit) {
        return this.delegate.styleProperty(SafeStylesUtils.forWidth(value, unit));
    }

    @Override
    public StylesBuilder zIndex(int value) {
        return this.delegate.styleProperty(SafeStylesUtils.forZIndex(value));
    }
}

