/*
 * Copyright 2006 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;

/**
 * A widget that wraps an IFRAME element, which can contain an arbitrary web
 * site.
 * 
 * <p>Note that if you are using {@link com.google.gwt.user.client.History}, any
 * browser history items generated by the Frame will interleave with your
 * application's history.</p>
 * 
 * <h3>CSS Style Rules</h3>
 * <ul class='css'>
 * <li>.gwt-Frame { }</li>
 * </ul>
 * 
 * <p>
 * <h3>Example</h3> {@example com.google.gwt.examples.FrameExample}
 * </p>
 */
public class Frame extends Widget {

  /**
   * Creates an empty frame.
   */
  public Frame() {
    setElement(DOM.createIFrame());
  }

  /**
   * Creates a frame that displays the resource at the specified URL.
   * 
   * @param url the URL of the resource to be displayed
   */
  public Frame(String url) {
    this();
    setUrl(url);
  }

  /**
   * Gets the URL of the frame's resource.
   * 
   * @return the frame's URL
   */
  public String getUrl() {
    return DOM.getElementProperty(getElement(), "src");
  }

  /**
   * Sets the URL of the resource to be displayed within the frame.
   * 
   * @param url the frame's new URL
   */
  public void setUrl(String url) {
    DOM.setElementProperty(getElement(), "src", url);
  }
}
