/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "sq" locale.
 */
public class LocalizedNamesImpl_sq extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "AL",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "AI",
        "DZ",
        "AN",
        "AD",
        "AO",
        "AG",
        "AQ",
        "SA",
        "AR",
        "AM",
        "AS",
        "AU",
        "AT",
        "AW",
        "AZ",
        "BH",
        "BB",
        "BD",
        "BE",
        "BF",
        "BI",
        "BJ",
        "BY",
        "BL",
        "BM",
        "BO",
        "BA",
        "BW",
        "BR",
        "CI",
        "BN",
        "BS",
        "BG",
        "BT",
        "BV",
        "BZ",
        "TD",
        "CC",
        "CD",
        "CK",
        "CP",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "EG",
        "EC",
        "AE",
        "ER",
        "EE",
        "ET",
        "EU",
        "PH",
        "FI",
        "FJ",
        "FK",
        "FO",
        "FR",
        "GM",
        "GH",
        "GD",
        "GF",
        "GG",
        "GI",
        "GA",
        "GE",
        "DE",
        "GL",
        "GP",
        "GR",
        "GS",
        "GU",
        "GY",
        "GT",
        "GN",
        "GW",
        "GQ",
        "HK",
        "HM",
        "HN",
        "HT",
        "HU",
        "IC",
        "IM",
        "IN",
        "ID",
        "IO",
        "IR",
        "IQ",
        "IE",
        "AX",
        "MH",
        "SB",
        "IS",
        "IT",
        "IL",
        "JP",
        "JE",
        "YE",
        "JO",
        "KH",
        "CM",
        "CA",
        "CV",
        "QA",
        "KZ",
        "KE",
        "CL",
        "CN",
        "KG",
        "CO",
        "KM",
        "CG",
        "KR",
        "KP",
        "CR",
        "HR",
        "CU",
        "KW",
        "KY",
        "LA",
        "LC",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LK",
        "LU",
        "MG",
        "MY",
        "MW",
        "MV",
        "MT",
        "MK",
        "MA",
        "MR",
        "GB",
        "ME",
        "MX",
        "MF",
        "FM",
        "ML",
        "MM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MZ",
        "MP",
        "MQ",
        "MS",
        "MU",
        "NA",
        "NC",
        "NE",
        "NF",
        "NG",
        "NI",
        "NO",
        "NP",
        "NR",
        "NU",
        "OM",
        "PA",
        "PG",
        "PY",
        "PE",
        "PF",
        "PK",
        "PM",
        "PN",
        "PL",
        "PT",
        "PR",
        "PS",
        "PW",
        "CY",
        "KI",
        "QO",
        "RE",
        "DO",
        "CZ",
        "CF",
        "RS",
        "RW",
        "RO",
        "RU",
        "EH",
        "KN",
        "VC",
        "ST",
        "SD",
        "CS",
        "SH",
        "AL",
        "US",
        "SL",
        "SG",
        "SY",
        "SC",
        "SJ",
        "SK",
        "SI",
        "SM",
        "SN",
        "SO",
        "ES",
        "SR",
        "SE",
        "SV",
        "SZ",
        "TA",
        "TH",
        "TW",
        "TZ",
        "TJ",
        "TC",
        "TF",
        "TK",
        "TL",
        "TM",
        "TG",
        "TO",
        "TT",
        "TN",
        "TR",
        "TV",
        "UG",
        "UA",
        "UM",
        "UY",
        "UZ",
        "VA",
        "NL",
        "VE",
        "VG",
        "VI",
        "VN",
        "VU",
        "WF",
        "WS",
        "JM",
        "DJ",
        "YT",
        "ZM",
        "NZ",
        "ZW",
        "CH",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andorrë");
    namesMap.put("AE", "Emiratet Arabe te Bashkuara");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua e Barbuda");
    namesMap.put("AL", "Shqipëria");
    namesMap.put("AM", "Armeni");
    namesMap.put("AO", "Angolë");
    namesMap.put("AR", "Argjentinë");
    namesMap.put("AT", "Austri");
    namesMap.put("AU", "Australi");
    namesMap.put("AX", "Ishujt Aland");
    namesMap.put("AZ", "Azerbajxhan");
    namesMap.put("BA", "Bosnja dhe Hercegovina");
    namesMap.put("BE", "Belgjikë");
    namesMap.put("BG", "Bullgari");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BN", "Brunej");
    namesMap.put("BO", "Bolivi");
    namesMap.put("BR", "Brazili");
    namesMap.put("BT", "Butan");
    namesMap.put("BW", "Botsvana");
    namesMap.put("BY", "Bjellorusi");
    namesMap.put("CA", "Kanada");
    namesMap.put("CF", "Republika Qendrore e Afrikës");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Zvicër");
    namesMap.put("CI", "Bregu i Fildishtë");
    namesMap.put("CL", "Kili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kinë");
    namesMap.put("CO", "Kolumbi");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CS", "Serbië en Montenegro");
    namesMap.put("CU", "Kubë");
    namesMap.put("CV", "Kap Verde");
    namesMap.put("CY", "Qipro");
    namesMap.put("CZ", "Republika e Çekisë");
    namesMap.put("DE", "Gjermani");
    namesMap.put("DJ", "Xhibuti");
    namesMap.put("DK", "Danimarkë");
    namesMap.put("DM", "Dominikë");
    namesMap.put("DO", "Republika Dominikanë");
    namesMap.put("DZ", "Algjeri");
    namesMap.put("EC", "Ekuator");
    namesMap.put("EE", "Estoni");
    namesMap.put("EG", "Egjipt");
    namesMap.put("EH", "Saharaja Perëndimore");
    namesMap.put("ER", "Eritre");
    namesMap.put("ES", "Spanjë");
    namesMap.put("ET", "Etiopi");
    namesMap.put("FI", "Finlandë");
    namesMap.put("FJ", "Fixhi");
    namesMap.put("FM", "Mikronezi");
    namesMap.put("FR", "Francë");
    namesMap.put("GA", "Gjabon");
    namesMap.put("GB", "Mbretëria e Bashkuar");
    namesMap.put("GE", "Gjeorgji");
    namesMap.put("GH", "Ganë");
    namesMap.put("GM", "Gambi");
    namesMap.put("GN", "Guine");
    namesMap.put("GQ", "Guineja Ekuatoriale");
    namesMap.put("GR", "Greqi");
    namesMap.put("GT", "Guatemalë");
    namesMap.put("GW", "Guine Bisau");
    namesMap.put("GY", "Guajana");
    namesMap.put("HR", "Kroaci");
    namesMap.put("HU", "Hungari");
    namesMap.put("ID", "Indonezi");
    namesMap.put("IE", "Irlandë");
    namesMap.put("IL", "Izrael");
    namesMap.put("IN", "Indi");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islandë");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Xhamajkë");
    namesMap.put("JO", "Jordani");
    namesMap.put("JP", "Japoni");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgistan");
    namesMap.put("KH", "Kamboxhi");
    namesMap.put("KI", "Qiribati");
    namesMap.put("KM", "Komore");
    namesMap.put("KN", "Saint Kitts e Nevis");
    namesMap.put("KP", "Koreja e Veriut");
    namesMap.put("KR", "Koreja e Jugut");
    namesMap.put("KW", "Kuvajt");
    namesMap.put("KZ", "Kazakistan");
    namesMap.put("LB", "Liban");
    namesMap.put("LI", "Lihtënshtajn");
    namesMap.put("LR", "Liberi");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituani");
    namesMap.put("LU", "Luksemburg");
    namesMap.put("LV", "Letoni");
    namesMap.put("LY", "Libi");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldavi");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Ishujt Marshall");
    namesMap.put("MK", "Maqedoni");
    namesMap.put("MN", "Mongoli");
    namesMap.put("MR", "Mauritani");
    namesMap.put("MT", "Maltë");
    namesMap.put("MV", "Maldivit");
    namesMap.put("MW", "Malavi");
    namesMap.put("MX", "Meksikë");
    namesMap.put("MY", "Malajzi");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namibi");
    namesMap.put("NG", "Nigeri");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Vendet e Ulëta");
    namesMap.put("NO", "Norvegji");
    namesMap.put("NZ", "Zelanda e Re");
    namesMap.put("PG", "Papua Guineja e Re");
    namesMap.put("PH", "Filipine");
    namesMap.put("PL", "Poloni");
    namesMap.put("PT", "Portugali");
    namesMap.put("PY", "Paraguaj");
    namesMap.put("QA", "Katar");
    namesMap.put("RO", "Rumani");
    namesMap.put("RU", "Rusi");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arabia Saudite");
    namesMap.put("SB", "Ishujt Solomon");
    namesMap.put("SC", "Sishel");
    namesMap.put("SE", "Suedi");
    namesMap.put("SG", "Singapor");
    namesMap.put("SI", "Slloveni");
    namesMap.put("SK", "Sllovaki");
    namesMap.put("SL", "Siera Leone");
    namesMap.put("SO", "Somali");
    namesMap.put("ST", "Sao Tome e Prinsipe");
    namesMap.put("SY", "Siri");
    namesMap.put("SZ", "Svazilandë");
    namesMap.put("TD", "Çad");
    namesMap.put("TH", "Tajlandë");
    namesMap.put("TJ", "Taxhikistan");
    namesMap.put("TN", "Tunisi");
    namesMap.put("TR", "Turqi");
    namesMap.put("TT", "Trinidad e Tobago");
    namesMap.put("TW", "Tajvan");
    namesMap.put("TZ", "Tanzani");
    namesMap.put("UA", "Ukrainë");
    namesMap.put("US", "Shtetet e Bashkuara të Amerikës");
    namesMap.put("UY", "Uruguaj");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Saint Vincent e Grenadinet");
    namesMap.put("VE", "Venezuelë");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Afrika e Jugut");
    namesMap.put("ZM", "Zambi");
    namesMap.put("ZW", "Zimbabve");
    namesMap.put("ZZ", "Rajon i panjohur ose i pavlefshëm");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andorrë",
        "AE": "Emiratet Arabe te Bashkuara",
        "AF": "Afganistan",
        "AG": "Antigua e Barbuda",
        "AL": "Shqipëria",
        "AM": "Armeni",
        "AO": "Angolë",
        "AR": "Argjentinë",
        "AT": "Austri",
        "AU": "Australi",
        "AX": "Ishujt Aland",
        "AZ": "Azerbajxhan",
        "BA": "Bosnja dhe Hercegovina",
        "BE": "Belgjikë",
        "BG": "Bullgari",
        "BH": "Bahrein",
        "BN": "Brunej",
        "BO": "Bolivi",
        "BR": "Brazili",
        "BT": "Butan",
        "BW": "Botsvana",
        "BY": "Bjellorusi",
        "CA": "Kanada",
        "CF": "Republika Qendrore e Afrikës",
        "CG": "Kongo",
        "CH": "Zvicër",
        "CI": "Bregu i Fildishtë",
        "CL": "Kili",
        "CM": "Kamerun",
        "CN": "Kinë",
        "CO": "Kolumbi",
        "CR": "Kosta Rika",
        "CS": "Serbië en Montenegro",
        "CU": "Kubë",
        "CV": "Kap Verde",
        "CY": "Qipro",
        "CZ": "Republika e Çekisë",
        "DE": "Gjermani",
        "DJ": "Xhibuti",
        "DK": "Danimarkë",
        "DM": "Dominikë",
        "DO": "Republika Dominikanë",
        "DZ": "Algjeri",
        "EC": "Ekuator",
        "EE": "Estoni",
        "EG": "Egjipt",
        "EH": "Saharaja Perëndimore",
        "ER": "Eritre",
        "ES": "Spanjë",
        "ET": "Etiopi",
        "FI": "Finlandë",
        "FJ": "Fixhi",
        "FM": "Mikronezi",
        "FR": "Francë",
        "GA": "Gjabon",
        "GB": "Mbretëria e Bashkuar",
        "GE": "Gjeorgji",
        "GH": "Ganë",
        "GM": "Gambi",
        "GN": "Guine",
        "GQ": "Guineja Ekuatoriale",
        "GR": "Greqi",
        "GT": "Guatemalë",
        "GW": "Guine Bisau",
        "GY": "Guajana",
        "HR": "Kroaci",
        "HU": "Hungari",
        "ID": "Indonezi",
        "IE": "Irlandë",
        "IL": "Izrael",
        "IN": "Indi",
        "IQ": "Irak",
        "IS": "Islandë",
        "IT": "Itali",
        "JM": "Xhamajkë",
        "JO": "Jordani",
        "JP": "Japoni",
        "KE": "Kenia",
        "KG": "Kirgistan",
        "KH": "Kamboxhi",
        "KI": "Qiribati",
        "KM": "Komore",
        "KN": "Saint Kitts e Nevis",
        "KP": "Koreja e Veriut",
        "KR": "Koreja e Jugut",
        "KW": "Kuvajt",
        "KZ": "Kazakistan",
        "LB": "Liban",
        "LI": "Lihtënshtajn",
        "LR": "Liberi",
        "LS": "Lesoto",
        "LT": "Lituani",
        "LU": "Luksemburg",
        "LV": "Letoni",
        "LY": "Libi",
        "MA": "Maroko",
        "MC": "Monako",
        "MD": "Moldavi",
        "MG": "Madagaskar",
        "MH": "Ishujt Marshall",
        "MK": "Maqedoni",
        "MN": "Mongoli",
        "MR": "Mauritani",
        "MT": "Maltë",
        "MV": "Maldivit",
        "MW": "Malavi",
        "MX": "Meksikë",
        "MY": "Malajzi",
        "MZ": "Mozambik",
        "NA": "Namibi",
        "NG": "Nigeri",
        "NI": "Nikaragua",
        "NL": "Vendet e Ulëta",
        "NO": "Norvegji",
        "NZ": "Zelanda e Re",
        "PG": "Papua Guineja e Re",
        "PH": "Filipine",
        "PL": "Poloni",
        "PT": "Portugali",
        "PY": "Paraguaj",
        "QA": "Katar",
        "RO": "Rumani",
        "RU": "Rusi",
        "RW": "Ruanda",
        "SA": "Arabia Saudite",
        "SB": "Ishujt Solomon",
        "SC": "Sishel",
        "SE": "Suedi",
        "SG": "Singapor",
        "SI": "Slloveni",
        "SK": "Sllovaki",
        "SL": "Siera Leone",
        "SO": "Somali",
        "ST": "Sao Tome e Prinsipe",
        "SY": "Siri",
        "SZ": "Svazilandë",
        "TD": "Çad",
        "TH": "Tajlandë",
        "TJ": "Taxhikistan",
        "TN": "Tunisi",
        "TR": "Turqi",
        "TT": "Trinidad e Tobago",
        "TW": "Tajvan",
        "TZ": "Tanzani",
        "UA": "Ukrainë",
        "US": "Shtetet e Bashkuara të Amerikës",
        "UY": "Uruguaj",
        "VA": "Vatikan",
        "VC": "Saint Vincent e Grenadinet",
        "VE": "Venezuelë",
        "YE": "Jemen",
        "ZA": "Afrika e Jugut",
        "ZM": "Zambi",
        "ZW": "Zimbabve",
        "ZZ": "Rajon i panjohur ose i pavlefshëm"
    };
  }-*/;
}
