/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ti" locale.
 */
public class LocalizedNamesImpl_ti extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "BL",
        "CP",
        "DG",
        "EA",
        "EU",
        "GG",
        "IC",
        "IM",
        "JE",
        "KG",
        "KZ",
        "ME",
        "MF",
        "RS",
        "TA",
        "HU",
        "HT",
        "IN",
        "HN",
        "HK",
        "LU",
        "LY",
        "LB",
        "LT",
        "LI",
        "LV",
        "LA",
        "LR",
        "LS",
        "FM",
        "ML",
        "MW",
        "MY",
        "MT",
        "MV",
        "MU",
        "MH",
        "MQ",
        "MK",
        "MO",
        "MM",
        "MG",
        "MX",
        "YT",
        "TL",
        "EH",
        "MD",
        "MR",
        "MA",
        "MC",
        "MS",
        "MN",
        "MZ",
        "RW",
        "RE",
        "RU",
        "RO",
        "SB",
        "KP",
        "CS",
        "SO",
        "SR",
        "SZ",
        "SD",
        "LK",
        "SY",
        "SC",
        "SG",
        "WS",
        "SM",
        "ST",
        "SA",
        "CY",
        "SL",
        "SN",
        "SH",
        "LC",
        "SK",
        "SI",
        "CH",
        "SE",
        "ES",
        "VC",
        "KN",
        "PM",
        "BT",
        "BG",
        "BF",
        "GW",
        "BS",
        "BH",
        "BB",
        "BD",
        "BZ",
        "BY",
        "BE",
        "BM",
        "BJ",
        "BN",
        "BI",
        "BR",
        "BO",
        "BA",
        "BW",
        "VA",
        "VU",
        "VN",
        "VE",
        "TR",
        "TM",
        "TV",
        "TN",
        "TZ",
        "TH",
        "TW",
        "TJ",
        "TT",
        "TO",
        "TK",
        "TG",
        "CL",
        "CN",
        "TD",
        "CZ",
        "NU",
        "NI",
        "NC",
        "NZ",
        "NE",
        "NA",
        "NR",
        "NG",
        "NL",
        "AN",
        "NP",
        "NO",
        "NF",
        "AL",
        "DZ",
        "US",
        "AW",
        "AM",
        "AR",
        "AG",
        "AQ",
        "AD",
        "AI",
        "AO",
        "AU",
        "AZ",
        "IE",
        "IS",
        "AF",
        "UY",
        "IQ",
        "IR",
        "ET",
        "ID",
        "GQ",
        "EC",
        "SV",
        "ER",
        "EE",
        "IL",
        "GB",
        "OM",
        "AT",
        "CU",
        "CK",
        "KI",
        "CM",
        "KH",
        "CA",
        "KY",
        "KE",
        "CV",
        "HR",
        "KW",
        "CO",
        "KM",
        "CR",
        "CI",
        "CD",
        "CG",
        "CC",
        "QA",
        "QO",
        "WF",
        "ZW",
        "ZM",
        "YE",
        "CF",
        "MP",
        "SJ",
        "IO",
        "BV",
        "AE",
        "TC",
        "AX",
        "UM",
        "AS",
        "VI",
        "VG",
        "HM",
        "CX",
        "TF",
        "GF",
        "PF",
        "FO",
        "PS",
        "FK",
        "UA",
        "UZ",
        "UG",
        "ZA",
        "KR",
        "GS",
        "DK",
        "DM",
        "DO",
        "DE",
        "DJ",
        "JM",
        "JP",
        "JO",
        "GE",
        "GU",
        "GT",
        "GP",
        "GY",
        "GI",
        "GN",
        "GM",
        "GA",
        "GH",
        "GL",
        "GR",
        "GD",
        "EG",
        "IT",
        "FR",
        "PH",
        "FI",
        "FJ",
        "PN",
        "PW",
        "PY",
        "PA",
        "PK",
        "PG",
        "PE",
        "PL",
        "PT",
        "PR",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ዓለም");
    namesMap.put("002", "አፍሪካ");
    namesMap.put("005", "ደቡባዊ አሜሪካ");
    namesMap.put("009", "ኦሽኒያ");
    namesMap.put("011", "ምዕራባዊ አፍሪካ");
    namesMap.put("013", "መካከለኛ አሜሪካ [013]");
    namesMap.put("014", "ምስራቃዊ አፍሪካ");
    namesMap.put("015", "ሰሜናዊ አፍሪካ");
    namesMap.put("017", "መካከለኛ አፍሪካ");
    namesMap.put("018", "ደቡባዊ አፍሪካ");
    namesMap.put("019", "አሜሪካዎች");
    namesMap.put("021", "ሰሜናዊ አሜሪካ");
    namesMap.put("029", "ካሪቢያን");
    namesMap.put("030", "ደቡብ-ምሥራቃዊ እስያ [030]");
    namesMap.put("034", "ምሥራቃዊ እስያ");
    namesMap.put("035", "ደቡብ-ምሥራቃዊ እስያ [035]");
    namesMap.put("039", "ደቡባዊ አውሮፓ");
    namesMap.put("053", "አውስትራሊያ እና ኒው ዚላንድ");
    namesMap.put("054", "ሜላኔሲያ");
    namesMap.put("057", "ሚክሮኔዢያ [057]");
    namesMap.put("061", "ፖሊኔዢያ");
    namesMap.put("142", "እስያ");
    namesMap.put("143", "መካከለኛ አሜሪካ [143]");
    namesMap.put("145", "ምዕራባዊ እስያ");
    namesMap.put("150", "አውሮፓ");
    namesMap.put("151", "ምስራቃዊ አውሮፓ");
    namesMap.put("154", "ሰሜናዊ አውሮፓ");
    namesMap.put("155", "ምዕራባዊ አውሮፓ");
    namesMap.put("AD", "አንዶራ");
    namesMap.put("AE", "የተባበሩት አረብ ኤምሬትስ");
    namesMap.put("AF", "አፍጋኒስታን");
    namesMap.put("AG", "አንቲጓ እና ባሩዳ");
    namesMap.put("AI", "አንጉኢላ");
    namesMap.put("AL", "አልባኒያ");
    namesMap.put("AM", "አርሜኒያ");
    namesMap.put("AN", "ኔዘርላንድስ አንቲልስ");
    namesMap.put("AO", "አንጐላ");
    namesMap.put("AQ", "አንታርክቲካ");
    namesMap.put("AR", "አርጀንቲና");
    namesMap.put("AS", "የአሜሪካ ሳሞአ");
    namesMap.put("AT", "ኦስትሪያ");
    namesMap.put("AU", "አውስትሬሊያ");
    namesMap.put("AW", "አሩባ");
    namesMap.put("AX", "የአላንድ ደሴቶች");
    namesMap.put("AZ", "አዘርባጃን");
    namesMap.put("BA", "ቦስኒያ እና ሄርዞጎቪኒያ");
    namesMap.put("BB", "ባርቤዶስ");
    namesMap.put("BD", "ባንግላዲሽ");
    namesMap.put("BE", "ቤልጄም");
    namesMap.put("BF", "ቡርኪና ፋሶ");
    namesMap.put("BG", "ቡልጌሪያ");
    namesMap.put("BH", "ባህሬን");
    namesMap.put("BI", "ብሩንዲ");
    namesMap.put("BJ", "ቤኒን");
    namesMap.put("BM", "ቤርሙዳ");
    namesMap.put("BN", "ብሩኒ");
    namesMap.put("BO", "ቦሊቪያ");
    namesMap.put("BR", "ብራዚል");
    namesMap.put("BS", "ባሃማስ");
    namesMap.put("BT", "ቡህታን");
    namesMap.put("BV", "የቦውቬት ደሴት");
    namesMap.put("BW", "ቦትስዋና");
    namesMap.put("BY", "ቤላሩስ");
    namesMap.put("BZ", "ቤሊዘ");
    namesMap.put("CA", "ካናዳ");
    namesMap.put("CC", "ኮኮስ ኬሊንግ ደሴቶች");
    namesMap.put("CD", "ኮንጎ");
    namesMap.put("CF", "የመካከለኛው አፍሪካ ሪፐብሊክ");
    namesMap.put("CG", "ኮንጐ");
    namesMap.put("CH", "ስዊዘርላንድ");
    namesMap.put("CI", "ኮት ዲቯር");
    namesMap.put("CK", "ኩክ ደሴቶች");
    namesMap.put("CL", "ቺሊ");
    namesMap.put("CM", "ካሜሩን");
    namesMap.put("CN", "ቻይና");
    namesMap.put("CO", "ኮሎምቢያ");
    namesMap.put("CR", "ኮስታ ሪካ");
    namesMap.put("CS", "ሰርቢያ");
    namesMap.put("CU", "ኩባ");
    namesMap.put("CV", "ኬፕ ቬርዴ");
    namesMap.put("CX", "የገና ደሴቶች");
    namesMap.put("CY", "ሳይፕረስ");
    namesMap.put("CZ", "ቼክ ሪፑብሊክ");
    namesMap.put("DE", "ጀርመን");
    namesMap.put("DJ", "ጂቡቲ");
    namesMap.put("DK", "ዴንማርክ");
    namesMap.put("DM", "ዶሚኒካ");
    namesMap.put("DO", "ዶሚኒክ ሪፑብሊክ");
    namesMap.put("DZ", "አልጄሪያ");
    namesMap.put("EC", "ኢኳዶር");
    namesMap.put("EE", "ኤስቶኒያ");
    namesMap.put("EG", "ግብጽ");
    namesMap.put("EH", "ምዕራባዊ ሳህራ");
    namesMap.put("ER", "ኤርትራ");
    namesMap.put("ES", "ስፔን");
    namesMap.put("ET", "ኢትዮጵያ");
    namesMap.put("FI", "ፊንላንድ");
    namesMap.put("FJ", "ፊጂ");
    namesMap.put("FK", "የፎልክላንድ ደሴቶች");
    namesMap.put("FM", "ሚክሮኔዢያ");
    namesMap.put("FO", "የፋሮይ ደሴቶች");
    namesMap.put("FR", "ፈረንሳይ");
    namesMap.put("GA", "ጋቦን");
    namesMap.put("GB", "እንግሊዝ");
    namesMap.put("GD", "ግሬናዳ");
    namesMap.put("GE", "ጆርጂያ");
    namesMap.put("GF", "የፈረንሳይ ጉዊአና");
    namesMap.put("GH", "ጋና");
    namesMap.put("GI", "ጊብራልታር");
    namesMap.put("GL", "ግሪንላንድ");
    namesMap.put("GM", "ጋምቢያ");
    namesMap.put("GN", "ጊኒ");
    namesMap.put("GP", "ጉዋደሉፕ");
    namesMap.put("GQ", "ኢኳቶሪያል ጊኒ");
    namesMap.put("GR", "ግሪክ");
    namesMap.put("GS", "ደቡብ ጆርጂያ እና የደቡድ ሳንድዊች ደሴቶች");
    namesMap.put("GT", "ጉዋቲማላ");
    namesMap.put("GU", "ጉዋም");
    namesMap.put("GW", "ቢሳዎ");
    namesMap.put("GY", "ጉያና");
    namesMap.put("HK", "ሆንግ ኮንግ");
    namesMap.put("HM", "የኧርድ እና የማክዶናልድ ደሴቶች");
    namesMap.put("HN", "ሆንዱራስ");
    namesMap.put("HR", "ክሮኤሽያ");
    namesMap.put("HT", "ሀይቲ");
    namesMap.put("HU", "ሀንጋሪ");
    namesMap.put("ID", "ኢንዶኔዢያ");
    namesMap.put("IE", "አየርላንድ");
    namesMap.put("IL", "እስራኤል");
    namesMap.put("IN", "ህንድ");
    namesMap.put("IO", "የብሪታኒያ ህንድ ውቂያኖስ ግዛት");
    namesMap.put("IQ", "ኢራቅ");
    namesMap.put("IR", "ኢራን");
    namesMap.put("IS", "አይስላንድ");
    namesMap.put("IT", "ጣሊያን");
    namesMap.put("JM", "ጃማይካ");
    namesMap.put("JO", "ጆርዳን");
    namesMap.put("JP", "ጃፓን");
    namesMap.put("KE", "ኬንያ");
    namesMap.put("KH", "ካምቦዲያ");
    namesMap.put("KI", "ኪሪባቲ");
    namesMap.put("KM", "ኮሞሮስ");
    namesMap.put("KN", "ቅዱስ ኪትስ እና ኔቪስ");
    namesMap.put("KP", "ሰሜን ኮሪያ");
    namesMap.put("KR", "ደቡብ ኮሪያ");
    namesMap.put("KW", "ክዌት");
    namesMap.put("KY", "ካይማን ደሴቶች");
    namesMap.put("LA", "ላኦስ");
    namesMap.put("LB", "ሊባኖስ");
    namesMap.put("LC", "ሴንት ሉቺያ");
    namesMap.put("LI", "ሊችተንስታይን");
    namesMap.put("LK", "ሲሪላንካ");
    namesMap.put("LR", "ላይቤሪያ");
    namesMap.put("LS", "ሌሶቶ");
    namesMap.put("LT", "ሊቱዌኒያ");
    namesMap.put("LU", "ሉክሰምበርግ");
    namesMap.put("LV", "ላትቪያ");
    namesMap.put("LY", "ሊቢያ");
    namesMap.put("MA", "ሞሮኮ");
    namesMap.put("MC", "ሞናኮ");
    namesMap.put("MD", "ሞልዶቫ");
    namesMap.put("MG", "ማዳጋስካር");
    namesMap.put("MH", "ማርሻል አይላንድ");
    namesMap.put("MK", "ማከዶኒያ");
    namesMap.put("ML", "ማሊ");
    namesMap.put("MM", "ማያንማር");
    namesMap.put("MN", "ሞንጎሊያ");
    namesMap.put("MO", "ማካዎ");
    namesMap.put("MP", "የሰሜናዊ ማሪያና ደሴቶች");
    namesMap.put("MQ", "ማርቲኒክ");
    namesMap.put("MR", "ሞሪቴኒያ");
    namesMap.put("MS", "ሞንትሴራት");
    namesMap.put("MT", "ማልታ");
    namesMap.put("MU", "ማሩሸስ");
    namesMap.put("MV", "ማልዲቭስ");
    namesMap.put("MW", "ማላዊ");
    namesMap.put("MX", "ሜክሲኮ");
    namesMap.put("MY", "ማሌዢያ");
    namesMap.put("MZ", "ሞዛምቢክ");
    namesMap.put("NA", "ናሚቢያ");
    namesMap.put("NC", "ኒው ካሌዶኒያ");
    namesMap.put("NE", "ኒጀር");
    namesMap.put("NF", "ኖርፎልክ ደሴት");
    namesMap.put("NG", "ናይጄሪያ");
    namesMap.put("NI", "ኒካራጓ");
    namesMap.put("NL", "ኔዘርላንድ");
    namesMap.put("NO", "ኖርዌ");
    namesMap.put("NP", "ኔፓል");
    namesMap.put("NR", "ናኡሩ");
    namesMap.put("NU", "ኒኡይ");
    namesMap.put("NZ", "ኒው ዚላንድ");
    namesMap.put("OM", "ኦማን");
    namesMap.put("PA", "ፓናማ");
    namesMap.put("PE", "ፔሩ");
    namesMap.put("PF", "የፈረንሳይ ፖሊኔዢያ");
    namesMap.put("PG", "ፓፑዋ ኒው ጊኒ");
    namesMap.put("PH", "ፊሊፒንስ");
    namesMap.put("PK", "ፓኪስታን");
    namesMap.put("PL", "ፖላንድ");
    namesMap.put("PM", "ቅዱስ ፒዬር እና ሚኩኤሎን");
    namesMap.put("PN", "ፒትካኢርን");
    namesMap.put("PR", "ፖርታ ሪኮ");
    namesMap.put("PS", "የፍልስጤም ግዛት");
    namesMap.put("PT", "ፖርቱጋል");
    namesMap.put("PW", "ፓላው");
    namesMap.put("PY", "ፓራጓይ");
    namesMap.put("QA", "ኳታር");
    namesMap.put("QO", "ወጣ ያለ ኦሽኒያ");
    namesMap.put("RE", "ሪዩኒየን");
    namesMap.put("RO", "ሮሜኒያ");
    namesMap.put("RU", "ራሺያ");
    namesMap.put("RW", "ሩዋንዳ");
    namesMap.put("SA", "ሳውድአረቢያ");
    namesMap.put("SB", "ሰሎሞን ደሴት");
    namesMap.put("SC", "ሲሼልስ");
    namesMap.put("SD", "ሱዳን");
    namesMap.put("SE", "ስዊድን");
    namesMap.put("SG", "ሲንጋፖር");
    namesMap.put("SH", "ሴንት ሄለና");
    namesMap.put("SI", "ስሎቬኒያ");
    namesMap.put("SJ", "የስቫልባርድ እና ዣን ማየን ደሴቶች");
    namesMap.put("SK", "ስሎቫኪያ");
    namesMap.put("SL", "ሴራሊዮን");
    namesMap.put("SM", "ሳን ማሪኖ");
    namesMap.put("SN", "ሴኔጋል");
    namesMap.put("SO", "ሱማሌ");
    namesMap.put("SR", "ሱሪናም");
    namesMap.put("ST", "ሳኦ ቶሜ እና ፕሪንሲፔ");
    namesMap.put("SV", "ኤል ሳልቫዶር");
    namesMap.put("SY", "ሲሪያ");
    namesMap.put("SZ", "ሱዋዚላንድ");
    namesMap.put("TC", "የቱርኮችና የካኢኮስ ደሴቶች");
    namesMap.put("TD", "ቻድ");
    namesMap.put("TF", "የፈረንሳይ ደቡባዊ ግዛቶች");
    namesMap.put("TG", "ቶጐ");
    namesMap.put("TH", "ታይላንድ");
    namesMap.put("TJ", "ታጃኪስታን");
    namesMap.put("TK", "ቶክላው");
    namesMap.put("TL", "ምስራቅ ቲሞር");
    namesMap.put("TM", "ቱርክሜኒስታን");
    namesMap.put("TN", "ቱኒዚያ");
    namesMap.put("TO", "ቶንጋ");
    namesMap.put("TR", "ቱርክ");
    namesMap.put("TT", "ትሪኒዳድ እና ቶባጎ");
    namesMap.put("TV", "ቱቫሉ");
    namesMap.put("TW", "ታይዋን");
    namesMap.put("TZ", "ታንዛኒያ");
    namesMap.put("UA", "ዩክሬን");
    namesMap.put("UG", "ዩጋንዳ");
    namesMap.put("UM", "የአሜሪካ ራቅ ያሉ አናሳ ደሴቶች");
    namesMap.put("US", "አሜሪካ");
    namesMap.put("UY", "ኡራጓይ");
    namesMap.put("UZ", "ዩዝበኪስታን");
    namesMap.put("VA", "ቫቲካን");
    namesMap.put("VC", "ቅዱስ ቪንሴንት እና ግሬናዲንስ");
    namesMap.put("VE", "ቬንዙዌላ");
    namesMap.put("VG", "የእንግሊዝ ድንግል ደሴቶች");
    namesMap.put("VI", "የአሜሪካ ቨርጂን ደሴቶች");
    namesMap.put("VN", "ቬትናም");
    namesMap.put("VU", "ቫኑአቱ");
    namesMap.put("WF", "ዋሊስ እና ፉቱና ደሴቶች");
    namesMap.put("WS", "ሳሞአ");
    namesMap.put("YE", "የመን");
    namesMap.put("YT", "ሜይኦቴ");
    namesMap.put("ZA", "ደቡብ አፍሪካ");
    namesMap.put("ZM", "ዛምቢያ");
    namesMap.put("ZW", "ዚምቧቤ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ዓለም",
        "002": "አፍሪካ",
        "005": "ደቡባዊ አሜሪካ",
        "009": "ኦሽኒያ",
        "011": "ምዕራባዊ አፍሪካ",
        "013": "መካከለኛ አሜሪካ [013]",
        "014": "ምስራቃዊ አፍሪካ",
        "015": "ሰሜናዊ አፍሪካ",
        "017": "መካከለኛ አፍሪካ",
        "018": "ደቡባዊ አፍሪካ",
        "019": "አሜሪካዎች",
        "021": "ሰሜናዊ አሜሪካ",
        "029": "ካሪቢያን",
        "030": "ደቡብ-ምሥራቃዊ እስያ [030]",
        "034": "ምሥራቃዊ እስያ",
        "035": "ደቡብ-ምሥራቃዊ እስያ [035]",
        "039": "ደቡባዊ አውሮፓ",
        "053": "አውስትራሊያ እና ኒው ዚላንድ",
        "054": "ሜላኔሲያ",
        "057": "ሚክሮኔዢያ [057]",
        "061": "ፖሊኔዢያ",
        "142": "እስያ",
        "143": "መካከለኛ አሜሪካ [143]",
        "145": "ምዕራባዊ እስያ",
        "150": "አውሮፓ",
        "151": "ምስራቃዊ አውሮፓ",
        "154": "ሰሜናዊ አውሮፓ",
        "155": "ምዕራባዊ አውሮፓ",
        "AD": "አንዶራ",
        "AE": "የተባበሩት አረብ ኤምሬትስ",
        "AF": "አፍጋኒስታን",
        "AG": "አንቲጓ እና ባሩዳ",
        "AI": "አንጉኢላ",
        "AL": "አልባኒያ",
        "AM": "አርሜኒያ",
        "AN": "ኔዘርላንድስ አንቲልስ",
        "AO": "አንጐላ",
        "AQ": "አንታርክቲካ",
        "AR": "አርጀንቲና",
        "AS": "የአሜሪካ ሳሞአ",
        "AT": "ኦስትሪያ",
        "AU": "አውስትሬሊያ",
        "AW": "አሩባ",
        "AX": "የአላንድ ደሴቶች",
        "AZ": "አዘርባጃን",
        "BA": "ቦስኒያ እና ሄርዞጎቪኒያ",
        "BB": "ባርቤዶስ",
        "BD": "ባንግላዲሽ",
        "BE": "ቤልጄም",
        "BF": "ቡርኪና ፋሶ",
        "BG": "ቡልጌሪያ",
        "BH": "ባህሬን",
        "BI": "ብሩንዲ",
        "BJ": "ቤኒን",
        "BM": "ቤርሙዳ",
        "BN": "ብሩኒ",
        "BO": "ቦሊቪያ",
        "BR": "ብራዚል",
        "BS": "ባሃማስ",
        "BT": "ቡህታን",
        "BV": "የቦውቬት ደሴት",
        "BW": "ቦትስዋና",
        "BY": "ቤላሩስ",
        "BZ": "ቤሊዘ",
        "CA": "ካናዳ",
        "CC": "ኮኮስ ኬሊንግ ደሴቶች",
        "CD": "ኮንጎ",
        "CF": "የመካከለኛው አፍሪካ ሪፐብሊክ",
        "CG": "ኮንጐ",
        "CH": "ስዊዘርላንድ",
        "CI": "ኮት ዲቯር",
        "CK": "ኩክ ደሴቶች",
        "CL": "ቺሊ",
        "CM": "ካሜሩን",
        "CN": "ቻይና",
        "CO": "ኮሎምቢያ",
        "CR": "ኮስታ ሪካ",
        "CS": "ሰርቢያ",
        "CU": "ኩባ",
        "CV": "ኬፕ ቬርዴ",
        "CX": "የገና ደሴቶች",
        "CY": "ሳይፕረስ",
        "CZ": "ቼክ ሪፑብሊክ",
        "DE": "ጀርመን",
        "DJ": "ጂቡቲ",
        "DK": "ዴንማርክ",
        "DM": "ዶሚኒካ",
        "DO": "ዶሚኒክ ሪፑብሊክ",
        "DZ": "አልጄሪያ",
        "EC": "ኢኳዶር",
        "EE": "ኤስቶኒያ",
        "EG": "ግብጽ",
        "EH": "ምዕራባዊ ሳህራ",
        "ER": "ኤርትራ",
        "ES": "ስፔን",
        "ET": "ኢትዮጵያ",
        "FI": "ፊንላንድ",
        "FJ": "ፊጂ",
        "FK": "የፎልክላንድ ደሴቶች",
        "FM": "ሚክሮኔዢያ",
        "FO": "የፋሮይ ደሴቶች",
        "FR": "ፈረንሳይ",
        "GA": "ጋቦን",
        "GB": "እንግሊዝ",
        "GD": "ግሬናዳ",
        "GE": "ጆርጂያ",
        "GF": "የፈረንሳይ ጉዊአና",
        "GH": "ጋና",
        "GI": "ጊብራልታር",
        "GL": "ግሪንላንድ",
        "GM": "ጋምቢያ",
        "GN": "ጊኒ",
        "GP": "ጉዋደሉፕ",
        "GQ": "ኢኳቶሪያል ጊኒ",
        "GR": "ግሪክ",
        "GS": "ደቡብ ጆርጂያ እና የደቡድ ሳንድዊች ደሴቶች",
        "GT": "ጉዋቲማላ",
        "GU": "ጉዋም",
        "GW": "ቢሳዎ",
        "GY": "ጉያና",
        "HK": "ሆንግ ኮንግ",
        "HM": "የኧርድ እና የማክዶናልድ ደሴቶች",
        "HN": "ሆንዱራስ",
        "HR": "ክሮኤሽያ",
        "HT": "ሀይቲ",
        "HU": "ሀንጋሪ",
        "ID": "ኢንዶኔዢያ",
        "IE": "አየርላንድ",
        "IL": "እስራኤል",
        "IN": "ህንድ",
        "IO": "የብሪታኒያ ህንድ ውቂያኖስ ግዛት",
        "IQ": "ኢራቅ",
        "IR": "ኢራን",
        "IS": "አይስላንድ",
        "IT": "ጣሊያን",
        "JM": "ጃማይካ",
        "JO": "ጆርዳን",
        "JP": "ጃፓን",
        "KE": "ኬንያ",
        "KH": "ካምቦዲያ",
        "KI": "ኪሪባቲ",
        "KM": "ኮሞሮስ",
        "KN": "ቅዱስ ኪትስ እና ኔቪስ",
        "KP": "ሰሜን ኮሪያ",
        "KR": "ደቡብ ኮሪያ",
        "KW": "ክዌት",
        "KY": "ካይማን ደሴቶች",
        "LA": "ላኦስ",
        "LB": "ሊባኖስ",
        "LC": "ሴንት ሉቺያ",
        "LI": "ሊችተንስታይን",
        "LK": "ሲሪላንካ",
        "LR": "ላይቤሪያ",
        "LS": "ሌሶቶ",
        "LT": "ሊቱዌኒያ",
        "LU": "ሉክሰምበርግ",
        "LV": "ላትቪያ",
        "LY": "ሊቢያ",
        "MA": "ሞሮኮ",
        "MC": "ሞናኮ",
        "MD": "ሞልዶቫ",
        "MG": "ማዳጋስካር",
        "MH": "ማርሻል አይላንድ",
        "MK": "ማከዶኒያ",
        "ML": "ማሊ",
        "MM": "ማያንማር",
        "MN": "ሞንጎሊያ",
        "MO": "ማካዎ",
        "MP": "የሰሜናዊ ማሪያና ደሴቶች",
        "MQ": "ማርቲኒክ",
        "MR": "ሞሪቴኒያ",
        "MS": "ሞንትሴራት",
        "MT": "ማልታ",
        "MU": "ማሩሸስ",
        "MV": "ማልዲቭስ",
        "MW": "ማላዊ",
        "MX": "ሜክሲኮ",
        "MY": "ማሌዢያ",
        "MZ": "ሞዛምቢክ",
        "NA": "ናሚቢያ",
        "NC": "ኒው ካሌዶኒያ",
        "NE": "ኒጀር",
        "NF": "ኖርፎልክ ደሴት",
        "NG": "ናይጄሪያ",
        "NI": "ኒካራጓ",
        "NL": "ኔዘርላንድ",
        "NO": "ኖርዌ",
        "NP": "ኔፓል",
        "NR": "ናኡሩ",
        "NU": "ኒኡይ",
        "NZ": "ኒው ዚላንድ",
        "OM": "ኦማን",
        "PA": "ፓናማ",
        "PE": "ፔሩ",
        "PF": "የፈረንሳይ ፖሊኔዢያ",
        "PG": "ፓፑዋ ኒው ጊኒ",
        "PH": "ፊሊፒንስ",
        "PK": "ፓኪስታን",
        "PL": "ፖላንድ",
        "PM": "ቅዱስ ፒዬር እና ሚኩኤሎን",
        "PN": "ፒትካኢርን",
        "PR": "ፖርታ ሪኮ",
        "PS": "የፍልስጤም ግዛት",
        "PT": "ፖርቱጋል",
        "PW": "ፓላው",
        "PY": "ፓራጓይ",
        "QA": "ኳታር",
        "QO": "ወጣ ያለ ኦሽኒያ",
        "RE": "ሪዩኒየን",
        "RO": "ሮሜኒያ",
        "RU": "ራሺያ",
        "RW": "ሩዋንዳ",
        "SA": "ሳውድአረቢያ",
        "SB": "ሰሎሞን ደሴት",
        "SC": "ሲሼልስ",
        "SD": "ሱዳን",
        "SE": "ስዊድን",
        "SG": "ሲንጋፖር",
        "SH": "ሴንት ሄለና",
        "SI": "ስሎቬኒያ",
        "SJ": "የስቫልባርድ እና ዣን ማየን ደሴቶች",
        "SK": "ስሎቫኪያ",
        "SL": "ሴራሊዮን",
        "SM": "ሳን ማሪኖ",
        "SN": "ሴኔጋል",
        "SO": "ሱማሌ",
        "SR": "ሱሪናም",
        "ST": "ሳኦ ቶሜ እና ፕሪንሲፔ",
        "SV": "ኤል ሳልቫዶር",
        "SY": "ሲሪያ",
        "SZ": "ሱዋዚላንድ",
        "TC": "የቱርኮችና የካኢኮስ ደሴቶች",
        "TD": "ቻድ",
        "TF": "የፈረንሳይ ደቡባዊ ግዛቶች",
        "TG": "ቶጐ",
        "TH": "ታይላንድ",
        "TJ": "ታጃኪስታን",
        "TK": "ቶክላው",
        "TL": "ምስራቅ ቲሞር",
        "TM": "ቱርክሜኒስታን",
        "TN": "ቱኒዚያ",
        "TO": "ቶንጋ",
        "TR": "ቱርክ",
        "TT": "ትሪኒዳድ እና ቶባጎ",
        "TV": "ቱቫሉ",
        "TW": "ታይዋን",
        "TZ": "ታንዛኒያ",
        "UA": "ዩክሬን",
        "UG": "ዩጋንዳ",
        "UM": "የአሜሪካ ራቅ ያሉ አናሳ ደሴቶች",
        "US": "አሜሪካ",
        "UY": "ኡራጓይ",
        "UZ": "ዩዝበኪስታን",
        "VA": "ቫቲካን",
        "VC": "ቅዱስ ቪንሴንት እና ግሬናዲንስ",
        "VE": "ቬንዙዌላ",
        "VG": "የእንግሊዝ ድንግል ደሴቶች",
        "VI": "የአሜሪካ ቨርጂን ደሴቶች",
        "VN": "ቬትናም",
        "VU": "ቫኑአቱ",
        "WF": "ዋሊስ እና ፉቱና ደሴቶች",
        "WS": "ሳሞአ",
        "YE": "የመን",
        "YT": "ሜይኦቴ",
        "ZA": "ደቡብ አፍሪካ",
        "ZM": "ዛምቢያ",
        "ZW": "ዚምቧቤ"
    };
  }-*/;
}
