/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "sw" locale.
 */
public class LocalizedNamesImpl_sw extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "TZ",
        "CD",
        "KE",
        "UG",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "ZA",
        "AF",
        "IS",
        "AR",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "AM",
        "AW",
        "AU",
        "AT",
        "IE",
        "AZ",
        "BB",
        "BS",
        "BH",
        "BD",
        "BY",
        "BZ",
        "BJ",
        "BM",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BF",
        "MG",
        "BG",
        "BI",
        "BT",
        "EA",
        "TD",
        "CL",
        "CN",
        "CW",
        "DK",
        "DG",
        "DM",
        "EC",
        "SV",
        "IO",
        "ER",
        "EE",
        "AE",
        "FJ",
        "PH",
        "GA",
        "GM",
        "GH",
        "GN",
        "GW",
        "GQ",
        "GD",
        "GL",
        "GG",
        "GY",
        "GP",
        "GU",
        "GT",
        "GF",
        "HT",
        "ES",
        "HN",
        "HK",
        "HU",
        "IN",
        "ID",
        "IQ",
        "IM",
        "IL",
        "IT",
        "JM",
        "CF",
        "CZ",
        "DO",
        "CD",
        "JP",
        "JE",
        "GI",
        "DJ",
        "GE",
        "GS",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "CV",
        "KI",
        "KG",
        "AC",
        "BV",
        "CP",
        "HM",
        "CX",
        "NF",
        "CI",
        "CO",
        "KM",
        "CG",
        "HR",
        "KP",
        "KR",
        "CR",
        "CU",
        "CY",
        "KW",
        "LA",
        "LU",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "MO",
        "TF",
        "MW",
        "MY",
        "ML",
        "MT",
        "US",
        "MQ",
        "MK",
        "YT",
        "MX",
        "FM",
        "EG",
        "MV",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MU",
        "MR",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NC",
        "NZ",
        "QO",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PF",
        "PR",
        "RE",
        "RO",
        "RW",
        "EH",
        "BL",
        "MF",
        "SM",
        "WS",
        "AS",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "ST",
        "SA",
        "SN",
        "RS",
        "CS",
        "SC",
        "SL",
        "SG",
        "SY",
        "LK",
        "SK",
        "SI",
        "SO",
        "SS",
        "SD",
        "SR",
        "SJ",
        "SX",
        "TH",
        "TW",
        "TJ",
        "TZ",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TV",
        "IR",
        "BE",
        "FR",
        "FI",
        "UG",
        "GR",
        "ET",
        "NL",
        "GB",
        "DE",
        "PS",
        "UA",
        "EU",
        "PT",
        "UY",
        "RU",
        "SZ",
        "SE",
        "CH",
        "TR",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "UM",
        "AX",
        "CC",
        "CK",
        "FK",
        "FO",
        "IC",
        "KY",
        "MP",
        "MH",
        "SB",
        "TC",
        "VI",
        "VG",
        "WF",
        "YE",
        "JO",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dunia");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Amerika Kaskazini");
    namesMap.put("005", "Amerika Kusini");
    namesMap.put("011", "Afrika ya Magharibi");
    namesMap.put("013", "Amerika ya Kati");
    namesMap.put("014", "Afrika ya Mashariki");
    namesMap.put("015", "Afrika ya Kaskazini");
    namesMap.put("017", "Afrika ya Kati");
    namesMap.put("018", "Afrika ya Kusini");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerika ya Kaskazini");
    namesMap.put("029", "Karibi");
    namesMap.put("030", "Asia Mashariki");
    namesMap.put("034", "Asia ya Kusini");
    namesMap.put("035", "Asia ya Kusini Mashariki");
    namesMap.put("039", "Ulaya ya Kusini");
    namesMap.put("053", "Australia na New Zealand");
    namesMap.put("057", "Eneo la Mikronesia");
    namesMap.put("143", "Asia ya Kati");
    namesMap.put("145", "Asia ya Magharibi");
    namesMap.put("150", "Ulaya");
    namesMap.put("151", "Ulaya ya Mashariki");
    namesMap.put("154", "Ulaya ya Kaskazini");
    namesMap.put("155", "Ulaya ya Magharibi");
    namesMap.put("419", "Amerika ya Kilatini");
    namesMap.put("AC", "Kisiwa cha Ascension");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Falme za Kiarabu");
    namesMap.put("AF", "Afuganistani");
    namesMap.put("AG", "Antigua na Barbuda");
    namesMap.put("AN", "Antili za Uholanzi");
    namesMap.put("AQ", "Antaktika");
    namesMap.put("AR", "Ajentina");
    namesMap.put("AS", "Samoa ya Marekani");
    namesMap.put("AX", "Visiwa vya Alandi");
    namesMap.put("AZ", "Azabajani");
    namesMap.put("BA", "Bosnia na Hezegovina");
    namesMap.put("BB", "Babadosi");
    namesMap.put("BD", "Bangladeshi");
    namesMap.put("BE", "Ubelgiji");
    namesMap.put("BF", "Bukinafaso");
    namesMap.put("BH", "Bahareni");
    namesMap.put("BJ", "Benini");
    namesMap.put("BR", "Brazili");
    namesMap.put("BS", "Bahama");
    namesMap.put("BT", "Butani");
    namesMap.put("BV", "Kisiwa cha Bouvet");
    namesMap.put("BY", "Belarusi");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Visiwa vya Cocos [Keeling]");
    namesMap.put("CD", "Jamhuri ya Kidemokrasia ya Kongo");
    namesMap.put("CF", "Jamhuri ya Afrika ya Kati");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Uswisi");
    namesMap.put("CI", "Kodivaa");
    namesMap.put("CK", "Visiwa vya Cook");
    namesMap.put("CM", "Kameruni");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CP", "Kisiwa cha Clipperton");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CS", "Serbia na Montenegro");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kepuvede");
    namesMap.put("CX", "Kisiwa cha Krismasi");
    namesMap.put("CY", "Kuprosi");
    namesMap.put("CZ", "Jamhuri ya Cheki");
    namesMap.put("DE", "Ujerumani");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Denmaki");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Jamhuri ya Dominika");
    namesMap.put("DZ", "Aljeria");
    namesMap.put("EA", "Ceuta na Melilla");
    namesMap.put("EC", "Ekwado");
    namesMap.put("EG", "Misri");
    namesMap.put("EH", "Sahara Magharibi");
    namesMap.put("ES", "Hispania");
    namesMap.put("ET", "Uhabeshi");
    namesMap.put("EU", "Umoja wa Ulaya");
    namesMap.put("FI", "Ufini");
    namesMap.put("FK", "Visiwa vya Falkland");
    namesMap.put("FM", "Mikronesia");
    namesMap.put("FO", "Visiwa vya Faroe");
    namesMap.put("FR", "Ufaransa");
    namesMap.put("GA", "Gaboni");
    namesMap.put("GB", "Uingereza");
    namesMap.put("GE", "Jojia");
    namesMap.put("GF", "Gwiyana ya Ufaransa");
    namesMap.put("GI", "Jibralta");
    namesMap.put("GL", "Grinlandi");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Gwadelupe");
    namesMap.put("GQ", "Ginekweta");
    namesMap.put("GR", "Ugiriki");
    namesMap.put("GS", "Jojia Kusini na Visiwa vya Sandwich Kusini");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Ginebisau");
    namesMap.put("HK", "Hong Kong SAR China");
    namesMap.put("HM", "Kisiwa cha Heard na Visiwa vya McDonald");
    namesMap.put("HN", "Hondurasi");
    namesMap.put("HR", "Korasia");
    namesMap.put("HU", "Hungaria");
    namesMap.put("IC", "Visiwa vya Kanari");
    namesMap.put("IE", "Ayalandi");
    namesMap.put("IL", "Israeli");
    namesMap.put("IO", "Eneo la Uingereza katika Bahari Hindi");
    namesMap.put("IQ", "Iraki");
    namesMap.put("IR", "Uajemi");
    namesMap.put("IS", "Aislandi");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Yordani");
    namesMap.put("JP", "Japani");
    namesMap.put("KG", "Kirigizistani");
    namesMap.put("KH", "Kambodia");
    namesMap.put("KM", "Komoro");
    namesMap.put("KN", "Santakitzi na Nevis");
    namesMap.put("KP", "Korea Kaskazini");
    namesMap.put("KR", "Korea Kusini");
    namesMap.put("KW", "Kuwaiti");
    namesMap.put("KY", "Visiwa vya Kayman");
    namesMap.put("KZ", "Kazakistani");
    namesMap.put("LA", "Laosi");
    namesMap.put("LB", "Lebanoni");
    namesMap.put("LC", "Santalusia");
    namesMap.put("LI", "Lishenteni");
    namesMap.put("LK", "Sirilanka");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litwania");
    namesMap.put("LU", "Lasembagi");
    namesMap.put("LV", "Lativia");
    namesMap.put("MA", "Moroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MG", "Bukini");
    namesMap.put("MH", "Visiwa vya Marshal");
    namesMap.put("MK", "Masedonia");
    namesMap.put("MM", "Myama");
    namesMap.put("MO", "Macau SAR China");
    namesMap.put("MP", "Visiwa vya Mariana vya Kaskazini");
    namesMap.put("MQ", "Martiniki");
    namesMap.put("MR", "Moritania");
    namesMap.put("MS", "Montserrati");
    namesMap.put("MU", "Morisi");
    namesMap.put("MV", "Modivu");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malesia");
    namesMap.put("MZ", "Msumbiji");
    namesMap.put("NC", "Nyukaledonia");
    namesMap.put("NE", "Nijeri");
    namesMap.put("NF", "Kisiwa cha Norfok");
    namesMap.put("NG", "Nijeria");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Uholanzi");
    namesMap.put("NO", "Norwe");
    namesMap.put("NP", "Nepali");
    namesMap.put("NZ", "Nyuzilandi");
    namesMap.put("OM", "Omani");
    namesMap.put("PF", "Polinesia ya Ufaransa");
    namesMap.put("PG", "Papua");
    namesMap.put("PH", "Filipino");
    namesMap.put("PK", "Pakistani");
    namesMap.put("PL", "Polandi");
    namesMap.put("PM", "Santapieri na Mikeloni");
    namesMap.put("PN", "Pitkairni");
    namesMap.put("PR", "Pwetoriko");
    namesMap.put("PS", "Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina");
    namesMap.put("PT", "Ureno");
    namesMap.put("PY", "Paragwai");
    namesMap.put("QA", "Katari");
    namesMap.put("QO", "Oceania ya Nje");
    namesMap.put("RE", "Riyunioni");
    namesMap.put("RU", "Urusi");
    namesMap.put("SA", "Saudi");
    namesMap.put("SB", "Visiwa vya Solomon");
    namesMap.put("SC", "Shelisheli");
    namesMap.put("SD", "Sudani");
    namesMap.put("SE", "Uswidi");
    namesMap.put("SG", "Singapoo");
    namesMap.put("SH", "Santahelena");
    namesMap.put("SJ", "Svalbard na Jan Mayen");
    namesMap.put("SL", "Siera Leoni");
    namesMap.put("SM", "Samarino");
    namesMap.put("SN", "Senegali");
    namesMap.put("SR", "Surinamu");
    namesMap.put("ST", "Sao Tome na Principe");
    namesMap.put("SV", "Elsavado");
    namesMap.put("SY", "Siria");
    namesMap.put("SZ", "Uswazi");
    namesMap.put("TC", "Visiwa vya Turki na Kaiko");
    namesMap.put("TD", "Chadi");
    namesMap.put("TF", "Maeneo ya Kusini ya Ufaransa");
    namesMap.put("TH", "Tailandi");
    namesMap.put("TJ", "Tajikistani");
    namesMap.put("TL", "Timori ya Mashariki");
    namesMap.put("TM", "Turukimenistani");
    namesMap.put("TR", "Uturuki");
    namesMap.put("TT", "Trinidad na Tobago");
    namesMap.put("TW", "Taiwani");
    namesMap.put("UA", "Ukraini");
    namesMap.put("UM", "Visiwa Vidogo vya Nje vya Marekani");
    namesMap.put("US", "Marekani");
    namesMap.put("UY", "Urugwai");
    namesMap.put("UZ", "Uzibekistani");
    namesMap.put("VA", "Vatikani");
    namesMap.put("VC", "Santavisenti na Grenadini");
    namesMap.put("VG", "Visiwa vya Virgin vya Uingereza");
    namesMap.put("VI", "Visiwa vya Virgin vya Marekani");
    namesMap.put("VN", "Vietinamu");
    namesMap.put("WF", "Walis na Futuna");
    namesMap.put("YE", "Yemeni");
    namesMap.put("ZA", "Afrika Kusini");
    namesMap.put("ZZ", "Eneo lisilojulikana");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dunia",
        "002": "Afrika",
        "003": "Amerika Kaskazini",
        "005": "Amerika Kusini",
        "011": "Afrika ya Magharibi",
        "013": "Amerika ya Kati",
        "014": "Afrika ya Mashariki",
        "015": "Afrika ya Kaskazini",
        "017": "Afrika ya Kati",
        "018": "Afrika ya Kusini",
        "019": "Amerika",
        "021": "Amerika ya Kaskazini",
        "029": "Karibi",
        "030": "Asia Mashariki",
        "034": "Asia ya Kusini",
        "035": "Asia ya Kusini Mashariki",
        "039": "Ulaya ya Kusini",
        "053": "Australia na New Zealand",
        "057": "Eneo la Mikronesia",
        "143": "Asia ya Kati",
        "145": "Asia ya Magharibi",
        "150": "Ulaya",
        "151": "Ulaya ya Mashariki",
        "154": "Ulaya ya Kaskazini",
        "155": "Ulaya ya Magharibi",
        "419": "Amerika ya Kilatini",
        "AC": "Kisiwa cha Ascension",
        "AD": "Andora",
        "AE": "Falme za Kiarabu",
        "AF": "Afuganistani",
        "AG": "Antigua na Barbuda",
        "AN": "Antili za Uholanzi",
        "AQ": "Antaktika",
        "AR": "Ajentina",
        "AS": "Samoa ya Marekani",
        "AX": "Visiwa vya Alandi",
        "AZ": "Azabajani",
        "BA": "Bosnia na Hezegovina",
        "BB": "Babadosi",
        "BD": "Bangladeshi",
        "BE": "Ubelgiji",
        "BF": "Bukinafaso",
        "BH": "Bahareni",
        "BJ": "Benini",
        "BR": "Brazili",
        "BS": "Bahama",
        "BT": "Butani",
        "BV": "Kisiwa cha Bouvet",
        "BY": "Belarusi",
        "CA": "Kanada",
        "CC": "Visiwa vya Cocos [Keeling]",
        "CD": "Jamhuri ya Kidemokrasia ya Kongo",
        "CF": "Jamhuri ya Afrika ya Kati",
        "CG": "Kongo",
        "CH": "Uswisi",
        "CI": "Kodivaa",
        "CK": "Visiwa vya Cook",
        "CM": "Kameruni",
        "CO": "Kolombia",
        "CP": "Kisiwa cha Clipperton",
        "CR": "Kostarika",
        "CS": "Serbia na Montenegro",
        "CU": "Kuba",
        "CV": "Kepuvede",
        "CX": "Kisiwa cha Krismasi",
        "CY": "Kuprosi",
        "CZ": "Jamhuri ya Cheki",
        "DE": "Ujerumani",
        "DJ": "Jibuti",
        "DK": "Denmaki",
        "DM": "Dominika",
        "DO": "Jamhuri ya Dominika",
        "DZ": "Aljeria",
        "EA": "Ceuta na Melilla",
        "EC": "Ekwado",
        "EG": "Misri",
        "EH": "Sahara Magharibi",
        "ES": "Hispania",
        "ET": "Uhabeshi",
        "EU": "Umoja wa Ulaya",
        "FI": "Ufini",
        "FK": "Visiwa vya Falkland",
        "FM": "Mikronesia",
        "FO": "Visiwa vya Faroe",
        "FR": "Ufaransa",
        "GA": "Gaboni",
        "GB": "Uingereza",
        "GE": "Jojia",
        "GF": "Gwiyana ya Ufaransa",
        "GI": "Jibralta",
        "GL": "Grinlandi",
        "GN": "Gine",
        "GP": "Gwadelupe",
        "GQ": "Ginekweta",
        "GR": "Ugiriki",
        "GS": "Jojia Kusini na Visiwa vya Sandwich Kusini",
        "GT": "Gwatemala",
        "GU": "Gwam",
        "GW": "Ginebisau",
        "HK": "Hong Kong SAR China",
        "HM": "Kisiwa cha Heard na Visiwa vya McDonald",
        "HN": "Hondurasi",
        "HR": "Korasia",
        "HU": "Hungaria",
        "IC": "Visiwa vya Kanari",
        "IE": "Ayalandi",
        "IL": "Israeli",
        "IO": "Eneo la Uingereza katika Bahari Hindi",
        "IQ": "Iraki",
        "IR": "Uajemi",
        "IS": "Aislandi",
        "IT": "Italia",
        "JM": "Jamaika",
        "JO": "Yordani",
        "JP": "Japani",
        "KG": "Kirigizistani",
        "KH": "Kambodia",
        "KM": "Komoro",
        "KN": "Santakitzi na Nevis",
        "KP": "Korea Kaskazini",
        "KR": "Korea Kusini",
        "KW": "Kuwaiti",
        "KY": "Visiwa vya Kayman",
        "KZ": "Kazakistani",
        "LA": "Laosi",
        "LB": "Lebanoni",
        "LC": "Santalusia",
        "LI": "Lishenteni",
        "LK": "Sirilanka",
        "LS": "Lesoto",
        "LT": "Litwania",
        "LU": "Lasembagi",
        "LV": "Lativia",
        "MA": "Moroko",
        "MC": "Monako",
        "MG": "Bukini",
        "MH": "Visiwa vya Marshal",
        "MK": "Masedonia",
        "MM": "Myama",
        "MO": "Macau SAR China",
        "MP": "Visiwa vya Mariana vya Kaskazini",
        "MQ": "Martiniki",
        "MR": "Moritania",
        "MS": "Montserrati",
        "MU": "Morisi",
        "MV": "Modivu",
        "MX": "Meksiko",
        "MY": "Malesia",
        "MZ": "Msumbiji",
        "NC": "Nyukaledonia",
        "NE": "Nijeri",
        "NF": "Kisiwa cha Norfok",
        "NG": "Nijeria",
        "NI": "Nikaragwa",
        "NL": "Uholanzi",
        "NO": "Norwe",
        "NP": "Nepali",
        "NZ": "Nyuzilandi",
        "OM": "Omani",
        "PF": "Polinesia ya Ufaransa",
        "PG": "Papua",
        "PH": "Filipino",
        "PK": "Pakistani",
        "PL": "Polandi",
        "PM": "Santapieri na Mikeloni",
        "PN": "Pitkairni",
        "PR": "Pwetoriko",
        "PS": "Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina",
        "PT": "Ureno",
        "PY": "Paragwai",
        "QA": "Katari",
        "QO": "Oceania ya Nje",
        "RE": "Riyunioni",
        "RU": "Urusi",
        "SA": "Saudi",
        "SB": "Visiwa vya Solomon",
        "SC": "Shelisheli",
        "SD": "Sudani",
        "SE": "Uswidi",
        "SG": "Singapoo",
        "SH": "Santahelena",
        "SJ": "Svalbard na Jan Mayen",
        "SL": "Siera Leoni",
        "SM": "Samarino",
        "SN": "Senegali",
        "SR": "Surinamu",
        "ST": "Sao Tome na Principe",
        "SV": "Elsavado",
        "SY": "Siria",
        "SZ": "Uswazi",
        "TC": "Visiwa vya Turki na Kaiko",
        "TD": "Chadi",
        "TF": "Maeneo ya Kusini ya Ufaransa",
        "TH": "Tailandi",
        "TJ": "Tajikistani",
        "TL": "Timori ya Mashariki",
        "TM": "Turukimenistani",
        "TR": "Uturuki",
        "TT": "Trinidad na Tobago",
        "TW": "Taiwani",
        "UA": "Ukraini",
        "UM": "Visiwa Vidogo vya Nje vya Marekani",
        "US": "Marekani",
        "UY": "Urugwai",
        "UZ": "Uzibekistani",
        "VA": "Vatikani",
        "VC": "Santavisenti na Grenadini",
        "VG": "Visiwa vya Virgin vya Uingereza",
        "VI": "Visiwa vya Virgin vya Marekani",
        "VN": "Vietinamu",
        "WF": "Walis na Futuna",
        "YE": "Yemeni",
        "ZA": "Afrika Kusini",
        "ZZ": "Eneo lisilojulikana"
    };
  }-*/;
}
