/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "gl" locale.
 */
public class LocalizedNamesImpl_gl extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ES",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AZ",
        "AF",
        "AL",
        "DE",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "SA",
        "AM",
        "AW",
        "DZ",
        "AR",
        "AU",
        "AT",
        "BS",
        "BH",
        "BD",
        "BB",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BY",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "CV",
        "KH",
        "CM",
        "CA",
        "EA",
        "TD",
        "CL",
        "CN",
        "CY",
        "VA",
        "ZW",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "CW",
        "DG",
        "DK",
        "DM",
        "EC",
        "SV",
        "AE",
        "ER",
        "SK",
        "SI",
        "ES",
        "US",
        "EE",
        "ET",
        "EG",
        "PH",
        "FI",
        "FJ",
        "FR",
        "GA",
        "GM",
        "GH",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GY",
        "GF",
        "GN",
        "GW",
        "GQ",
        "HT",
        "HN",
        "HK",
        "HU",
        "YE",
        "BV",
        "CX",
        "CP",
        "AC",
        "IM",
        "HM",
        "NF",
        "AX",
        "KY",
        "IC",
        "CC",
        "CK",
        "FO",
        "FK",
        "MP",
        "MH",
        "UM",
        "SB",
        "TC",
        "VG",
        "VI",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IS",
        "IL",
        "IT",
        "JE",
        "KZ",
        "KI",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NU",
        "NE",
        "NG",
        "NO",
        "NC",
        "NZ",
        "QO",
        "OM",
        "NL",
        "PW",
        "PS",
        "PA",
        "PG",
        "PK",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PR",
        "PT",
        "QA",
        "KE",
        "KG",
        "GB",
        "CF",
        "CZ",
        "CD",
        "DO",
        "RE",
        "RO",
        "RW",
        "RU",
        "EH",
        "WS",
        "AS",
        "BL",
        "KN",
        "SM",
        "MF",
        "PM",
        "SH",
        "LC",
        "ST",
        "VC",
        "SC",
        "SN",
        "RS",
        "CS",
        "SL",
        "SG",
        "SY",
        "SO",
        "LK",
        "SS",
        "SZ",
        "ZA",
        "SD",
        "SE",
        "CH",
        "SR",
        "SJ",
        "SX",
        "TH",
        "TW",
        "TZ",
        "TJ",
        "IO",
        "TF",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "UA",
        "UG",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "JM",
        "JP",
        "GE",
        "GS",
        "GI",
        "DJ",
        "JO",
        "ZM",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mundo");
    namesMap.put("002", "África");
    namesMap.put("003", "Norteamérica");
    namesMap.put("005", "Sudamérica");
    namesMap.put("009", "Oceanía");
    namesMap.put("011", "África Occidental");
    namesMap.put("013", "América Central");
    namesMap.put("014", "África Oriental");
    namesMap.put("015", "África Septentrional");
    namesMap.put("017", "África Central");
    namesMap.put("018", "África Meridional");
    namesMap.put("019", "América");
    namesMap.put("021", "América do Norte");
    namesMap.put("029", "Caribe");
    namesMap.put("030", "Asia Oriental");
    namesMap.put("034", "Sul de Asia");
    namesMap.put("035", "Sureste Asiático");
    namesMap.put("039", "Europa Meridional");
    namesMap.put("053", "Australia e Nova Celandia");
    namesMap.put("057", "Rexión da Micronesia");
    namesMap.put("061", "Polinesia");
    namesMap.put("143", "Asia Central");
    namesMap.put("145", "Asia Occidental");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa do Leste");
    namesMap.put("154", "Europa Septentrional");
    namesMap.put("155", "Europa Occidental");
    namesMap.put("419", "América Latina");
    namesMap.put("AC", "Illa de Ascensión");
    namesMap.put("AE", "Emiratos Árabes Unidos");
    namesMap.put("AF", "Afganistán");
    namesMap.put("AG", "Antiga e Barbuda");
    namesMap.put("AI", "Anguila");
    namesMap.put("AN", "Antillas Holandesas");
    namesMap.put("AQ", "Antártida");
    namesMap.put("AR", "Arxentina");
    namesMap.put("AS", "Samoa Americana");
    namesMap.put("AX", "Illas Aland");
    namesMap.put("AZ", "Acerbaixán");
    namesMap.put("BA", "Bosnia e Hercegovina");
    namesMap.put("BE", "Bélxica");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BL", "San Bartolomé");
    namesMap.put("BM", "Bermudas");
    namesMap.put("BR", "Brasil");
    namesMap.put("BT", "Bután");
    namesMap.put("BV", "Illa Bouvet");
    namesMap.put("BW", "Botsuana");
    namesMap.put("BY", "Bielorrusia");
    namesMap.put("BZ", "Belice");
    namesMap.put("CA", "Canadá");
    namesMap.put("CC", "Illas Cocos");
    namesMap.put("CD", "República Democrática do Congo");
    namesMap.put("CF", "República Africana Central");
    namesMap.put("CG", "Congo");
    namesMap.put("CH", "Suíza");
    namesMap.put("CI", "Costa de Marfil");
    namesMap.put("CK", "Illas Cook");
    namesMap.put("CM", "Camerún");
    namesMap.put("CP", "Illa Clipperton");
    namesMap.put("CS", "Serbia e Montenegro");
    namesMap.put("CV", "Cabo Verde");
    namesMap.put("CX", "Illa Christmas");
    namesMap.put("CY", "Chipre");
    namesMap.put("CZ", "República Checa");
    namesMap.put("DE", "Alemaña");
    namesMap.put("DG", "Diego García");
    namesMap.put("DJ", "Xibuti");
    namesMap.put("DK", "Dinamarca");
    namesMap.put("DO", "República Dominicana");
    namesMap.put("DZ", "Arxelia");
    namesMap.put("EA", "Ceuta e Melilla");
    namesMap.put("EG", "Exipto");
    namesMap.put("EH", "Sahara Occidental");
    namesMap.put("ES", "España");
    namesMap.put("ET", "Etiopía");
    namesMap.put("EU", "Unión Europea");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FJ", "Fixi");
    namesMap.put("FK", "Illas Malvinas");
    namesMap.put("FO", "Illas Feroe");
    namesMap.put("FR", "Francia");
    namesMap.put("GA", "Gabón");
    namesMap.put("GB", "Reino Unido");
    namesMap.put("GD", "Granada");
    namesMap.put("GE", "Xeorxia");
    namesMap.put("GF", "Güiana Francesa");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Xibraltar");
    namesMap.put("GL", "Grenlandia");
    namesMap.put("GP", "Guadalupe");
    namesMap.put("GQ", "Guinea Ecuatorial");
    namesMap.put("GR", "Grecia");
    namesMap.put("GS", "Xeorxia do Sur e Illas Sandwich");
    namesMap.put("GY", "Güiana");
    namesMap.put("HM", "Illa Heard e Illas McDonald");
    namesMap.put("HR", "Croacia");
    namesMap.put("HT", "Haití");
    namesMap.put("HU", "Hungría");
    namesMap.put("IC", "Illas Canarias");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Illa de Man");
    namesMap.put("IO", "Territorio Británico do Océano Índico");
    namesMap.put("IR", "Irán");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Xamaica");
    namesMap.put("JO", "Xordania");
    namesMap.put("JP", "Xapón");
    namesMap.put("KE", "Quenia");
    namesMap.put("KG", "Quirguicistán");
    namesMap.put("KM", "Comores");
    namesMap.put("KN", "San Cristovo e Nevis");
    namesMap.put("KP", "Corea do Norte");
    namesMap.put("KR", "Corea do Sur");
    namesMap.put("KY", "Illas Caimán");
    namesMap.put("LB", "Líbano");
    namesMap.put("LC", "Santa Lucía");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luxemburgo");
    namesMap.put("LV", "Letonia");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Marrocos");
    namesMap.put("MC", "Mónaco");
    namesMap.put("MF", "San Martiño");
    namesMap.put("MH", "Illas Marshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MP", "Illas Marianas do norte");
    namesMap.put("MQ", "Martinica");
    namesMap.put("MU", "Mauricio");
    namesMap.put("MV", "Maldivas");
    namesMap.put("MW", "Malaui");
    namesMap.put("MX", "México");
    namesMap.put("MY", "Malaisia");
    namesMap.put("NC", "Nova Caledonia");
    namesMap.put("NE", "Níxer");
    namesMap.put("NF", "Illa Norfolk");
    namesMap.put("NG", "Nixeria");
    namesMap.put("NL", "Países Baixos");
    namesMap.put("NO", "Noruega");
    namesMap.put("NZ", "Nova Celandia");
    namesMap.put("OM", "Omán");
    namesMap.put("PA", "Panamá");
    namesMap.put("PE", "Perú");
    namesMap.put("PF", "Polinesia Francesa");
    namesMap.put("PG", "Papúa Nova Guinea");
    namesMap.put("PH", "Filipinas");
    namesMap.put("PK", "Paquistán");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "San Pedro e Miguelón");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Porto Rico");
    namesMap.put("PS", "Palestina");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QO", "Oceanía Distante");
    namesMap.put("RE", "Reunión");
    namesMap.put("RO", "Romanía");
    namesMap.put("RU", "Rusia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arabia Saudita");
    namesMap.put("SB", "Illas Salomón");
    namesMap.put("SC", "Seixeles");
    namesMap.put("SD", "Sudán");
    namesMap.put("SE", "Suecia");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Santa Helena");
    namesMap.put("SI", "Eslovenia");
    namesMap.put("SJ", "Svalbard e Jan Mayen");
    namesMap.put("SK", "Eslovaquia");
    namesMap.put("SL", "Serra Leoa");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Santo Tomé e Príncipe");
    namesMap.put("SY", "Siria");
    namesMap.put("SZ", "Suacilandia");
    namesMap.put("TA", "Tristán da Cunha");
    namesMap.put("TC", "Illas Turks e Caicos");
    namesMap.put("TF", "Territorios Franceses do Sul");
    namesMap.put("TH", "Tailandia");
    namesMap.put("TJ", "Taxiquistán");
    namesMap.put("TL", "Timor Leste");
    namesMap.put("TM", "Turkmenistán");
    namesMap.put("TR", "Turquía");
    namesMap.put("TT", "Trindade e Tobago");
    namesMap.put("TW", "Taiwán");
    namesMap.put("UA", "Ucraína");
    namesMap.put("UM", "Illas Menores Distantes dos EUA.");
    namesMap.put("US", "Estados Unidos de América");
    namesMap.put("UY", "Uruguai");
    namesMap.put("UZ", "Uzbekistán");
    namesMap.put("VA", "Cidade do Vaticano");
    namesMap.put("VC", "San Vicente e Granadinas");
    namesMap.put("VG", "Illas Virxes Británicas");
    namesMap.put("VI", "Illas Virxes Estadounidenses");
    namesMap.put("WF", "Wallis e Futuna");
    namesMap.put("YE", "Iemen");
    namesMap.put("ZA", "Sudáfrica");
    namesMap.put("ZW", "Cimbabue");
    namesMap.put("ZZ", "rexión descoñecida");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mundo",
        "002": "África",
        "003": "Norteamérica",
        "005": "Sudamérica",
        "009": "Oceanía",
        "011": "África Occidental",
        "013": "América Central",
        "014": "África Oriental",
        "015": "África Septentrional",
        "017": "África Central",
        "018": "África Meridional",
        "019": "América",
        "021": "América do Norte",
        "029": "Caribe",
        "030": "Asia Oriental",
        "034": "Sul de Asia",
        "035": "Sureste Asiático",
        "039": "Europa Meridional",
        "053": "Australia e Nova Celandia",
        "057": "Rexión da Micronesia",
        "061": "Polinesia",
        "143": "Asia Central",
        "145": "Asia Occidental",
        "150": "Europa",
        "151": "Europa do Leste",
        "154": "Europa Septentrional",
        "155": "Europa Occidental",
        "419": "América Latina",
        "AC": "Illa de Ascensión",
        "AE": "Emiratos Árabes Unidos",
        "AF": "Afganistán",
        "AG": "Antiga e Barbuda",
        "AI": "Anguila",
        "AN": "Antillas Holandesas",
        "AQ": "Antártida",
        "AR": "Arxentina",
        "AS": "Samoa Americana",
        "AX": "Illas Aland",
        "AZ": "Acerbaixán",
        "BA": "Bosnia e Hercegovina",
        "BE": "Bélxica",
        "BH": "Bahrein",
        "BL": "San Bartolomé",
        "BM": "Bermudas",
        "BR": "Brasil",
        "BT": "Bután",
        "BV": "Illa Bouvet",
        "BW": "Botsuana",
        "BY": "Bielorrusia",
        "BZ": "Belice",
        "CA": "Canadá",
        "CC": "Illas Cocos",
        "CD": "República Democrática do Congo",
        "CF": "República Africana Central",
        "CG": "Congo",
        "CH": "Suíza",
        "CI": "Costa de Marfil",
        "CK": "Illas Cook",
        "CM": "Camerún",
        "CP": "Illa Clipperton",
        "CS": "Serbia e Montenegro",
        "CV": "Cabo Verde",
        "CX": "Illa Christmas",
        "CY": "Chipre",
        "CZ": "República Checa",
        "DE": "Alemaña",
        "DG": "Diego García",
        "DJ": "Xibuti",
        "DK": "Dinamarca",
        "DO": "República Dominicana",
        "DZ": "Arxelia",
        "EA": "Ceuta e Melilla",
        "EG": "Exipto",
        "EH": "Sahara Occidental",
        "ES": "España",
        "ET": "Etiopía",
        "EU": "Unión Europea",
        "FI": "Finlandia",
        "FJ": "Fixi",
        "FK": "Illas Malvinas",
        "FO": "Illas Feroe",
        "FR": "Francia",
        "GA": "Gabón",
        "GB": "Reino Unido",
        "GD": "Granada",
        "GE": "Xeorxia",
        "GF": "Güiana Francesa",
        "GH": "Gana",
        "GI": "Xibraltar",
        "GL": "Grenlandia",
        "GP": "Guadalupe",
        "GQ": "Guinea Ecuatorial",
        "GR": "Grecia",
        "GS": "Xeorxia do Sur e Illas Sandwich",
        "GY": "Güiana",
        "HM": "Illa Heard e Illas McDonald",
        "HR": "Croacia",
        "HT": "Haití",
        "HU": "Hungría",
        "IC": "Illas Canarias",
        "IE": "Irlanda",
        "IM": "Illa de Man",
        "IO": "Territorio Británico do Océano Índico",
        "IR": "Irán",
        "IS": "Islandia",
        "IT": "Italia",
        "JM": "Xamaica",
        "JO": "Xordania",
        "JP": "Xapón",
        "KE": "Quenia",
        "KG": "Quirguicistán",
        "KM": "Comores",
        "KN": "San Cristovo e Nevis",
        "KP": "Corea do Norte",
        "KR": "Corea do Sur",
        "KY": "Illas Caimán",
        "LB": "Líbano",
        "LC": "Santa Lucía",
        "LT": "Lituania",
        "LU": "Luxemburgo",
        "LV": "Letonia",
        "LY": "Libia",
        "MA": "Marrocos",
        "MC": "Mónaco",
        "MF": "San Martiño",
        "MH": "Illas Marshall",
        "MK": "Macedonia",
        "MM": "Myanmar",
        "MP": "Illas Marianas do norte",
        "MQ": "Martinica",
        "MU": "Mauricio",
        "MV": "Maldivas",
        "MW": "Malaui",
        "MX": "México",
        "MY": "Malaisia",
        "NC": "Nova Caledonia",
        "NE": "Níxer",
        "NF": "Illa Norfolk",
        "NG": "Nixeria",
        "NL": "Países Baixos",
        "NO": "Noruega",
        "NZ": "Nova Celandia",
        "OM": "Omán",
        "PA": "Panamá",
        "PE": "Perú",
        "PF": "Polinesia Francesa",
        "PG": "Papúa Nova Guinea",
        "PH": "Filipinas",
        "PK": "Paquistán",
        "PL": "Polonia",
        "PM": "San Pedro e Miguelón",
        "PN": "Pitcairn",
        "PR": "Porto Rico",
        "PS": "Palestina",
        "PY": "Paraguai",
        "QO": "Oceanía Distante",
        "RE": "Reunión",
        "RO": "Romanía",
        "RU": "Rusia",
        "RW": "Ruanda",
        "SA": "Arabia Saudita",
        "SB": "Illas Salomón",
        "SC": "Seixeles",
        "SD": "Sudán",
        "SE": "Suecia",
        "SG": "Singapur",
        "SH": "Santa Helena",
        "SI": "Eslovenia",
        "SJ": "Svalbard e Jan Mayen",
        "SK": "Eslovaquia",
        "SL": "Serra Leoa",
        "SR": "Surinam",
        "ST": "Santo Tomé e Príncipe",
        "SY": "Siria",
        "SZ": "Suacilandia",
        "TA": "Tristán da Cunha",
        "TC": "Illas Turks e Caicos",
        "TF": "Territorios Franceses do Sul",
        "TH": "Tailandia",
        "TJ": "Taxiquistán",
        "TL": "Timor Leste",
        "TM": "Turkmenistán",
        "TR": "Turquía",
        "TT": "Trindade e Tobago",
        "TW": "Taiwán",
        "UA": "Ucraína",
        "UM": "Illas Menores Distantes dos EUA.",
        "US": "Estados Unidos de América",
        "UY": "Uruguai",
        "UZ": "Uzbekistán",
        "VA": "Cidade do Vaticano",
        "VC": "San Vicente e Granadinas",
        "VG": "Illas Virxes Británicas",
        "VI": "Illas Virxes Estadounidenses",
        "WF": "Wallis e Futuna",
        "YE": "Iemen",
        "ZA": "Sudáfrica",
        "ZW": "Cimbabue",
        "ZZ": "rexión descoñecida"
    };
  }-*/;
}
