/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ast" locale.
 */
public class LocalizedNamesImpl_ast extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DE",
        "AD",
        "AO",
        "AI",
        "AG",
        "SA",
        "HK",
        "MO",
        "AM",
        "AW",
        "DZ",
        "AR",
        "AU",
        "AT",
        "AZ",
        "BH",
        "BD",
        "BB",
        "BZ",
        "BE",
        "BJ",
        "BY",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "CV",
        "KH",
        "CM",
        "CA",
        "BQ",
        "EA",
        "TD",
        "CZ",
        "CL",
        "CN",
        "VA",
        "CO",
        "CG",
        "CD",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "CW",
        "DG",
        "DK",
        "DM",
        "EC",
        "NE",
        "SV",
        "AE",
        "ER",
        "SK",
        "SI",
        "ES",
        "US",
        "EE",
        "ET",
        "EG",
        "FK",
        "PH",
        "FI",
        "FR",
        "GA",
        "GM",
        "GH",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "HT",
        "HN",
        "HU",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IS",
        "AC",
        "BV",
        "CX",
        "CP",
        "IM",
        "HM",
        "NF",
        "AX",
        "KY",
        "IC",
        "CC",
        "CK",
        "FO",
        "FJ",
        "MP",
        "MH",
        "UM",
        "PN",
        "SB",
        "TC",
        "VI",
        "VG",
        "GS",
        "IL",
        "IT",
        "JE",
        "KZ",
        "KE",
        "KG",
        "KI",
        "KW",
        "AQ",
        "MQ",
        "LA",
        "BS",
        "BM",
        "KM",
        "MV",
        "LS",
        "SC",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MY",
        "MW",
        "ML",
        "MT",
        "MA",
        "MU",
        "MR",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NU",
        "NG",
        "NO",
        "NC",
        "NZ",
        "QO",
        "OM",
        "NL",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PF",
        "PL",
        "PT",
        "PR",
        "QA",
        "GB",
        "CF",
        "DO",
        "RE",
        "RW",
        "RO",
        "RU",
        "EH",
        "KN",
        "MF",
        "PM",
        "WS",
        "AS",
        "BL",
        "SM",
        "SH",
        "LC",
        "ST",
        "VC",
        "SN",
        "RS",
        "SL",
        "SG",
        "SX",
        "SY",
        "SO",
        "LK",
        "SZ",
        "ZA",
        "SD",
        "SS",
        "SE",
        "CH",
        "SR",
        "SJ",
        "TH",
        "TW",
        "TZ",
        "TJ",
        "IO",
        "TF",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "UA",
        "UG",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "JM",
        "JP",
        "GE",
        "GI",
        "DJ",
        "CY",
        "XK",
        "JO",
        "EU",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mundu");
    namesMap.put("002", "África");
    namesMap.put("003", "Norteamérica");
    namesMap.put("005", "América del Sur");
    namesMap.put("009", "Oceanía");
    namesMap.put("011", "África Occidental");
    namesMap.put("013", "América Central");
    namesMap.put("014", "África Oriental");
    namesMap.put("015", "África del Norte");
    namesMap.put("017", "África Central");
    namesMap.put("018", "África del Sur");
    namesMap.put("019", "América");
    namesMap.put("021", "América del Norte");
    namesMap.put("029", "Caribe");
    namesMap.put("030", "Asia Oriental");
    namesMap.put("034", "Asia del Sur");
    namesMap.put("035", "Sureste Asiáticu");
    namesMap.put("039", "Europa del Sur");
    namesMap.put("057", "Rexón de Micronesia");
    namesMap.put("061", "Polinesia");
    namesMap.put("143", "Asia Central");
    namesMap.put("145", "Asia Occidental");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa Oriental");
    namesMap.put("154", "Europa del Norte");
    namesMap.put("155", "Europa Occidental");
    namesMap.put("419", "América Llatina");
    namesMap.put("AC", "Islla Ascensión");
    namesMap.put("AE", "Emiratos Árabes Xuníos");
    namesMap.put("AF", "Afganistán");
    namesMap.put("AG", "Antigua y Barbuda");
    namesMap.put("AI", "Anguila");
    namesMap.put("AQ", "L'Antártida");
    namesMap.put("AR", "Arxentina");
    namesMap.put("AS", "Samoa Americana");
    namesMap.put("AX", "Islles Aland");
    namesMap.put("AZ", "Azerbaixán");
    namesMap.put("BA", "Bosnia y Herzegovina");
    namesMap.put("BD", "Bangladex");
    namesMap.put("BE", "Bélxica");
    namesMap.put("BF", "Burkina Fasu");
    namesMap.put("BH", "Baḥréin");
    namesMap.put("BJ", "Benín");
    namesMap.put("BL", "San Bartolomé");
    namesMap.put("BM", "Les Bermudes");
    namesMap.put("BN", "Brunéi");
    namesMap.put("BQ", "Caribe neerlandés");
    namesMap.put("BR", "Brasil");
    namesMap.put("BS", "Les Bahames");
    namesMap.put("BT", "Bután");
    namesMap.put("BV", "Islla Bouvet");
    namesMap.put("BW", "Botsuana");
    namesMap.put("BY", "Bielorrusia");
    namesMap.put("CA", "Canadá");
    namesMap.put("CC", "Islles Cocos (Keeling)");
    namesMap.put("CD", "Congu - Kinxasa");
    namesMap.put("CF", "República Centroafricana");
    namesMap.put("CG", "Congu - Brazzaville");
    namesMap.put("CH", "Suiza");
    namesMap.put("CI", "Costa de Marfil");
    namesMap.put("CK", "Islles Cook");
    namesMap.put("CM", "Camerún");
    namesMap.put("CP", "Islla Clipperton");
    namesMap.put("CV", "Cabu Verde");
    namesMap.put("CX", "Islla Christmas");
    namesMap.put("CY", "Xipre");
    namesMap.put("CZ", "Chequia");
    namesMap.put("DE", "Alemania");
    namesMap.put("DJ", "Xibuti");
    namesMap.put("DK", "Dinamarca");
    namesMap.put("DO", "República Dominicana");
    namesMap.put("DZ", "Arxelia");
    namesMap.put("EA", "Ceuta y Melilla");
    namesMap.put("EG", "Exiptu");
    namesMap.put("EH", "Sáḥara Occidental");
    namesMap.put("ES", "España");
    namesMap.put("ET", "Etiopía");
    namesMap.put("EU", "Xunión Européa");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FJ", "Islles Fixi");
    namesMap.put("FK", "Falkland Islands");
    namesMap.put("FO", "Islles Feroe");
    namesMap.put("FR", "Francia");
    namesMap.put("GA", "Gabón");
    namesMap.put("GB", "Reinu Xuníu");
    namesMap.put("GD", "Granada");
    namesMap.put("GE", "Xeorxa");
    namesMap.put("GF", "Guyana Francesa");
    namesMap.put("GI", "Xibraltar");
    namesMap.put("GL", "Groenlandia");
    namesMap.put("GP", "Guadalupe");
    namesMap.put("GQ", "Guinea Ecuatorial");
    namesMap.put("GR", "Grecia");
    namesMap.put("GS", "Islles Xeorxa del Sur y Sandwich del Sur");
    namesMap.put("GW", "Guinea-Bisáu");
    namesMap.put("HK", "ARE China de Ḥong Kong");
    namesMap.put("HM", "Islla Ḥeard ya Islles McDonald");
    namesMap.put("HN", "Hondures");
    namesMap.put("HR", "Croacia");
    namesMap.put("HT", "Haití");
    namesMap.put("HU", "Hungría");
    namesMap.put("IC", "Islles Canaries");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Islla de Man");
    namesMap.put("IO", "Territoriu Británicu del Océanu Índicu");
    namesMap.put("IR", "Irán");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Xamaica");
    namesMap.put("JO", "Xordania");
    namesMap.put("JP", "Xapón");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirguistán");
    namesMap.put("KH", "Camboya");
    namesMap.put("KM", "Les Comores");
    namesMap.put("KN", "Saint Kitts y Nevis");
    namesMap.put("KP", "Corea del Norte");
    namesMap.put("KR", "Corea del Sur");
    namesMap.put("KY", "Islles Caimán");
    namesMap.put("KZ", "Kazakstán");
    namesMap.put("LB", "Líbanu");
    namesMap.put("LC", "Santa Llucía");
    namesMap.put("LS", "Lesothu");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luxemburgu");
    namesMap.put("LV", "Letonia");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Marruecos");
    namesMap.put("MC", "Mónacu");
    namesMap.put("MD", "Moldavia");
    namesMap.put("ME", "Montenegru");
    namesMap.put("MH", "Islles Marshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("ML", "Malí");
    namesMap.put("MM", "Myanmar (Birmania)");
    namesMap.put("MO", "ARE China de Macáu");
    namesMap.put("MP", "Islles Marianes del Norte");
    namesMap.put("MQ", "La Martinica");
    namesMap.put("MU", "Mauriciu");
    namesMap.put("MV", "Les Maldives");
    namesMap.put("MW", "Malaui");
    namesMap.put("MX", "Méxicu");
    namesMap.put("MY", "Malasia");
    namesMap.put("NC", "Nueva Caledonia");
    namesMap.put("NE", "El Níxer");
    namesMap.put("NF", "Islla Norfolk");
    namesMap.put("NG", "Nixeria");
    namesMap.put("NL", "Países Baxos");
    namesMap.put("NO", "Noruega");
    namesMap.put("NZ", "Nueva Zelanda");
    namesMap.put("OM", "Omán");
    namesMap.put("PA", "Panamá");
    namesMap.put("PE", "Perú");
    namesMap.put("PF", "Polinesia Francesa");
    namesMap.put("PG", "Papúa Nueva Guinea");
    namesMap.put("PH", "Filipines");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "Saint Pierre y Miquelon");
    namesMap.put("PN", "Islles Pitcairn");
    namesMap.put("PR", "Puertu Ricu");
    namesMap.put("PS", "Palestina");
    namesMap.put("PW", "Paláu");
    namesMap.put("QO", "Oceanía esterior");
    namesMap.put("RE", "Reunión");
    namesMap.put("RO", "Rumanía");
    namesMap.put("RU", "Rusia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arabia Saudita");
    namesMap.put("SB", "Islles Salomón");
    namesMap.put("SC", "Les Seixeles");
    namesMap.put("SD", "Sudán");
    namesMap.put("SE", "Suecia");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Santa Lena");
    namesMap.put("SI", "Eslovenia");
    namesMap.put("SJ", "Svalbard ya Islla Jan Mayen");
    namesMap.put("SK", "Eslovaquia");
    namesMap.put("SL", "Sierra Lleona");
    namesMap.put("SM", "San Marín");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Sudán del Sur");
    namesMap.put("ST", "Santu Tomé y Príncipe");
    namesMap.put("SY", "Siria");
    namesMap.put("SZ", "Suazilandia");
    namesMap.put("TA", "Tristán da Cunha");
    namesMap.put("TC", "Islles Turques y Caicos");
    namesMap.put("TF", "Tierres Australes Franceses");
    namesMap.put("TG", "Togu");
    namesMap.put("TH", "Tailandia");
    namesMap.put("TJ", "Taxiquistán");
    namesMap.put("TK", "Tokeláu");
    namesMap.put("TL", "Timor Oriental");
    namesMap.put("TM", "Turkmenistán");
    namesMap.put("TN", "Tunicia");
    namesMap.put("TR", "Turquía");
    namesMap.put("TT", "Trinidá y Tobagu");
    namesMap.put("TW", "Taiwán");
    namesMap.put("UA", "Ucraína");
    namesMap.put("UM", "Islles Perifériques Menores de los EE.XX.");
    namesMap.put("US", "Estaos Xuníos");
    namesMap.put("UZ", "Uzbequistán");
    namesMap.put("VA", "Ciudá del Vaticanu");
    namesMap.put("VC", "San Vicente y les Granadines");
    namesMap.put("VG", "Islles Vírxenes Britániques");
    namesMap.put("VI", "Islles Vírxenes Americanes");
    namesMap.put("WF", "Wallis y Futuna");
    namesMap.put("ZA", "Sudáfrica");
    namesMap.put("ZW", "Zimbabue");
    namesMap.put("ZZ", "Rexón desconocida");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mundu",
        "002": "África",
        "003": "Norteamérica",
        "005": "América del Sur",
        "009": "Oceanía",
        "011": "África Occidental",
        "013": "América Central",
        "014": "África Oriental",
        "015": "África del Norte",
        "017": "África Central",
        "018": "África del Sur",
        "019": "América",
        "021": "América del Norte",
        "029": "Caribe",
        "030": "Asia Oriental",
        "034": "Asia del Sur",
        "035": "Sureste Asiáticu",
        "039": "Europa del Sur",
        "057": "Rexón de Micronesia",
        "061": "Polinesia",
        "143": "Asia Central",
        "145": "Asia Occidental",
        "150": "Europa",
        "151": "Europa Oriental",
        "154": "Europa del Norte",
        "155": "Europa Occidental",
        "419": "América Llatina",
        "AC": "Islla Ascensión",
        "AE": "Emiratos Árabes Xuníos",
        "AF": "Afganistán",
        "AG": "Antigua y Barbuda",
        "AI": "Anguila",
        "AQ": "L'Antártida",
        "AR": "Arxentina",
        "AS": "Samoa Americana",
        "AX": "Islles Aland",
        "AZ": "Azerbaixán",
        "BA": "Bosnia y Herzegovina",
        "BD": "Bangladex",
        "BE": "Bélxica",
        "BF": "Burkina Fasu",
        "BH": "Baḥréin",
        "BJ": "Benín",
        "BL": "San Bartolomé",
        "BM": "Les Bermudes",
        "BN": "Brunéi",
        "BQ": "Caribe neerlandés",
        "BR": "Brasil",
        "BS": "Les Bahames",
        "BT": "Bután",
        "BV": "Islla Bouvet",
        "BW": "Botsuana",
        "BY": "Bielorrusia",
        "CA": "Canadá",
        "CC": "Islles Cocos (Keeling)",
        "CD": "Congu - Kinxasa",
        "CF": "República Centroafricana",
        "CG": "Congu - Brazzaville",
        "CH": "Suiza",
        "CI": "Costa de Marfil",
        "CK": "Islles Cook",
        "CM": "Camerún",
        "CP": "Islla Clipperton",
        "CV": "Cabu Verde",
        "CX": "Islla Christmas",
        "CY": "Xipre",
        "CZ": "Chequia",
        "DE": "Alemania",
        "DJ": "Xibuti",
        "DK": "Dinamarca",
        "DO": "República Dominicana",
        "DZ": "Arxelia",
        "EA": "Ceuta y Melilla",
        "EG": "Exiptu",
        "EH": "Sáḥara Occidental",
        "ES": "España",
        "ET": "Etiopía",
        "EU": "Xunión Européa",
        "FI": "Finlandia",
        "FJ": "Islles Fixi",
        "FK": "Falkland Islands",
        "FO": "Islles Feroe",
        "FR": "Francia",
        "GA": "Gabón",
        "GB": "Reinu Xuníu",
        "GD": "Granada",
        "GE": "Xeorxa",
        "GF": "Guyana Francesa",
        "GI": "Xibraltar",
        "GL": "Groenlandia",
        "GP": "Guadalupe",
        "GQ": "Guinea Ecuatorial",
        "GR": "Grecia",
        "GS": "Islles Xeorxa del Sur y Sandwich del Sur",
        "GW": "Guinea-Bisáu",
        "HK": "ARE China de Ḥong Kong",
        "HM": "Islla Ḥeard ya Islles McDonald",
        "HN": "Hondures",
        "HR": "Croacia",
        "HT": "Haití",
        "HU": "Hungría",
        "IC": "Islles Canaries",
        "IE": "Irlanda",
        "IM": "Islla de Man",
        "IO": "Territoriu Británicu del Océanu Índicu",
        "IR": "Irán",
        "IS": "Islandia",
        "IT": "Italia",
        "JM": "Xamaica",
        "JO": "Xordania",
        "JP": "Xapón",
        "KE": "Kenia",
        "KG": "Kirguistán",
        "KH": "Camboya",
        "KM": "Les Comores",
        "KN": "Saint Kitts y Nevis",
        "KP": "Corea del Norte",
        "KR": "Corea del Sur",
        "KY": "Islles Caimán",
        "KZ": "Kazakstán",
        "LB": "Líbanu",
        "LC": "Santa Llucía",
        "LS": "Lesothu",
        "LT": "Lituania",
        "LU": "Luxemburgu",
        "LV": "Letonia",
        "LY": "Libia",
        "MA": "Marruecos",
        "MC": "Mónacu",
        "MD": "Moldavia",
        "ME": "Montenegru",
        "MH": "Islles Marshall",
        "MK": "Macedonia",
        "ML": "Malí",
        "MM": "Myanmar (Birmania)",
        "MO": "ARE China de Macáu",
        "MP": "Islles Marianes del Norte",
        "MQ": "La Martinica",
        "MU": "Mauriciu",
        "MV": "Les Maldives",
        "MW": "Malaui",
        "MX": "Méxicu",
        "MY": "Malasia",
        "NC": "Nueva Caledonia",
        "NE": "El Níxer",
        "NF": "Islla Norfolk",
        "NG": "Nixeria",
        "NL": "Países Baxos",
        "NO": "Noruega",
        "NZ": "Nueva Zelanda",
        "OM": "Omán",
        "PA": "Panamá",
        "PE": "Perú",
        "PF": "Polinesia Francesa",
        "PG": "Papúa Nueva Guinea",
        "PH": "Filipines",
        "PL": "Polonia",
        "PM": "Saint Pierre y Miquelon",
        "PN": "Islles Pitcairn",
        "PR": "Puertu Ricu",
        "PS": "Palestina",
        "PW": "Paláu",
        "QO": "Oceanía esterior",
        "RE": "Reunión",
        "RO": "Rumanía",
        "RU": "Rusia",
        "RW": "Ruanda",
        "SA": "Arabia Saudita",
        "SB": "Islles Salomón",
        "SC": "Les Seixeles",
        "SD": "Sudán",
        "SE": "Suecia",
        "SG": "Singapur",
        "SH": "Santa Lena",
        "SI": "Eslovenia",
        "SJ": "Svalbard ya Islla Jan Mayen",
        "SK": "Eslovaquia",
        "SL": "Sierra Lleona",
        "SM": "San Marín",
        "SR": "Surinam",
        "SS": "Sudán del Sur",
        "ST": "Santu Tomé y Príncipe",
        "SY": "Siria",
        "SZ": "Suazilandia",
        "TA": "Tristán da Cunha",
        "TC": "Islles Turques y Caicos",
        "TF": "Tierres Australes Franceses",
        "TG": "Togu",
        "TH": "Tailandia",
        "TJ": "Taxiquistán",
        "TK": "Tokeláu",
        "TL": "Timor Oriental",
        "TM": "Turkmenistán",
        "TN": "Tunicia",
        "TR": "Turquía",
        "TT": "Trinidá y Tobagu",
        "TW": "Taiwán",
        "UA": "Ucraína",
        "UM": "Islles Perifériques Menores de los EE.XX.",
        "US": "Estaos Xuníos",
        "UZ": "Uzbequistán",
        "VA": "Ciudá del Vaticanu",
        "VC": "San Vicente y les Granadines",
        "VG": "Islles Vírxenes Britániques",
        "VI": "Islles Vírxenes Americanes",
        "WF": "Wallis y Futuna",
        "ZA": "Sudáfrica",
        "ZW": "Zimbabue",
        "ZZ": "Rexón desconocida"
    };
  }-*/;
}
