/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class BetaDetector
extends OpcodeStackDetector {
    private static final String BETA_ANNOTATION = "Lcom/google/api/client/util/Beta;";
    private static final String BETA_METHOD_USAGE = "BETA_METHOD_USAGE";
    private static final String BETA_FIELD_USAGE = "BETA_FIELD_USAGE";
    private static final String BETA_CLASS_USAGE = "BETA_CLASS_USAGE";
    private final BugReporter bugReporter;

    public BetaDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                this.checkMethod(this.getNameConstantOperand(), this.getSigConstantOperand());
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 206: 
            case 207: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 227: 
            case 228: {
                this.checkField(this.getNameConstantOperand());
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                if (!(this.getConstantRefOperand() instanceof ConstantClass)) break;
                this.checkClass();
                break;
            }
        }
    }

    private static boolean isBeta(AnnotationEntry[] annotationEntries) {
        for (AnnotationEntry annotation : annotationEntries) {
            if (!BETA_ANNOTATION.equals(annotation.getAnnotationType())) continue;
            return true;
        }
        return false;
    }

    private JavaClass checkClass() {
        try {
            JavaClass javaClass = Repository.lookupClass((String)this.getClassConstantOperand());
            boolean isGoogleClass = javaClass.getClassName().startsWith("com.google.api.client");
            if (!isGoogleClass) {
                return null;
            }
            if (javaClass.getClassName().equals(this.getDottedClassName())) {
                return null;
            }
            if (BetaDetector.isBeta(this.getThisClass().getAnnotationEntries()) || this.getMethod() != null && BetaDetector.isBeta(this.getMethod().getAnnotationEntries())) {
                return null;
            }
            if (BetaDetector.isBeta(javaClass.getAnnotationEntries())) {
                this.bugReporter.reportBug(this.createBugInstance(BETA_CLASS_USAGE).addClass(javaClass));
                return null;
            }
            return javaClass;
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            return null;
        }
    }

    private JavaClass getSuperclass(JavaClass javaClass) {
        try {
            return javaClass.getSuperClass();
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            return null;
        }
    }

    private void checkMethod(String methodName, String signature) {
        JavaClass javaClass = this.checkClass();
        if (javaClass == null) {
            return;
        }
        JavaClass current = javaClass;
        while (current != null) {
            for (Method method : current.getMethods()) {
                if (!methodName.equals(method.getName()) || !signature.equals(method.getSignature())) continue;
                if (BetaDetector.isBeta(method.getAnnotationEntries())) {
                    this.bugReporter.reportBug(this.createBugInstance(BETA_METHOD_USAGE).addCalledMethod((DismantleBytecode)this));
                }
                return;
            }
            current = this.getSuperclass(current);
        }
        if (!javaClass.isAbstract()) {
            this.bugReporter.logError("Can't locate method " + javaClass.getClassName() + "." + methodName + signature);
        }
    }

    private void checkField(String fieldName) {
        JavaClass javaClass = this.checkClass();
        if (javaClass == null) {
            return;
        }
        JavaClass current = javaClass;
        while (current != null) {
            for (Field field : current.getFields()) {
                if (!fieldName.equals(field.getName())) continue;
                if (BetaDetector.isBeta(field.getAnnotationEntries())) {
                    this.bugReporter.reportBug(this.createBugInstance(BETA_FIELD_USAGE).addReferencedField((DismantleBytecode)this));
                }
                return;
            }
            current = this.getSuperclass(current);
        }
        this.bugReporter.logError("Can't locate field " + javaClass.getClassName() + "." + fieldName);
    }

    private BugInstance createBugInstance(String type) {
        return new BugInstance((Detector)this, type, 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this);
    }
}

