/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json.gson;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.test.json.AbstractJsonFactoryTest;
import com.google.gson.stream.MalformedJsonException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class GsonFactoryTest
extends AbstractJsonFactoryTest {
    private static final String GSON_LINE_SEPARATOR = "\n";
    private static final String JSON_ENTRY_PRETTY = "{\n  \"title\": \"foo\"\n}";
    private static final String JSON_FEED_PRETTY = "{\n  \"entries\": [\n    {\n      \"title\": \"foo\"\n    },\n    {\n      \"title\": \"bar\"\n    }\n  ]\n}";

    public GsonFactoryTest(String name) {
        super(name);
    }

    protected JsonFactory newFactory() {
        return new GsonFactory();
    }

    public final void testToPrettyString_entry() throws Exception {
        AbstractJsonFactoryTest.Entry entry = new AbstractJsonFactoryTest.Entry();
        entry.title = "foo";
        GsonFactoryTest.assertEquals((String)JSON_ENTRY_PRETTY, (String)this.newFactory().toPrettyString((Object)entry));
    }

    public final void testToPrettyString_Feed() throws Exception {
        AbstractJsonFactoryTest.Feed feed = new AbstractJsonFactoryTest.Feed();
        AbstractJsonFactoryTest.Entry entryFoo = new AbstractJsonFactoryTest.Entry();
        entryFoo.title = "foo";
        AbstractJsonFactoryTest.Entry entryBar = new AbstractJsonFactoryTest.Entry();
        entryBar.title = "bar";
        feed.entries = new ArrayList();
        feed.entries.add(entryFoo);
        feed.entries.add(entryBar);
        GsonFactoryTest.assertEquals((String)JSON_FEED_PRETTY, (String)this.newFactory().toPrettyString((Object)feed));
    }

    public final void testParse_directValue() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser("123");
        GsonFactoryTest.assertEquals((Object)123, (Object)parser.parse(Integer.class, true));
    }

    public final void testGetByteValue() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser("123");
        try {
            parser.getByteValue();
            GsonFactoryTest.fail((String)"should throw IOException");
        }
        catch (IOException ex) {
            GsonFactoryTest.assertNotNull((Object)ex.getMessage());
        }
    }

    public final void testReaderLeniency_lenient() throws IOException {
        JsonObjectParser parser = new JsonObjectParser((JsonFactory)GsonFactory.builder().setReadLeniency(true).build());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(")]}'\n{\n  \"title\": \"foo\"\n}".getBytes(StandardCharsets.UTF_8));
        GenericJson json = (GenericJson)parser.parseAndClose((InputStream)inputStream, StandardCharsets.UTF_8, GenericJson.class);
        GsonFactoryTest.assertEquals((Object)"foo", (Object)json.get((Object)"title"));
    }

    public final void testReaderLeniency_not_lenient_by_default() throws IOException {
        JsonObjectParser parser = new JsonObjectParser((JsonFactory)GsonFactory.getDefaultInstance());
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(")]}'\n{\n  \"title\": \"foo\"\n}".getBytes(StandardCharsets.UTF_8));
            parser.parseAndClose((InputStream)inputStream, StandardCharsets.UTF_8, GenericJson.class);
            GsonFactoryTest.fail((String)"The read leniency should fail the JSON input with XSSI prefix.");
        }
        catch (MalformedJsonException ex) {
            GsonFactoryTest.assertNotNull((Object)ex.getMessage());
        }
    }
}

