/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json.jackson2;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.test.json.AbstractJsonFactoryTest;
import com.google.api.client.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;

public class JacksonFactoryTest
extends AbstractJsonFactoryTest {
    private static final String JSON_ENTRY_PRETTY = "{" + StringUtils.LINE_SEPARATOR + "  \"title\" : \"foo\"" + StringUtils.LINE_SEPARATOR + "}";
    private static final String JSON_FEED_PRETTY = "{" + StringUtils.LINE_SEPARATOR + "  \"entries\" : [ {" + StringUtils.LINE_SEPARATOR + "    \"title\" : \"foo\"" + StringUtils.LINE_SEPARATOR + "  }, {" + StringUtils.LINE_SEPARATOR + "    \"title\" : \"bar\"" + StringUtils.LINE_SEPARATOR + "  } ]" + StringUtils.LINE_SEPARATOR + "}";

    public JacksonFactoryTest(String name) {
        super(name);
    }

    protected JsonFactory newFactory() {
        return new JacksonFactory();
    }

    public final void testToPrettyString_entry() throws Exception {
        AbstractJsonFactoryTest.Entry entry = new AbstractJsonFactoryTest.Entry();
        entry.title = "foo";
        JacksonFactoryTest.assertEquals((String)JSON_ENTRY_PRETTY, (String)this.newFactory().toPrettyString((Object)entry));
    }

    public final void testToPrettyString_Feed() throws Exception {
        AbstractJsonFactoryTest.Feed feed = new AbstractJsonFactoryTest.Feed();
        AbstractJsonFactoryTest.Entry entryFoo = new AbstractJsonFactoryTest.Entry();
        entryFoo.title = "foo";
        AbstractJsonFactoryTest.Entry entryBar = new AbstractJsonFactoryTest.Entry();
        entryBar.title = "bar";
        feed.entries = new ArrayList();
        feed.entries.add(entryFoo);
        feed.entries.add(entryBar);
        JacksonFactoryTest.assertEquals((String)JSON_FEED_PRETTY, (String)this.newFactory().toPrettyString((Object)feed));
    }

    public final void testParse_directValue() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser("123");
        JacksonFactoryTest.assertEquals((Object)123, (Object)parser.parse(Integer.class, true));
    }

    public final void testGetByteValue() throws IOException {
        JsonParser parser = this.newFactory().createJsonParser("123");
        try {
            parser.getByteValue();
            JacksonFactoryTest.fail((String)"should throw IOException");
        }
        catch (IOException ex) {
            JacksonFactoryTest.assertNotNull((Object)ex.getMessage());
        }
    }
}

