/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.jdo;

import com.google.api.client.util.IOUtils;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.store.AbstractDataStore;
import com.google.api.client.util.store.AbstractDataStoreFactory;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.DataStoreUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

public class JdoDataStoreFactory
extends AbstractDataStoreFactory {
    private final PersistenceManagerFactory persistenceManagerFactory;

    public JdoDataStoreFactory(PersistenceManagerFactory persistenceManagerFactory) {
        this.persistenceManagerFactory = (PersistenceManagerFactory)Preconditions.checkNotNull((Object)persistenceManagerFactory);
    }

    protected <V extends Serializable> DataStore<V> createDataStore(String id) throws IOException {
        return new JdoDataStore(this, this.persistenceManagerFactory, id);
    }

    static class PrivateUtils {
        PrivateUtils() {
        }

        public static class ComposedIdKey
        implements Serializable {
            private static final long serialVersionUID = 1L;
            public String key;
            public String id;

            public ComposedIdKey() {
            }

            public ComposedIdKey(String value) {
                StringTokenizer token = new StringTokenizer(value, "::");
                token.nextToken();
                this.key = token.nextToken();
                this.id = token.nextToken();
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof ComposedIdKey)) {
                    return false;
                }
                ComposedIdKey other = (ComposedIdKey)obj;
                return this.key.equals(other.key) && this.id.equals(other.id);
            }

            public int hashCode() {
                return this.key.hashCode() ^ this.id.hashCode();
            }

            public String toString() {
                return this.getClass().getName() + "::" + this.key + "::" + this.id;
            }
        }
    }

    @PersistenceCapable(objectIdClass=PrivateUtils.ComposedIdKey.class)
    static class JdoValue {
        @PrimaryKey
        @Persistent
        private String key;
        @PrimaryKey
        @Persistent
        private String id;
        @Persistent
        private byte[] bytes;

        JdoValue() {
        }

        <V extends Serializable> JdoValue(String id, String key, V value) throws IOException {
            this.id = id;
            this.key = key;
            this.serialize(value);
        }

        <V extends Serializable> void serialize(V value) throws IOException {
            this.bytes = IOUtils.serialize(value);
        }

        <V extends Serializable> V deserialize() throws IOException {
            return (V)IOUtils.deserialize((byte[])this.bytes);
        }

        String getKey() {
            return this.key;
        }
    }

    static class JdoDataStore<V extends Serializable>
    extends AbstractDataStore<V> {
        private final Lock lock = new ReentrantLock();
        private final PersistenceManagerFactory persistenceManagerFactory;

        JdoDataStore(JdoDataStoreFactory dataStore, PersistenceManagerFactory persistenceManagerFactory, String id) {
            super((DataStoreFactory)dataStore, id);
            this.persistenceManagerFactory = persistenceManagerFactory;
        }

        /*
         * Exception decompiling
         */
        public Set<String> keySet() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public Collection<V> values() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public V get(String key) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JdoDataStore<V> set(String key, V value) throws IOException {
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkNotNull(value);
            this.lock.lock();
            try {
                PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
                try {
                    Query query = this.newKeyQuery(persistenceManager);
                    try {
                        JdoValue jdoValue = this.executeKeyQuery(query, key);
                        if (jdoValue != null) {
                            jdoValue.serialize(value);
                        } else {
                            jdoValue = new JdoValue(this.getId(), key, value);
                            persistenceManager.makePersistent((Object)jdoValue);
                        }
                    }
                    finally {
                        query.closeAll();
                    }
                }
                finally {
                    persistenceManager.close();
                }
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DataStore<V> delete(String key) throws IOException {
            if (key == null) {
                return this;
            }
            this.lock.lock();
            try {
                PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
                try {
                    Query query = this.newKeyQuery(persistenceManager);
                    try {
                        JdoValue jdoValue = this.executeKeyQuery(query, key);
                        if (jdoValue != null) {
                            persistenceManager.deletePersistent((Object)jdoValue);
                        }
                    }
                    finally {
                        query.closeAll();
                    }
                }
                finally {
                    persistenceManager.close();
                }
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JdoDataStore<V> clear() throws IOException {
            this.lock.lock();
            try {
                PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
                try {
                    Query query = this.newAllKeysQuery(persistenceManager);
                    try {
                        persistenceManager.deletePersistentAll(this.executeAllKeysQuery(query));
                    }
                    finally {
                        query.closeAll();
                    }
                }
                finally {
                    persistenceManager.close();
                }
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        public JdoDataStoreFactory getDataStoreFactory() {
            return (JdoDataStoreFactory)super.getDataStoreFactory();
        }

        public String toString() {
            return DataStoreUtils.toString((DataStore)this);
        }

        Query newAllKeysQuery(PersistenceManager persistenceManager) {
            Query query = persistenceManager.newQuery(JdoValue.class);
            query.setFilter("id == idParam");
            query.declareParameters("String idParam");
            return query;
        }

        Collection<JdoValue> executeAllKeysQuery(Query allKeysQuery) {
            return (Collection)allKeysQuery.execute((Object)this.getId());
        }

        Query newKeyQuery(PersistenceManager persistenceManager) {
            Query query = persistenceManager.newQuery(JdoValue.class);
            query.setFilter("id == idParam && key == keyParam");
            query.declareParameters("String idParam, String keyParam");
            return query;
        }

        JdoValue executeKeyQuery(Query keyQuery, String key) {
            Collection queryResult = (Collection)keyQuery.execute((Object)this.getId(), (Object)key);
            return queryResult.isEmpty() ? null : (JdoValue)queryResult.iterator().next();
        }
    }
}

