/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.test.json;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import junit.framework.TestCase;
import org.junit.Assert;

public abstract class AbstractJsonParserTest
extends TestCase {
    private static final String TEST_JSON = "{\"strValue\": \"bar\", \"intValue\": 123, \"boolValue\": false}";
    private static final String TEST_JSON_BIG_DECIMAL = "{\"bigDecimalValue\": 1559341956102}";

    protected abstract JsonFactory newJsonFactory();

    public void testParse_basic() throws IOException {
        JsonObjectParser parser = new JsonObjectParser(this.newJsonFactory());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TEST_JSON.getBytes(StandardCharsets.UTF_8));
        GenericJson json = (GenericJson)parser.parseAndClose((InputStream)inputStream, StandardCharsets.UTF_8, GenericJson.class);
        AbstractJsonParserTest.assertTrue((boolean)(json.get((Object)"strValue") instanceof String));
        AbstractJsonParserTest.assertEquals((Object)"bar", (Object)json.get((Object)"strValue"));
        AbstractJsonParserTest.assertTrue((boolean)(json.get((Object)"intValue") instanceof BigDecimal));
        AbstractJsonParserTest.assertEquals((Object)new BigDecimal(123), (Object)json.get((Object)"intValue"));
        AbstractJsonParserTest.assertTrue((boolean)(json.get((Object)"boolValue") instanceof Boolean));
        AbstractJsonParserTest.assertEquals((Object)Boolean.FALSE, (Object)json.get((Object)"boolValue"));
    }

    public void testGetWrongType() throws IOException {
        JsonObjectParser parser = new JsonObjectParser(this.newJsonFactory());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TEST_JSON.getBytes(StandardCharsets.UTF_8));
        GenericJson json = (GenericJson)parser.parseAndClose((InputStream)inputStream, StandardCharsets.UTF_8, GenericJson.class);
        AbstractJsonParserTest.assertTrue((boolean)(json.get((Object)"strValue") instanceof String));
        AbstractJsonParserTest.assertEquals((Object)"bar", (Object)json.get((Object)"strValue"));
        AbstractJsonParserTest.assertTrue((boolean)(json.get((Object)"intValue") instanceof BigDecimal));
        AbstractJsonParserTest.assertEquals((Object)new BigDecimal(123), (Object)json.get((Object)"intValue"));
        AbstractJsonParserTest.assertTrue((boolean)(json.get((Object)"boolValue") instanceof Boolean));
        AbstractJsonParserTest.assertEquals((Object)Boolean.FALSE, (Object)json.get((Object)"boolValue"));
    }

    public void testParse_badJson() throws IOException {
        JsonObjectParser parser = new JsonObjectParser(this.newJsonFactory());
        ByteArrayInputStream inputStream = new ByteArrayInputStream("not json".getBytes(StandardCharsets.UTF_8));
        try {
            parser.parseAndClose((InputStream)inputStream, StandardCharsets.UTF_8, GenericJson.class);
            AbstractJsonParserTest.fail((String)"Malformed JSON not detected");
        }
        catch (IOException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    public void testParse_bigDecimal() throws IOException {
        JsonObjectParser parser = new JsonObjectParser(this.newJsonFactory());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TEST_JSON_BIG_DECIMAL.getBytes(StandardCharsets.UTF_8));
        GenericJson json = (GenericJson)parser.parseAndClose((InputStream)inputStream, StandardCharsets.UTF_8, GenericJson.class);
        AbstractJsonParserTest.assertTrue((boolean)(json.get((Object)"bigDecimalValue") instanceof BigDecimal));
        AbstractJsonParserTest.assertEquals((Object)new BigDecimal("1559341956102"), (Object)json.get((Object)"bigDecimalValue"));
    }
}

