/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpRequest;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;

public final class NetHttpTransport
extends HttpTransport {
    private static final String[] SUPPORTED_METHODS = new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};

    public boolean supportsMethod(String method) {
        return Arrays.binarySearch(SUPPORTED_METHODS, method) >= 0;
    }

    protected NetHttpRequest buildRequest(String method, String url) throws IOException {
        Preconditions.checkArgument((boolean)this.supportsMethod(method), (String)"HTTP method %s not supported", (Object[])new Object[]{method});
        return new NetHttpRequest(method, url);
    }

    @Deprecated
    public boolean supportsHead() {
        return true;
    }

    @Deprecated
    public NetHttpRequest buildDeleteRequest(String url) throws IOException {
        return this.buildRequest("DELETE", url);
    }

    @Deprecated
    public NetHttpRequest buildGetRequest(String url) throws IOException {
        return this.buildRequest("GET", url);
    }

    @Deprecated
    public NetHttpRequest buildHeadRequest(String url) throws IOException {
        return this.buildRequest("HEAD", url);
    }

    @Deprecated
    public NetHttpRequest buildPostRequest(String url) throws IOException {
        return this.buildRequest("POST", url);
    }

    @Deprecated
    public NetHttpRequest buildPutRequest(String url) throws IOException {
        return this.buildRequest("PUT", url);
    }

    static {
        Arrays.sort(SUPPORTED_METHODS);
    }
}

