/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.AbstractHttpContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import junit.framework.TestCase;

public class AbstractHttpContentTest
extends TestCase {
    public void testRetrySupported() {
        TestHttpContent content = new TestHttpContent(true, 0);
        AbstractHttpContentTest.assertTrue((boolean)content.retrySupported());
    }

    public void testComputeLength() throws Exception {
        this.subtestComputeLength(true, 0L, 0);
        this.subtestComputeLength(true, 1L, 1);
        this.subtestComputeLength(true, 2L, 2);
        this.subtestComputeLength(false, -1L, 2);
    }

    public void subtestComputeLength(boolean retrySupported, long expectedLengthHeader, int length) throws Exception {
        TestHttpContent content = new TestHttpContent(retrySupported, length);
        AbstractHttpContentTest.assertEquals((long)expectedLengthHeader, (long)content.computeLength());
    }

    static class TestHttpContent
    extends AbstractHttpContent {
        private final boolean retrySupported;
        private final int length;

        TestHttpContent(boolean retrySupported, int length) {
            super("foo/bar");
            this.length = length;
            this.retrySupported = retrySupported;
        }

        public String getType() {
            return null;
        }

        public void writeTo(OutputStream out) throws IOException {
            byte[] content = new byte[this.length];
            Arrays.fill(content, (byte)32);
            out.write(content);
        }

        public boolean retrySupported() {
            return this.retrySupported;
        }
    }
}

