/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.ExponentialBackOffPolicy;
import com.google.api.client.util.NanoClock;
import junit.framework.TestCase;

@Deprecated
public class ExponentialBackOffPolicyTest
extends TestCase {
    public ExponentialBackOffPolicyTest(String name) {
        super(name);
    }

    public void testConstructor() {
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        ExponentialBackOffPolicyTest.assertEquals((int)500, (int)backOffPolicy.getInitialIntervalMillis());
        ExponentialBackOffPolicyTest.assertEquals((int)500, (int)backOffPolicy.getCurrentIntervalMillis());
        ExponentialBackOffPolicyTest.assertEquals((Object)0.5, (Object)backOffPolicy.getRandomizationFactor());
        ExponentialBackOffPolicyTest.assertEquals((Object)1.5, (Object)backOffPolicy.getMultiplier());
        ExponentialBackOffPolicyTest.assertEquals((int)60000, (int)backOffPolicy.getMaxIntervalMillis());
        ExponentialBackOffPolicyTest.assertEquals((int)900000, (int)backOffPolicy.getMaxElapsedTimeMillis());
    }

    public void testBuilder() {
        ExponentialBackOffPolicy backOffPolicy = ExponentialBackOffPolicy.builder().build();
        ExponentialBackOffPolicyTest.assertEquals((int)500, (int)backOffPolicy.getInitialIntervalMillis());
        ExponentialBackOffPolicyTest.assertEquals((int)500, (int)backOffPolicy.getCurrentIntervalMillis());
        ExponentialBackOffPolicyTest.assertEquals((Object)0.5, (Object)backOffPolicy.getRandomizationFactor());
        ExponentialBackOffPolicyTest.assertEquals((Object)1.5, (Object)backOffPolicy.getMultiplier());
        ExponentialBackOffPolicyTest.assertEquals((int)60000, (int)backOffPolicy.getMaxIntervalMillis());
        ExponentialBackOffPolicyTest.assertEquals((int)900000, (int)backOffPolicy.getMaxElapsedTimeMillis());
        int testInitialInterval = 1;
        double testRandomizationFactor = 0.1;
        double testMultiplier = 5.0;
        int testMaxInterval = 10;
        int testMaxElapsedTime = 900000;
        backOffPolicy = ExponentialBackOffPolicy.builder().setInitialIntervalMillis(testInitialInterval).setRandomizationFactor(testRandomizationFactor).setMultiplier(testMultiplier).setMaxIntervalMillis(testMaxInterval).setMaxElapsedTimeMillis(testMaxElapsedTime).build();
        ExponentialBackOffPolicyTest.assertEquals((int)testInitialInterval, (int)backOffPolicy.getInitialIntervalMillis());
        ExponentialBackOffPolicyTest.assertEquals((int)testInitialInterval, (int)backOffPolicy.getCurrentIntervalMillis());
        ExponentialBackOffPolicyTest.assertEquals((Object)testRandomizationFactor, (Object)backOffPolicy.getRandomizationFactor());
        ExponentialBackOffPolicyTest.assertEquals((Object)testMultiplier, (Object)backOffPolicy.getMultiplier());
        ExponentialBackOffPolicyTest.assertEquals((int)testMaxInterval, (int)backOffPolicy.getMaxIntervalMillis());
        ExponentialBackOffPolicyTest.assertEquals((int)testMaxElapsedTime, (int)backOffPolicy.getMaxElapsedTimeMillis());
    }

    public void testBackOff() throws Exception {
        int[] expectedResults;
        int testInitialInterval = 500;
        double testRandomizationFactor = 0.1;
        double testMultiplier = 2.0;
        int testMaxInterval = 5000;
        int testMaxElapsedTime = 900000;
        ExponentialBackOffPolicy backOffPolicy = ExponentialBackOffPolicy.builder().setInitialIntervalMillis(testInitialInterval).setRandomizationFactor(testRandomizationFactor).setMultiplier(testMultiplier).setMaxIntervalMillis(testMaxInterval).setMaxElapsedTimeMillis(testMaxElapsedTime).build();
        for (int expected : expectedResults = new int[]{500, 1000, 2000, 4000, 5000, 5000, 5000, 5000, 5000, 5000}) {
            ExponentialBackOffPolicyTest.assertEquals((int)expected, (int)backOffPolicy.getCurrentIntervalMillis());
            int minInterval = (int)((double)expected - testRandomizationFactor * (double)expected);
            int maxInterval = (int)((double)expected + testRandomizationFactor * (double)expected);
            long actualInterval = backOffPolicy.getNextBackOffMillis();
            ExponentialBackOffPolicyTest.assertTrue(((long)minInterval <= actualInterval && actualInterval <= (long)maxInterval ? 1 : 0) != 0);
        }
    }

    public void testGetElapsedTimeMillis() {
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy.Builder().setNanoClock((NanoClock)new MyNanoClock()).build();
        long elapsedTimeMillis = backOffPolicy.getElapsedTimeMillis();
        ExponentialBackOffPolicyTest.assertEquals((String)("elapsedTimeMillis=" + elapsedTimeMillis), (long)1000L, (long)elapsedTimeMillis);
    }

    public void testBackOffOverflow() throws Exception {
        int testInitialInterval = 0x3FFFFFFF;
        double testMultiplier = 2.1;
        int testMaxInterval = Integer.MAX_VALUE;
        ExponentialBackOffPolicy backOffPolicy = ExponentialBackOffPolicy.builder().setInitialIntervalMillis(testInitialInterval).setMultiplier(testMultiplier).setMaxIntervalMillis(testMaxInterval).build();
        backOffPolicy.getNextBackOffMillis();
        ExponentialBackOffPolicyTest.assertEquals((int)testMaxInterval, (int)backOffPolicy.getCurrentIntervalMillis());
    }

    static class MyNanoClock
    implements NanoClock {
        private int i = 0;
        private long startSeconds;

        MyNanoClock() {
        }

        MyNanoClock(long startSeconds) {
            this.startSeconds = startSeconds;
        }

        public long nanoTime() {
            return (this.startSeconds + (long)this.i++) * 1000000000L;
        }
    }
}

