/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.util.Key;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;

public class GenericUrlTest
extends TestCase {
    private static final String MINIMAL = "http://bar";
    private static final String NO_PATH = "http://bar?a=b";
    private static final String SHORT_PATH = "http://bar/path?a=b";
    private static final List<String> SHORT_PATH_PARTS = Arrays.asList("", "path");
    private static final String LONG_PATH = "http://bar/path/to/resource?a=b";
    private static final List<String> LONG_PATH_PARTS = Arrays.asList("", "path", "to", "resource");
    private static final String FULL = "https://user:%3Cpa&$w%40rd%3E@www.google.com:223/m8/feeds/contacts/someone=%23%25&%20%3F%3Co%3E%7B%7D@gmail.com/full?foo=bar&alt=json&max-results=3&prettyprint=true&q=Go%3D%23/%25%26%20?%3Co%3Egle#%3CD@WNL:ADING%3E";
    private static final List<String> FULL_PARTS = Arrays.asList("", "m8", "feeds", "contacts", "someone=#%& ?<o>{}@gmail.com", "full");
    private static final String USER_INFO = "user:<pa&$w@rd>";
    private static final String FRAGMENT = "<D@WNL:ADING>";
    private static final String FIELD_TYPES = "http://bar?B=true&D=-3.14&I=-3&b=true&d=-3.14&i=-3&s=a&a=b";
    private static final String FRAGMENT1 = "http://bar/path/to/resource#fragme=%23/%25&%20?%3Co%3Ent";
    private static final String FRAGMENT2 = "http://bar/path/to/resource?a=b#fragment";
    private static final String BASE_URL = "http://google.com";
    private static final String FULL_PATH = "/some/path/someone%2Fis%2F@gmail.com/test/?one=1&two=2";
    private static final String PATH_WITH_SLASH = "http://www.google.com/m8/feeds/contacts/someone%2Fis%2F@gmail.com/full/";
    private static final List<String> PATH_WITH_SLASH_PARTS = Arrays.asList("", "m8", "feeds", "contacts", "someone/is/@gmail.com", "full", "");
    private static final String PREFIX = "https://www.googleapis.com";
    private static final String REPEATED_PARAM_PATH = "/latitude/v1/location";
    private static final List<String> REPEATED_PARAM_PATH_PARTS = Arrays.asList("", "latitude", "v1", "location");
    private static final String REPEATED_PARAM = "https://www.googleapis.com/latitude/v1/location?q=c&q=a&q=b&s=e";

    public GenericUrlTest() {
    }

    public GenericUrlTest(String name) {
        super(name);
    }

    public void testBuild_minimal() {
        GenericUrl url = new GenericUrl();
        url.setScheme("http");
        url.setHost("bar");
        GenericUrlTest.assertEquals((String)MINIMAL, (String)url.build());
    }

    public void testParse_minimal() {
        GenericUrl url = new GenericUrl(MINIMAL);
        GenericUrlTest.assertEquals((String)"http", (String)url.getScheme());
    }

    public void testBuild_noPath() {
        GenericUrl url = new GenericUrl();
        url.setScheme("http");
        url.setHost("bar");
        url.set("a", (Object)"b");
        GenericUrlTest.assertEquals((String)NO_PATH, (String)url.build());
    }

    public void testBuild_noUserInfo() {
        GenericUrl url = new GenericUrl(NO_PATH);
        GenericUrlTest.assertNull((Object)url.getUserInfo());
    }

    public void testBuild_noScheme() {
        GenericUrl url = new GenericUrl();
        try {
            url.build();
            GenericUrlTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuild_noHost() {
        GenericUrl url = new GenericUrl();
        try {
            url.setScheme("http");
            url.build();
            GenericUrlTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParse_noPath() {
        GenericUrl url = new GenericUrl(NO_PATH);
        GenericUrlTest.assertEquals((String)"http", (String)url.getScheme());
        GenericUrlTest.assertEquals((String)"bar", (String)url.getHost());
        GenericUrlTest.assertEquals((Object)"b", (Object)url.getFirst("a"));
        GenericUrlTest.assertNull((Object)url.getPathParts());
    }

    public void testBuild_shortPath() {
        GenericUrl url = new GenericUrl();
        url.setScheme("http");
        url.setHost("bar");
        url.setPathParts(SHORT_PATH_PARTS);
        url.set("a", (Object)"b");
        GenericUrlTest.assertEquals((String)SHORT_PATH, (String)url.build());
    }

    public void testParse_shortPath() {
        GenericUrl url = new GenericUrl(SHORT_PATH);
        GenericUrlTest.assertEquals((String)"http", (String)url.getScheme());
        GenericUrlTest.assertEquals((String)"bar", (String)url.getHost());
        GenericUrlTest.assertEquals(SHORT_PATH_PARTS, (Object)url.getPathParts());
        GenericUrlTest.assertEquals((Object)"b", (Object)url.getFirst("a"));
    }

    public void testBuild_longPath() {
        GenericUrl url = new GenericUrl();
        url.setScheme("http");
        url.setHost("bar");
        url.setPathParts(LONG_PATH_PARTS);
        url.set("a", (Object)"b");
        GenericUrlTest.assertEquals((String)LONG_PATH, (String)url.build());
    }

    public void testParse_longPath() {
        GenericUrl url = new GenericUrl(LONG_PATH);
        GenericUrlTest.assertEquals((String)"http", (String)url.getScheme());
        GenericUrlTest.assertEquals((String)"bar", (String)url.getHost());
        GenericUrlTest.assertEquals(LONG_PATH_PARTS, (Object)url.getPathParts());
        GenericUrlTest.assertEquals((Object)"b", (Object)url.getFirst("a"));
    }

    public void testBuild_full() {
        TestUrl url = new TestUrl();
        url.setScheme("https");
        url.setHost("www.google.com");
        url.setPort(223);
        url.setPathParts(FULL_PARTS);
        url.set("alt", "json").set("max-results", (Object)3).set("prettyprint", (Object)true).set("q", (Object)"Go=#/%& ?<o>gle");
        url.foo = "bar";
        url.hidden = "invisible";
        url.setFragment(FRAGMENT);
        url.setUserInfo(USER_INFO);
        GenericUrlTest.assertEquals((String)FULL, (String)url.build());
    }

    public void testParse_full() {
        TestUrl url = new TestUrl(FULL);
        this.subtestFull(url);
        GenericUrlTest.assertNull((Object)url.hidden);
        GenericUrlTest.assertEquals((Object)"bar", (Object)url.get("foo"));
        GenericUrlTest.assertEquals((String)"bar", (String)url.foo);
    }

    public void testConstructor_url() throws MalformedURLException {
        GenericUrl url = new GenericUrl(new URL(FULL));
        this.subtestFull(url);
    }

    public void testConstructor_uri() throws URISyntaxException {
        GenericUrl url = new GenericUrl(new URI(FULL));
        this.subtestFull(url);
    }

    public void testConstructor_string() {
        GenericUrl url = new GenericUrl(FULL);
        this.subtestFull(url);
    }

    public void testConstructor_schemeToLowerCase() throws URISyntaxException, MalformedURLException {
        GenericUrl url = new GenericUrl("HTTps://www.google.com:223");
        GenericUrlTest.assertEquals((String)"https", (String)url.getScheme());
        url = new GenericUrl(new URI("HTTPS://www.google.com:223"));
        GenericUrlTest.assertEquals((String)"https", (String)url.getScheme());
        url = new GenericUrl(new URL("hTTPs://www.google.com:223"));
        GenericUrlTest.assertEquals((String)"https", (String)url.getScheme());
    }

    private void subtestFull(GenericUrl url) {
        GenericUrlTest.assertEquals((String)"https", (String)url.getScheme());
        GenericUrlTest.assertEquals((String)"www.google.com", (String)url.getHost());
        GenericUrlTest.assertEquals((int)223, (int)url.getPort());
        GenericUrlTest.assertEquals(FULL_PARTS, (Object)url.getPathParts());
        GenericUrlTest.assertEquals((Object)"json", (Object)url.getFirst("alt"));
        GenericUrlTest.assertEquals((Object)"3", (Object)url.getFirst("max-results"));
        GenericUrlTest.assertEquals((Object)"true", (Object)url.getFirst("prettyprint"));
        GenericUrlTest.assertEquals((Object)"Go=#/%& ?<o>gle", (Object)url.getFirst("q"));
        GenericUrlTest.assertEquals((Object)"bar", (Object)url.getFirst("foo"));
        GenericUrlTest.assertEquals((String)FRAGMENT, (String)url.getFragment());
        GenericUrlTest.assertEquals((String)USER_INFO, (String)url.getUserInfo());
    }

    public void testBuild_fieldTypes() {
        FieldTypesUrl url = new FieldTypesUrl();
        url.setScheme("http");
        url.setHost("bar");
        url.set("a", "b");
        url.B = true;
        url.D = -3.14;
        url.I = -3;
        url.b = true;
        url.d = -3.14;
        url.i = -3;
        url.s = "a";
        url.hidden = "notHere";
        GenericUrlTest.assertEquals((String)FIELD_TYPES, (String)url.build());
    }

    public void testParse_fieldTypes() {
        FieldTypesUrl url = new FieldTypesUrl(FIELD_TYPES);
        GenericUrlTest.assertEquals((String)"http", (String)url.getScheme());
        GenericUrlTest.assertEquals((String)"bar", (String)url.getHost());
        GenericUrlTest.assertEquals((Object)"b", (Object)url.getFirst("a"));
        GenericUrlTest.assertNull((Object)url.hidden);
        GenericUrlTest.assertEquals((boolean)true, (boolean)url.b);
        GenericUrlTest.assertEquals((Object)Boolean.TRUE, (Object)url.B);
        GenericUrlTest.assertEquals((double)-3.14, (double)url.d, (double)1.0E-5);
        GenericUrlTest.assertEquals((double)-3.14, (double)url.D, (double)1.0E-5);
        GenericUrlTest.assertEquals((int)-3, (int)url.i);
        GenericUrlTest.assertEquals((int)-3, (int)url.I);
        GenericUrlTest.assertEquals((String)"a", (String)url.s);
    }

    public void testBuild_fragment1() {
        GenericUrl url = new GenericUrl();
        url.setScheme("http");
        url.setHost("bar");
        url.setPathParts(LONG_PATH_PARTS);
        url.setFragment("fragme=#/%& ?<o>nt");
        GenericUrlTest.assertEquals((String)FRAGMENT1, (String)url.build());
    }

    public void testParse_fragment1() {
        GenericUrl url = new GenericUrl(FRAGMENT1);
        GenericUrlTest.assertEquals((String)"http", (String)url.getScheme());
        GenericUrlTest.assertEquals((String)"bar", (String)url.getHost());
        GenericUrlTest.assertEquals(LONG_PATH_PARTS, (Object)url.getPathParts());
        GenericUrlTest.assertEquals((String)"fragme=#/%& ?<o>nt", (String)url.getFragment());
    }

    public void testBuild_fragment2() {
        GenericUrl url = new GenericUrl();
        url.setScheme("http");
        url.setHost("bar");
        url.setPathParts(LONG_PATH_PARTS);
        url.set("a", (Object)"b");
        url.setFragment("fragment");
        GenericUrlTest.assertEquals((String)FRAGMENT2, (String)url.build());
    }

    public void testParse_fragment2() {
        GenericUrl url = new GenericUrl(FRAGMENT2);
        GenericUrlTest.assertEquals((String)"http", (String)url.getScheme());
        GenericUrlTest.assertEquals((String)"bar", (String)url.getHost());
        GenericUrlTest.assertEquals(LONG_PATH_PARTS, (Object)url.getPathParts());
        GenericUrlTest.assertEquals((Object)"b", (Object)url.getFirst("a"));
        GenericUrlTest.assertEquals((String)"fragment", (String)url.getFragment());
    }

    public void testBuildAuthority_exception() {
        GenericUrl url = new GenericUrl();
        url.setHost("example.com");
        try {
            url.buildAuthority();
            Assert.fail((String)"no exception was thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        url = new GenericUrl();
        url.setScheme("https");
        try {
            url.buildAuthority();
            Assert.fail((String)"no exception was thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuildAuthority_simple() {
        GenericUrl url = new GenericUrl();
        url.setScheme("http");
        url.setHost("example.com");
        GenericUrlTest.assertEquals((String)"http://example.com", (String)url.buildAuthority());
    }

    public void testBuildAuthority_withPort() {
        GenericUrl url = new GenericUrl();
        url.setScheme("http");
        url.setHost("example.com");
        url.setPort(1234);
        GenericUrlTest.assertEquals((String)"http://example.com:1234", (String)url.buildAuthority());
    }

    public void testBuildAuthority_withUserInfo() {
        GenericUrl url = new GenericUrl();
        url.setScheme("http");
        url.setHost("www.example.com");
        url.setUserInfo("first.last:pa@@");
        GenericUrlTest.assertEquals((String)"http://first.last:pa%40%40@www.example.com", (String)url.buildAuthority());
    }

    public void testBuildRelativeUrl_empty() {
        GenericUrl url = new GenericUrl();
        url.setScheme("foo");
        url.setHost("bar");
        url.setRawPath("");
        GenericUrlTest.assertEquals((String)"", (String)url.buildRelativeUrl());
    }

    public void testBuildRelativeUrl_simple() {
        GenericUrl url = new GenericUrl();
        url.setScheme("foo");
        url.setHost("bar");
        url.setRawPath("/example");
        GenericUrlTest.assertEquals((String)"/example", (String)url.buildRelativeUrl());
    }

    public void testBuildRelativeUrl_simpleQuery() {
        GenericUrl url = new GenericUrl();
        url.setScheme("foo");
        url.setHost("bar");
        url.setRawPath("/example");
        url.put("key", (Object)"value");
        GenericUrlTest.assertEquals((String)"/example?key=value", (String)url.buildRelativeUrl());
    }

    public void testBuildRelativeUrl_fragment() {
        GenericUrl url = new GenericUrl();
        url.setScheme("foo");
        url.setHost("bar");
        url.setRawPath("/example");
        url.setFragment("test");
        GenericUrlTest.assertEquals((String)"/example#test", (String)url.buildRelativeUrl());
    }

    public void testBuildRelativeUrl_onlyQuery() {
        GenericUrl url = new GenericUrl();
        url.setScheme("foo");
        url.setHost("bar");
        url.setRawPath("");
        url.put("key", (Object)"value");
        GenericUrlTest.assertEquals((String)"?key=value", (String)url.buildRelativeUrl());
    }

    public void testBuildRelativeUrl_full() {
        GenericUrl url = new GenericUrl("http://google.com/some/path/someone%2Fis%2F@gmail.com/test/?one=1&two=2");
        GenericUrlTest.assertEquals((String)FULL_PATH, (String)url.buildRelativeUrl());
    }

    public void testBuild_pathWithSlash() {
        GenericUrl url = new GenericUrl();
        url.setScheme("http");
        url.setHost("www.google.com");
        url.setPathParts(PATH_WITH_SLASH_PARTS);
        GenericUrlTest.assertEquals((String)PATH_WITH_SLASH, (String)url.build());
    }

    public void testConstructorUnderscore() {
        String url = "http://url_with_underscore.google.com";
        GenericUrl parsed = new GenericUrl(url);
        GenericUrlTest.assertEquals((String)"url_with_underscore.google.com", (String)parsed.getHost());
    }

    public void testParse_pathWithSlash() {
        GenericUrl url = new GenericUrl(PATH_WITH_SLASH);
        GenericUrlTest.assertEquals((String)"http", (String)url.getScheme());
        GenericUrlTest.assertEquals((String)"www.google.com", (String)url.getHost());
        GenericUrlTest.assertEquals(PATH_WITH_SLASH_PARTS, (Object)url.getPathParts());
    }

    public void testToPathParts() {
        this.subtestToPathParts(null, null);
        this.subtestToPathParts(null, "");
        this.subtestToPathParts("/", "", "");
        this.subtestToPathParts("a", "a");
        this.subtestToPathParts("/a", "", "a");
        this.subtestToPathParts("/a/", "", "a", "");
        this.subtestToPathParts("path/to/resource", "path", "to", "resource");
        this.subtestToPathParts("/path/to/resource", "", "path", "to", "resource");
        this.subtestToPathParts("/path/to/resource/", "", "path", "to", "resource", "");
        this.subtestToPathParts("/Go%3D%23%2F%25%26%20?%3Co%3Egle/2nd", "", "Go=#/%& ?<o>gle", "2nd");
    }

    private void subtestToPathParts(String encodedPath, String ... expectedDecodedParts) {
        List result = GenericUrl.toPathParts((String)encodedPath);
        if (encodedPath == null) {
            GenericUrlTest.assertNull((Object)result);
        } else {
            GenericUrlTest.assertEquals(Arrays.asList(expectedDecodedParts), (Object)result);
        }
    }

    public void testAppendPath() {
        GenericUrl url = new GenericUrl(BASE_URL);
        GenericUrlTest.assertNull((Object)url.getPathParts());
        url.appendRawPath(null);
        GenericUrlTest.assertNull((Object)url.getPathParts());
        url.appendRawPath("");
        GenericUrlTest.assertNull((Object)url.getPathParts());
        url.appendRawPath("/");
        GenericUrlTest.assertEquals(Arrays.asList("", ""), (Object)url.getPathParts());
        url.appendRawPath("/");
        GenericUrlTest.assertEquals(Arrays.asList("", "", ""), (Object)url.getPathParts());
        url.appendRawPath("/a");
        GenericUrlTest.assertEquals(Arrays.asList("", "", "", "a"), (Object)url.getPathParts());
        url.appendRawPath("b");
        GenericUrlTest.assertEquals(Arrays.asList("", "", "", "ab"), (Object)url.getPathParts());
        url.appendRawPath("c/d");
        GenericUrlTest.assertEquals(Arrays.asList("", "", "", "abc", "d"), (Object)url.getPathParts());
        url.appendRawPath("/e");
        GenericUrlTest.assertEquals(Arrays.asList("", "", "", "abc", "d", "e"), (Object)url.getPathParts());
        url.appendRawPath("/");
        GenericUrlTest.assertEquals(Arrays.asList("", "", "", "abc", "d", "e", ""), (Object)url.getPathParts());
    }

    public void testRepeatedParam_build() {
        GenericUrl url = new GenericUrl();
        url.setScheme("https");
        url.setHost("www.googleapis.com");
        url.setPathParts(REPEATED_PARAM_PATH_PARTS);
        url.set("q", Arrays.asList("c", "a", "b"));
        url.set("s", (Object)"e");
        GenericUrlTest.assertEquals((String)REPEATED_PARAM, (String)url.build());
    }

    public void testRepeatedParam_parse() {
        GenericUrl url = new GenericUrl(REPEATED_PARAM);
        GenericUrlTest.assertEquals((String)"https", (String)url.getScheme());
        GenericUrlTest.assertEquals((String)"www.googleapis.com", (String)url.getHost());
        GenericUrlTest.assertEquals(REPEATED_PARAM_PATH_PARTS, (Object)url.getPathParts());
        GenericUrlTest.assertEquals((Object)"c", (Object)url.getFirst("q"));
        GenericUrlTest.assertEquals((Object)"e", (Object)url.getFirst("s"));
        GenericUrlTest.assertEquals(Arrays.asList("e"), (Object)url.get((Object)"s"));
        Collection q = (Collection)url.get((Object)"q");
        Iterator i = q.iterator();
        GenericUrlTest.assertEquals((Object)"c", i.next());
        GenericUrlTest.assertEquals((Object)"a", i.next());
        GenericUrlTest.assertEquals((Object)"b", i.next());
        GenericUrlTest.assertFalse((boolean)i.hasNext());
        GenericUrlTest.assertEquals(Arrays.asList("c", "a", "b"), new ArrayList(url.getAll("q")));
    }

    public void testBuild_noValue() {
        GenericUrl url = new GenericUrl();
        url.setScheme("https");
        url.setHost("www.googleapis.com");
        url.setRawPath(REPEATED_PARAM_PATH);
        url.set("noval", (Object)"");
        GenericUrlTest.assertEquals((String)"https://www.googleapis.com/latitude/v1/location?noval", (String)url.build());
    }

    public void testClone() {
        GenericUrl url = new GenericUrl("http://www.google.com");
        GenericUrl clone = url.clone();
        GenericUrlTest.assertEquals((String)"http://www.google.com", (String)clone.build());
    }

    public void testToUrl_relative() {
        this.testRedirectUtility("http://www.google.com/test", "http://www.google.com", "/test");
        this.testRedirectUtility("http://www.google.com/test", "http://www.google.com/foo/bar/", "/test");
        this.testRedirectUtility("http://www.google.com/test", "http://www.google.com", "test");
        this.testRedirectUtility("http://www.google.com/test", "http://www.google.com/foo", "test");
        this.testRedirectUtility("http://www.google.com/foo/test", "http://www.google.com/foo/", "test");
        this.testRedirectUtility("http://www.google.com/foo/test", "http://www.google.com/foo/bar", "test");
        this.testRedirectUtility("http://www.google.com/foo/test/", "http://www.google.com/foo/bar", "test/");
        this.testRedirectUtility("http://www.google.com/foo/test/sub", "http://www.google.com/foo/bar", "test/sub");
        this.testRedirectUtility("https://example.com/test", "http://www.google.com/foo", "https://example.com/test");
        this.testRedirectUtility("https://example.com/test", "http://www.google.com", "https://example.com/test");
        this.testRedirectUtility("https://example.com/test", "http://www.google.com/", "https://example.com/test");
    }

    private void testRedirectUtility(String expectedResult, String url, String relative) {
        GenericUrl gu = new GenericUrl(url);
        GenericUrl redirectedUrl = new GenericUrl(gu.toURL(relative));
        GenericUrlTest.assertEquals((String)expectedResult, (String)redirectedUrl.toString());
    }

    public static class FieldTypesUrl
    extends GenericUrl {
        @Key
        Boolean B;
        @Key
        Double D;
        @Key
        Integer I;
        @Key
        boolean b;
        @Key
        double d;
        @Key
        int i;
        @Key
        String s;
        String hidden;

        FieldTypesUrl() {
        }

        FieldTypesUrl(String encodedUrl) {
            super(encodedUrl);
        }

        public FieldTypesUrl set(String fieldName, Object value) {
            return (FieldTypesUrl)super.set(fieldName, value);
        }
    }

    public static class TestUrl
    extends GenericUrl {
        @Key
        String foo;
        public String hidden;

        public TestUrl() {
        }

        public TestUrl(String encodedUrl) {
            super(encodedUrl);
        }
    }
}

