/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.BackOffPolicy;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GZipEncoding;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpEncoding;
import com.google.api.client.http.HttpEncodingStreamingContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockHttpUnsuccessfulResponseHandler;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.testing.util.LogRecordingHandler;
import com.google.api.client.testing.util.MockBackOff;
import com.google.api.client.testing.util.MockSleeper;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Key;
import com.google.api.client.util.LoggingStreamingContent;
import com.google.api.client.util.Sleeper;
import com.google.api.client.util.StringUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Handler;
import java.util.logging.Level;
import junit.framework.Assert;
import junit.framework.TestCase;

public class HttpRequestTest
extends TestCase {
    private static final ImmutableSet<String> BASIC_METHODS = ImmutableSet.of((Object)"GET", (Object)"PUT", (Object)"POST", (Object)"DELETE");
    private static final ImmutableSet<String> OTHER_METHODS = ImmutableSet.of((Object)"HEAD", (Object)"PATCH");

    public HttpRequestTest(String name) {
        super(name);
    }

    public void setUp() {
        HttpTransport.LOGGER.setLevel(Level.SEVERE);
    }

    public void tearDown() {
        HttpTransport.LOGGER.setLevel(Level.WARNING);
    }

    public void testNotSupportedByDefault() throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        for (String method : BASIC_METHODS) {
            request.setRequestMethod(method);
            request.execute();
        }
        for (String method : OTHER_METHODS) {
            transport = new MockHttpTransport.Builder().setSupportedMethods((Set)ImmutableSet.of()).build();
            request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
            request.setRequestMethod(method);
            try {
                request.execute();
                HttpRequestTest.fail((String)"expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            transport = new MockHttpTransport.Builder().setSupportedMethods((Set)ImmutableSet.of((Object)method)).build();
            request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
            request.setRequestMethod(method);
            request.execute();
        }
    }

    private void setBackOffUnsuccessfulResponseHandler(HttpRequest request, BackOff backOff, final HttpUnsuccessfulResponseHandler handler) {
        final HttpBackOffUnsuccessfulResponseHandler backOffHandler = new HttpBackOffUnsuccessfulResponseHandler(backOff).setSleeper((Sleeper)new MockSleeper());
        request.setUnsuccessfulResponseHandler(new HttpUnsuccessfulResponseHandler(){

            public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
                return handler.handleResponse(request, response, supportsRetry) || backOffHandler.handleResponse(request, response, supportsRetry);
            }
        });
    }

    public void test301Redirect() throws Exception {
        RedirectTransport fakeTransport = new RedirectTransport();
        HttpRequest request = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://gmail.com"));
        HttpResponse resp = request.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    @Deprecated
    public void test301RedirectWithUnsuccessfulResponseHandled() throws Exception {
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(true);
        MockBackOffPolicy backOffPolicy = new MockBackOffPolicy();
        RedirectTransport fakeTransport = new RedirectTransport();
        HttpRequest request = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://gmail.com"));
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)handler);
        request.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        HttpResponse resp = request.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((String)"http://gmail.com", (String)request.getUrl().toString());
        Assert.assertEquals((int)1, (int)backOffPolicy.resetCalls);
        Assert.assertEquals((int)0, (int)backOffPolicy.backOffCalls);
        Assert.assertTrue((boolean)handler.isCalled());
    }

    public void test301RedirectWithBackOffUnsuccessfulResponseHandled() throws Exception {
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(true);
        RedirectTransport fakeTransport = new RedirectTransport();
        HttpRequest request = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://gmail.com"));
        MockBackOff backOff = new MockBackOff();
        this.setBackOffUnsuccessfulResponseHandler(request, (BackOff)backOff, (HttpUnsuccessfulResponseHandler)handler);
        HttpResponse resp = request.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((String)"http://gmail.com", (String)request.getUrl().toString());
        Assert.assertEquals((int)0, (int)backOff.getNumberOfTries());
        Assert.assertTrue((boolean)handler.isCalled());
    }

    @Deprecated
    public void test301RedirectWithUnsuccessfulResponseNotHandled() throws Exception {
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        MockBackOffPolicy backOffPolicy = new MockBackOffPolicy();
        RedirectTransport fakeTransport = new RedirectTransport();
        HttpRequest request = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://gmail.com"));
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)handler);
        request.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        HttpResponse resp = request.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((String)"http://google.com/", (String)request.getUrl().toString());
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)1, (int)backOffPolicy.resetCalls);
        Assert.assertEquals((int)0, (int)backOffPolicy.backOffCalls);
    }

    public void test301RedirectWithBackOffUnsuccessfulResponseNotHandled() throws Exception {
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        RedirectTransport fakeTransport = new RedirectTransport();
        HttpRequest request = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://gmail.com"));
        MockBackOff backOff = new MockBackOff();
        this.setBackOffUnsuccessfulResponseHandler(request, (BackOff)backOff, (HttpUnsuccessfulResponseHandler)handler);
        HttpResponse resp = request.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((String)"http://google.com/", (String)request.getUrl().toString());
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)0, (int)backOff.getNumberOfTries());
    }

    public void test303Redirect() throws Exception {
        RedirectTransport fakeTransport = new RedirectTransport();
        fakeTransport.redirectStatusCode = 303;
        byte[] content = new byte[300];
        Arrays.fill(content, (byte)32);
        HttpRequest request = fakeTransport.createRequestFactory().buildPostRequest(new GenericUrl("http://gmail.com"), (HttpContent)new ByteArrayContent(null, content));
        request.setRequestMethod("POST");
        HttpResponse resp = request.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((String)"GET", (String)request.getRequestMethod());
        Assert.assertNull((Object)request.getContent());
    }

    public void testInfiniteRedirects() throws Exception {
        RedirectTransport fakeTransport = new RedirectTransport();
        fakeTransport.infiniteRedirection = true;
        HttpRequest request = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://gmail.com"));
        try {
            request.execute();
            HttpRequestTest.fail((String)"expected HttpResponseException");
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        Assert.assertEquals((int)(request.getNumberOfRetries() + 1), (int)fakeTransport.lowLevelExecCalls);
    }

    public void testMissingLocationRedirect() throws Exception {
        RedirectTransport fakeTransport = new RedirectTransport();
        fakeTransport.removeLocation = true;
        HttpRequest request = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://gmail.com"));
        try {
            request.execute();
            HttpRequestTest.fail((String)"expected HttpResponseException");
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        Assert.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testHandleRedirect() throws Exception {
        StatusCodesTransport transport = new StatusCodesTransport();
        HttpRequest req = transport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        HttpResponse response = req.execute();
        HttpRequestTest.assertFalse((boolean)req.handleRedirect(response.getStatusCode(), response.getHeaders()));
        this.subtestRedirect(301, true);
        this.subtestRedirect(302, true);
        this.subtestRedirect(303, true);
        this.subtestRedirect(307, true);
        this.subtestRedirect(307, false);
    }

    private void subtestRedirect(int statusCode, boolean setLocation) throws Exception {
        StatusCodesTransport transport = new StatusCodesTransport();
        transport.statusCode = statusCode;
        HttpRequest req = transport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setThrowExceptionOnExecuteError(false);
        req.getHeaders().setAuthorization("auth").setIfMatch("etag").setIfNoneMatch("etag").setIfModifiedSince("date").setIfUnmodifiedSince("date").setIfRange("range");
        HttpResponse response = req.execute();
        if (setLocation) {
            response.getHeaders().setLocation("http://redirect/location");
        }
        boolean handleRedirect = req.handleRedirect(response.getStatusCode(), response.getHeaders());
        if (setLocation) {
            HttpRequestTest.assertTrue((boolean)handleRedirect);
            HttpRequestTest.assertNull((Object)req.getHeaders().getAuthorization());
            HttpRequestTest.assertNull((Object)req.getHeaders().getIfMatch());
            HttpRequestTest.assertNull((Object)req.getHeaders().getIfNoneMatch());
            HttpRequestTest.assertNull((Object)req.getHeaders().getIfModifiedSince());
            HttpRequestTest.assertNull((Object)req.getHeaders().getIfUnmodifiedSince());
            HttpRequestTest.assertNull((Object)req.getHeaders().getIfRange());
            HttpRequestTest.assertEquals((String)"http://redirect/location", (String)req.getUrl().toString());
        } else {
            HttpRequestTest.assertFalse((boolean)handleRedirect);
            HttpRequestTest.assertEquals((String)"auth", (String)req.getHeaders().getAuthorization());
            HttpRequestTest.assertEquals((String)"etag", (String)req.getHeaders().getIfMatch());
            HttpRequestTest.assertEquals((String)"etag", (String)req.getHeaders().getIfNoneMatch());
            HttpRequestTest.assertEquals((String)"date", (String)req.getHeaders().getIfModifiedSince());
            HttpRequestTest.assertEquals((String)"date", (String)req.getHeaders().getIfUnmodifiedSince());
            HttpRequestTest.assertEquals((String)"range", (String)req.getHeaders().getIfRange());
            HttpRequestTest.assertEquals((String)"http://not/used", (String)req.getUrl().toString());
        }
    }

    public void testHandleRedirect_relativeLocation() throws IOException {
        this.subtestHandleRedirect_relativeLocation("http://some.org/a/b", "z", "http://some.org/a/z");
        this.subtestHandleRedirect_relativeLocation("http://some.org/a/b", "z/", "http://some.org/a/z/");
        this.subtestHandleRedirect_relativeLocation("http://some.org/a/b", "/z", "http://some.org/z");
        this.subtestHandleRedirect_relativeLocation("http://some.org/a/b", "x/z", "http://some.org/a/x/z");
        this.subtestHandleRedirect_relativeLocation("http://some.org/a/b", "http://other.org/c", "http://other.org/c");
    }

    public void subtestHandleRedirect_relativeLocation(String curLocation, String relLocation, String newLocation) throws IOException {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest req = transport.createRequestFactory().buildGetRequest(new GenericUrl(curLocation));
        HttpHeaders responseHeaders = new HttpHeaders().setLocation(relLocation);
        req.handleRedirect(303, responseHeaders);
        HttpRequestTest.assertEquals((String)newLocation, (String)req.getUrl().toString());
    }

    @Deprecated
    public void testExecuteErrorWithRetryEnabled() throws Exception {
        int callsBeforeSuccess = 3;
        FailThenSuccessConnectionErrorTransport fakeTransport = new FailThenSuccessConnectionErrorTransport(callsBeforeSuccess);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setRetryOnExecuteIOException(true);
        req.setNumberOfRetries(callsBeforeSuccess + 1);
        HttpResponse resp = req.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)4, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testExecuteErrorWithIOExceptionHandler() throws Exception {
        int callsBeforeSuccess = 3;
        FailThenSuccessConnectionErrorTransport fakeTransport = new FailThenSuccessConnectionErrorTransport(callsBeforeSuccess);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler(BackOff.ZERO_BACKOFF));
        req.setNumberOfRetries(callsBeforeSuccess + 1);
        HttpResponse resp = req.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)4, (int)fakeTransport.lowLevelExecCalls);
    }

    @Deprecated
    public void testExecuteErrorWithRetryEnabledBeyondRetryLimit() throws Exception {
        int callsBeforeSuccess = 11;
        FailThenSuccessConnectionErrorTransport fakeTransport = new FailThenSuccessConnectionErrorTransport(callsBeforeSuccess);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setRetryOnExecuteIOException(true);
        req.setNumberOfRetries(callsBeforeSuccess - 1);
        try {
            req.execute();
            HttpRequestTest.fail((String)("Expected: " + IOException.class));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((int)callsBeforeSuccess, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testExecuteErrorWithIOExceptionHandlerBeyondRetryLimit() throws Exception {
        int callsBeforeSuccess = 11;
        FailThenSuccessConnectionErrorTransport fakeTransport = new FailThenSuccessConnectionErrorTransport(callsBeforeSuccess);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler(BackOff.ZERO_BACKOFF));
        req.setNumberOfRetries(callsBeforeSuccess - 1);
        try {
            req.execute();
            HttpRequestTest.fail((String)("Expected: " + IOException.class));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((int)callsBeforeSuccess, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testExecuteErrorWithoutIOExceptionHandler() throws Exception {
        int callsBeforeSuccess = 3;
        FailThenSuccessConnectionErrorTransport fakeTransport = new FailThenSuccessConnectionErrorTransport(callsBeforeSuccess);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setNumberOfRetries(callsBeforeSuccess + 1);
        try {
            req.execute();
            HttpRequestTest.fail((String)("Expected: " + IOException.class));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    @Deprecated
    public void testUserAgentWithExecuteErrorAndRetryEnabled() throws Exception {
        int callsBeforeSuccess = 3;
        FailThenSuccessConnectionErrorTransport fakeTransport = new FailThenSuccessConnectionErrorTransport(callsBeforeSuccess);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setRetryOnExecuteIOException(true);
        req.setNumberOfRetries(callsBeforeSuccess + 1);
        HttpResponse resp = req.execute();
        Assert.assertEquals((int)1, (int)fakeTransport.userAgentHeader.size());
        Assert.assertEquals((String)"Google-HTTP-Java-Client/1.27.0 (gzip)", (String)fakeTransport.userAgentHeader.get(0));
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)4, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUserAgentWithExecuteErrorAndIOExceptionHandler() throws Exception {
        int callsBeforeSuccess = 3;
        FailThenSuccessConnectionErrorTransport fakeTransport = new FailThenSuccessConnectionErrorTransport(callsBeforeSuccess);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler(BackOff.ZERO_BACKOFF));
        req.setNumberOfRetries(callsBeforeSuccess + 1);
        HttpResponse resp = req.execute();
        Assert.assertEquals((int)1, (int)fakeTransport.userAgentHeader.size());
        Assert.assertEquals((String)"Google-HTTP-Java-Client/1.27.0 (gzip)", (String)fakeTransport.userAgentHeader.get(0));
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)4, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testAbnormalResponseHandlerWithNoBackOff() throws Exception {
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(401, 1);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(true);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)handler);
        HttpResponse resp = req.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertTrue((boolean)handler.isCalled());
    }

    @Deprecated
    public void testAbnormalResponseHandlerWithBackOff() throws Exception {
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(500, 1);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(true);
        MockBackOffPolicy backOffPolicy = new MockBackOffPolicy();
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)handler);
        req.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        HttpResponse resp = req.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)1, (int)backOffPolicy.resetCalls);
        Assert.assertEquals((int)0, (int)backOffPolicy.backOffCalls);
        Assert.assertTrue((boolean)handler.isCalled());
    }

    public void testAbnormalResponseHandlerWithBackOffUnsuccessfulResponseHandler() throws Exception {
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(500, 1);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(true);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        MockBackOff backOff = new MockBackOff();
        this.setBackOffUnsuccessfulResponseHandler(req, (BackOff)backOff, (HttpUnsuccessfulResponseHandler)handler);
        HttpResponse resp = req.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)0, (int)backOff.getNumberOfTries());
        Assert.assertTrue((boolean)handler.isCalled());
    }

    @Deprecated
    public void testBackOffSingleCall() throws Exception {
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(500, 1);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        MockBackOffPolicy backOffPolicy = new MockBackOffPolicy();
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)handler);
        req.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        HttpResponse resp = req.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)1, (int)backOffPolicy.resetCalls);
        Assert.assertEquals((int)1, (int)backOffPolicy.backOffCalls);
        Assert.assertTrue((boolean)handler.isCalled());
    }

    public void testBackOffUnsuccessfulResponseSingleCall() throws Exception {
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(500, 1);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        MockBackOff backOff = new MockBackOff();
        this.setBackOffUnsuccessfulResponseHandler(req, (BackOff)backOff, (HttpUnsuccessfulResponseHandler)handler);
        HttpResponse resp = req.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)1, (int)backOff.getNumberOfTries());
        Assert.assertTrue((boolean)handler.isCalled());
    }

    @Deprecated
    public void testBackOffMultipleCalls() throws Exception {
        int callsBeforeSuccess = 5;
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(500, callsBeforeSuccess);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        MockBackOffPolicy backOffPolicy = new MockBackOffPolicy();
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)handler);
        req.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        HttpResponse resp = req.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)(callsBeforeSuccess + 1), (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)1, (int)backOffPolicy.resetCalls);
        Assert.assertEquals((int)callsBeforeSuccess, (int)backOffPolicy.backOffCalls);
        Assert.assertTrue((boolean)handler.isCalled());
    }

    public void testBackOffUnsucessfulReponseMultipleCalls() throws Exception {
        int callsBeforeSuccess = 5;
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(500, callsBeforeSuccess);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        MockBackOff backOff = new MockBackOff();
        this.setBackOffUnsuccessfulResponseHandler(req, (BackOff)backOff, (HttpUnsuccessfulResponseHandler)handler);
        HttpResponse resp = req.execute();
        Assert.assertEquals((int)200, (int)resp.getStatusCode());
        Assert.assertEquals((int)(callsBeforeSuccess + 1), (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)callsBeforeSuccess, (int)backOff.getNumberOfTries());
        Assert.assertTrue((boolean)handler.isCalled());
    }

    @Deprecated
    public void testBackOffCallsBeyondRetryLimit() throws Exception {
        int callsBeforeSuccess = 11;
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(500, callsBeforeSuccess);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        MockBackOffPolicy backOffPolicy = new MockBackOffPolicy();
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setNumberOfRetries(callsBeforeSuccess - 1);
        req.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)handler);
        req.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        try {
            req.execute();
            HttpRequestTest.fail((String)"expected HttpResponseException");
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        Assert.assertEquals((int)callsBeforeSuccess, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)1, (int)backOffPolicy.resetCalls);
        Assert.assertEquals((int)(callsBeforeSuccess - 1), (int)backOffPolicy.backOffCalls);
        Assert.assertTrue((boolean)handler.isCalled());
    }

    public void testBackOffUnsuccessfulReponseCallsBeyondRetryLimit() throws Exception {
        int callsBeforeSuccess = 11;
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(500, callsBeforeSuccess);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setNumberOfRetries(callsBeforeSuccess - 1);
        MockBackOff backOff = new MockBackOff();
        this.setBackOffUnsuccessfulResponseHandler(req, (BackOff)backOff, (HttpUnsuccessfulResponseHandler)handler);
        try {
            req.execute();
            HttpRequestTest.fail((String)"expected HttpResponseException");
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        Assert.assertEquals((int)callsBeforeSuccess, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)(callsBeforeSuccess - 1), (int)backOff.getMaxTries());
        Assert.assertTrue((boolean)handler.isCalled());
    }

    @Deprecated
    public void testBackOffUnRecognizedStatusCode() throws Exception {
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(401, 1);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        MockBackOffPolicy backOffPolicy = new MockBackOffPolicy();
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)handler);
        req.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        try {
            req.execute();
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        Assert.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)1, (int)backOffPolicy.resetCalls);
        Assert.assertEquals((int)0, (int)backOffPolicy.backOffCalls);
        Assert.assertTrue((boolean)handler.isCalled());
    }

    public void testBackOffUnsuccessfulReponseUnRecognizedStatusCode() throws Exception {
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(401, 1);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        MockBackOff backOff = new MockBackOff();
        this.setBackOffUnsuccessfulResponseHandler(req, (BackOff)backOff, (HttpUnsuccessfulResponseHandler)handler);
        try {
            req.execute();
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        Assert.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)0, (int)backOff.getNumberOfTries());
        Assert.assertTrue((boolean)handler.isCalled());
    }

    @Deprecated
    public void testBackOffStop() throws Exception {
        int callsBeforeSuccess = 5;
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(500, callsBeforeSuccess);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        MockBackOffPolicy backOffPolicy = new MockBackOffPolicy();
        backOffPolicy.returnBackOffStop = true;
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        req.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)handler);
        req.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        try {
            req.execute();
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        Assert.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)1, (int)backOffPolicy.resetCalls);
        Assert.assertEquals((int)1, (int)backOffPolicy.backOffCalls);
        Assert.assertTrue((boolean)handler.isCalled());
    }

    public void testBackOffUnsucessfulResponseStop() throws Exception {
        int callsBeforeSuccess = 5;
        FailThenSuccessBackoffTransport fakeTransport = new FailThenSuccessBackoffTransport(500, callsBeforeSuccess);
        MockHttpUnsuccessfulResponseHandler handler = new MockHttpUnsuccessfulResponseHandler(false);
        HttpRequest req = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        MockBackOff backOff = new MockBackOff().setMaxTries(1);
        this.setBackOffUnsuccessfulResponseHandler(req, (BackOff)backOff, (HttpUnsuccessfulResponseHandler)handler);
        try {
            req.execute();
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
        Assert.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
        Assert.assertEquals((int)1, (int)backOff.getNumberOfTries());
        Assert.assertTrue((boolean)handler.isCalled());
    }

    public void testExecute_headerSerialization() throws Exception {
        MyHeaders myHeaders = new MyHeaders();
        myHeaders.foo = "bar";
        myHeaders.objNum = 5;
        myHeaders.list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        myHeaders.objList = ImmutableList.of((Object)"a2", (Object)"b2", (Object)"c2");
        myHeaders.r = new String[]{"a1", "a2"};
        myHeaders.setAcceptEncoding(null);
        myHeaders.setUserAgent("foo");
        myHeaders.set("a", "b");
        myHeaders.value = E.VALUE;
        myHeaders.otherValue = E.OTHER_VALUE;
        final MockLowLevelHttpRequest lowLevelRequest = new MockLowLevelHttpRequest();
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return lowLevelRequest;
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setHeaders((HttpHeaders)myHeaders);
        request.execute();
        HttpRequestTest.assertEquals((Object)ImmutableList.of((Object)"bar"), (Object)lowLevelRequest.getHeaderValues("foo"));
        HttpRequestTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)lowLevelRequest.getHeaderValues("list"));
        HttpRequestTest.assertEquals((Object)ImmutableList.of((Object)"a2", (Object)"b2", (Object)"c2"), (Object)lowLevelRequest.getHeaderValues("objlist"));
        HttpRequestTest.assertEquals((Object)ImmutableList.of((Object)"a1", (Object)"a2"), (Object)lowLevelRequest.getHeaderValues("r"));
        HttpRequestTest.assertTrue((boolean)lowLevelRequest.getHeaderValues("accept-encoding").isEmpty());
        HttpRequestTest.assertEquals((Object)ImmutableList.of((Object)"foo Google-HTTP-Java-Client/1.27.0 (gzip)"), (Object)lowLevelRequest.getHeaderValues("user-agent"));
        HttpRequestTest.assertEquals((Object)ImmutableList.of((Object)"b"), (Object)lowLevelRequest.getHeaderValues("a"));
        HttpRequestTest.assertEquals((Object)ImmutableList.of((Object)"VALUE"), (Object)lowLevelRequest.getHeaderValues("value"));
        HttpRequestTest.assertEquals((Object)ImmutableList.of((Object)"other"), (Object)lowLevelRequest.getHeaderValues("othervalue"));
    }

    public void testGZipEncoding() throws Exception {
        class MyTransport
        extends MockHttpTransport {
            boolean expectGZip;

            MyTransport() {
            }

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        if (expectGZip) {
                            TestCase.assertEquals(HttpEncodingStreamingContent.class, this.getStreamingContent().getClass());
                            TestCase.assertEquals((String)"gzip", (String)this.getContentEncoding());
                            TestCase.assertEquals((long)25L, (long)this.getContentLength());
                        } else {
                            TestCase.assertFalse((boolean)this.getStreamingContent().getClass().equals(HttpEncodingStreamingContent.class));
                            TestCase.assertNull((Object)this.getContentEncoding());
                            TestCase.assertEquals((long)300L, (long)this.getContentLength());
                        }
                        char[] content = new char[300];
                        Arrays.fill(content, ' ');
                        TestCase.assertEquals((String)new String(content), (String)this.getContentAsString());
                        return super.execute();
                    }
                };
            }
        }
        MyTransport transport = new MyTransport();
        byte[] content = new byte[300];
        Arrays.fill(content, (byte)32);
        HttpRequest request = transport.createRequestFactory().buildPostRequest(HttpTesting.SIMPLE_GENERIC_URL, (HttpContent)new ByteArrayContent(new HttpMediaType("text/plain").setCharsetParameter(Charsets.UTF_8).build(), content));
        HttpRequestTest.assertNull((Object)request.getEncoding());
        request.execute();
        HttpRequestTest.assertNull((Object)request.getEncoding());
        request.execute();
        request.setEncoding((HttpEncoding)new GZipEncoding());
        transport.expectGZip = true;
        request.execute();
    }

    public void testContentLoggingLimitWithLoggingEnabledAndDisabled() throws Exception {
        class MyTransport
        extends MockHttpTransport {
            boolean expectLogContent;

            MyTransport() {
            }

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        if (expectLogContent) {
                            TestCase.assertEquals(LoggingStreamingContent.class, this.getStreamingContent().getClass());
                        } else {
                            TestCase.assertEquals(ByteArrayContent.class, this.getStreamingContent().getClass());
                        }
                        return super.execute();
                    }
                };
            }
        }
        MyTransport transport = new MyTransport();
        HttpTransport.LOGGER.setLevel(Level.CONFIG);
        byte[] content = new byte[300];
        Arrays.fill(content, (byte)32);
        HttpRequest request = transport.createRequestFactory().buildPostRequest(HttpTesting.SIMPLE_GENERIC_URL, (HttpContent)new ByteArrayContent("text/html", content));
        HttpRequestTest.assertTrue((boolean)request.isLoggingEnabled());
        transport.expectLogContent = true;
        request.setContentLoggingLimit(300);
        request.execute();
        transport.expectLogContent = true;
        request.setContentLoggingLimit(299);
        request.execute();
        transport.expectLogContent = true;
        request.setContentLoggingLimit(0);
        request.execute();
        transport.expectLogContent = false;
        request.setContentLoggingLimit(300);
        request.setLoggingEnabled(false);
        request.execute();
        try {
            request.setContentLoggingLimit(-1);
            HttpRequestTest.fail((String)("Expected: " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUserAgent() {
        HttpRequestTest.assertTrue((boolean)"Google-HTTP-Java-Client/1.27.0 (gzip)".contains("Google-HTTP-Java-Client"));
        HttpRequestTest.assertTrue((boolean)"Google-HTTP-Java-Client/1.27.0 (gzip)".contains("gzip"));
    }

    public void testExecute_headers() throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.getHeaders().setAccept("*/*");
        request.getHeaders().set("accept", Arrays.asList("text/plain"));
        request.execute();
    }

    public void testSuppressUserAgentSuffix() throws Exception {
        class MyTransport
        extends MockHttpTransport {
            String expectedUserAgent;

            MyTransport() {
            }

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        TestCase.assertEquals((String)expectedUserAgent, (String)this.getFirstHeaderValue("User-Agent"));
                        return super.execute();
                    }
                };
            }
        }
        MyTransport transport = new MyTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        transport.expectedUserAgent = "Google-HTTP-Java-Client/1.27.0 (gzip)";
        request.setSuppressUserAgentSuffix(false);
        request.execute();
        transport.expectedUserAgent = null;
        request.setSuppressUserAgentSuffix(true);
        request.execute();
        transport.expectedUserAgent = "Testing Google-HTTP-Java-Client/1.27.0 (gzip)";
        request.getHeaders().setUserAgent("Testing");
        request.setSuppressUserAgentSuffix(false);
        request.execute();
        transport.expectedUserAgent = "Testing";
        request.getHeaders().setUserAgent("Testing");
        request.setSuppressUserAgentSuffix(true);
        request.execute();
    }

    public void testExecuteAsync() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        MockExecutor mockExecutor = new MockExecutor();
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        Future futureResponse = request.executeAsync((Executor)mockExecutor);
        HttpRequestTest.assertFalse((boolean)futureResponse.isDone());
        mockExecutor.actuallyRun();
        HttpRequestTest.assertTrue((boolean)futureResponse.isDone());
        HttpRequestTest.assertNotNull(futureResponse.get(10L, TimeUnit.MILLISECONDS));
    }

    public void testExecute_redirects() throws Exception {
        class MyTransport
        extends MockHttpTransport {
            int count = 1;

            MyTransport() {
            }

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                TestCase.assertEquals((String)("http://google.com/_" + this.count), (String)url);
                ++this.count;
                return new MockLowLevelHttpRequest().setResponse(new MockLowLevelHttpResponse().setStatusCode(301).setHeaderNames(Arrays.asList("Location")).setHeaderValues(Arrays.asList("http://google.com/_" + this.count)));
            }
        }
        MyTransport transport = new MyTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(new GenericUrl("http://google.com/_" + transport.count));
        try {
            request.execute();
            HttpRequestTest.fail((String)("expected " + HttpResponseException.class));
        }
        catch (HttpResponseException e) {
            HttpRequestTest.assertEquals((int)301, (int)e.getStatusCode());
        }
    }

    public void testExecute_redirectWithIncorrectContentRetryableSetting() throws Exception {
        RedirectTransport fakeTransport = new RedirectTransport();
        String contentValue = "hello";
        fakeTransport.expectedContent = new String[]{contentValue, ""};
        byte[] bytes = StringUtils.getBytesUtf8((String)contentValue);
        InputStreamContent content = new InputStreamContent(new HttpMediaType("text/plain").setCharsetParameter(Charsets.UTF_8).build(), (InputStream)new ByteArrayInputStream(bytes));
        content.setRetrySupported(true);
        HttpRequest request = fakeTransport.createRequestFactory().buildPostRequest(HttpTesting.SIMPLE_GENERIC_URL, (HttpContent)content);
        HttpResponse resp = request.execute();
        HttpRequestTest.assertEquals((int)200, (int)resp.getStatusCode());
        HttpRequestTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testExecute_curlLogger() throws Exception {
        LogRecordingHandler recorder = new LogRecordingHandler();
        HttpTransport.LOGGER.setLevel(Level.CONFIG);
        HttpTransport.LOGGER.addHandler((Handler)recorder);
        new MockHttpTransport().createRequestFactory().buildGetRequest(new GenericUrl("http://google.com/#q=a'b'c")).execute();
        boolean found = false;
        for (String message : recorder.messages()) {
            if (!message.startsWith("curl")) continue;
            found = true;
            HttpRequestTest.assertEquals((String)"curl -v --compressed -H 'Accept-Encoding: gzip' -H 'User-Agent: Google-HTTP-Java-Client/1.27.0 (gzip)' -- 'http://google.com/#q=a'\"'\"'b'\"'\"'c'", (String)message);
        }
        HttpRequestTest.assertTrue((boolean)found);
    }

    public void testExecute_curlLoggerWithContentEncoding() throws Exception {
        LogRecordingHandler recorder = new LogRecordingHandler();
        HttpTransport.LOGGER.setLevel(Level.CONFIG);
        HttpTransport.LOGGER.addHandler((Handler)recorder);
        String contentValue = "hello";
        byte[] bytes = StringUtils.getBytesUtf8((String)contentValue);
        InputStreamContent content = new InputStreamContent(new HttpMediaType("text/plain").setCharsetParameter(Charsets.UTF_8).build(), (InputStream)new ByteArrayInputStream(bytes));
        new MockHttpTransport().createRequestFactory().buildPostRequest(new GenericUrl("http://google.com/#q=a'b'c"), (HttpContent)content).setEncoding((HttpEncoding)new GZipEncoding()).execute();
        boolean found = false;
        String expectedCurlLog = "curl -v --compressed -X POST -H 'Accept-Encoding: gzip' -H 'User-Agent: Google-HTTP-Java-Client/1.27.0 (gzip)' -H 'Content-Type: text/plain; charset=UTF-8' -H 'Content-Encoding: gzip' -d '@-' -- 'http://google.com/#q=a'\"'\"'b'\"'\"'c' << $$$";
        for (String message : recorder.messages()) {
            if (!message.startsWith("curl")) continue;
            found = true;
            HttpRequestTest.assertEquals((String)"curl -v --compressed -X POST -H 'Accept-Encoding: gzip' -H 'User-Agent: Google-HTTP-Java-Client/1.27.0 (gzip)' -H 'Content-Type: text/plain; charset=UTF-8' -H 'Content-Encoding: gzip' -d '@-' -- 'http://google.com/#q=a'\"'\"'b'\"'\"'c' << $$$", (String)message);
        }
        HttpRequestTest.assertTrue((boolean)found);
    }

    public static class MyHeaders
    extends HttpHeaders {
        @Key
        public String foo;
        @Key
        Object objNum;
        @Key
        Object objList;
        @Key
        List<String> list;
        @Key
        String[] r;
        @Key
        E value;
        @Key
        E otherValue;
    }

    public static enum E {
        VALUE,
        OTHER_VALUE;

    }

    private static class StatusCodesTransport
    extends MockHttpTransport {
        int statusCode = 200;
        public MockLowLevelHttpRequest retryableGetRequest = new MockLowLevelHttpRequest(){

            public LowLevelHttpResponse execute() throws IOException {
                MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                response.setStatusCode(StatusCodesTransport.this.statusCode);
                return response;
            }
        };

        public LowLevelHttpRequest buildRequest(String method, String url) {
            return this.retryableGetRequest;
        }
    }

    private static class FailThenSuccessConnectionErrorTransport
    extends MockHttpTransport {
        public int lowLevelExecCalls;
        int callsBeforeSuccess;
        List<String> userAgentHeader = Lists.newArrayList();

        protected FailThenSuccessConnectionErrorTransport(int callsBeforeSuccess) {
            this.callsBeforeSuccess = callsBeforeSuccess;
        }

        public LowLevelHttpRequest buildRequest(String method, String url) {
            return new MockLowLevelHttpRequest(){

                public LowLevelHttpResponse execute() throws IOException {
                    ++FailThenSuccessConnectionErrorTransport.this.lowLevelExecCalls;
                    FailThenSuccessConnectionErrorTransport.this.userAgentHeader = this.getHeaderValues("User-Agent");
                    if (FailThenSuccessConnectionErrorTransport.this.lowLevelExecCalls <= FailThenSuccessConnectionErrorTransport.this.callsBeforeSuccess) {
                        throw new IOException();
                    }
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    response.setStatusCode(200);
                    return response;
                }
            };
        }
    }

    private static class FailThenSuccessBackoffTransport
    extends MockHttpTransport {
        public int lowLevelExecCalls;
        int errorStatusCode;
        int callsBeforeSuccess;
        public LowLevelHttpRequest retryableGetRequest = new MockLowLevelHttpRequest(){

            public LowLevelHttpResponse execute() {
                ++FailThenSuccessBackoffTransport.this.lowLevelExecCalls;
                if (FailThenSuccessBackoffTransport.this.lowLevelExecCalls <= FailThenSuccessBackoffTransport.this.callsBeforeSuccess) {
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    response.setContent("INVALID TOKEN");
                    response.setStatusCode(FailThenSuccessBackoffTransport.this.errorStatusCode);
                    return response;
                }
                MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                response.setContent("{\"data\":{\"foo\":{\"v1\":{}}}}");
                response.setStatusCode(200);
                return response;
            }
        };

        protected FailThenSuccessBackoffTransport(int errorStatusCode, int callsBeforeSuccess) {
            this.errorStatusCode = errorStatusCode;
            this.callsBeforeSuccess = callsBeforeSuccess;
        }

        public LowLevelHttpRequest buildRequest(String method, String url) {
            return this.retryableGetRequest;
        }
    }

    static class RedirectTransport
    extends MockHttpTransport {
        int lowLevelExecCalls;
        boolean removeLocation;
        boolean infiniteRedirection;
        int redirectStatusCode = 301;
        String[] expectedContent;
        LowLevelHttpRequest retryableGetRequest = new MockLowLevelHttpRequest(){

            public LowLevelHttpResponse execute() throws IOException {
                if (RedirectTransport.this.expectedContent != null) {
                    TestCase.assertEquals((String)String.valueOf(RedirectTransport.this.lowLevelExecCalls), (String)RedirectTransport.this.expectedContent[RedirectTransport.this.lowLevelExecCalls], (String)this.getContentAsString());
                }
                ++RedirectTransport.this.lowLevelExecCalls;
                if (RedirectTransport.this.infiniteRedirection || RedirectTransport.this.lowLevelExecCalls == 1) {
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    response.setStatusCode(RedirectTransport.this.redirectStatusCode);
                    if (!RedirectTransport.this.removeLocation) {
                        response.addHeader("Location", "http://google.com/");
                    }
                    return response;
                }
                MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                response.setContent("{\"data\":{\"foo\":{\"v1\":{}}}}");
                return response;
            }
        };

        RedirectTransport() {
        }

        public LowLevelHttpRequest buildRequest(String method, String url) {
            return this.retryableGetRequest;
        }
    }

    @Deprecated
    private static class MockBackOffPolicy
    implements BackOffPolicy {
        int backOffCalls;
        int resetCalls;
        boolean returnBackOffStop;

        MockBackOffPolicy() {
        }

        public boolean isBackOffRequired(int statusCode) {
            switch (statusCode) {
                case 500: 
                case 503: {
                    return true;
                }
            }
            return false;
        }

        public void reset() {
            ++this.resetCalls;
        }

        public long getNextBackOffMillis() {
            ++this.backOffCalls;
            if (this.returnBackOffStop) {
                return -1L;
            }
            return 0L;
        }
    }

    static class MockExecutor
    implements Executor {
        private Runnable runnable;

        MockExecutor() {
        }

        public void actuallyRun() {
            this.runnable.run();
        }

        @Override
        public void execute(Runnable command) {
            this.runnable = command;
        }
    }
}

