/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;

public class HttpResponseExceptionTest
extends TestCase {
    public void testConstructor() throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpHeaders headers = response.getHeaders();
        HttpResponseException e = new HttpResponseException(response);
        HttpResponseExceptionTest.assertEquals((String)"200", (String)e.getMessage());
        HttpResponseExceptionTest.assertNull((Object)e.getContent());
        HttpResponseExceptionTest.assertEquals((int)200, (int)e.getStatusCode());
        HttpResponseExceptionTest.assertNull((Object)e.getStatusMessage());
        HttpResponseExceptionTest.assertTrue((headers == e.getHeaders() ? 1 : 0) != 0);
    }

    public void testBuilder() throws Exception {
        HttpHeaders headers = new HttpHeaders();
        HttpResponseException.Builder builder = new HttpResponseException.Builder(9, "statusMessage", headers).setMessage("message").setContent("content");
        HttpResponseExceptionTest.assertEquals((String)"message", (String)builder.getMessage());
        HttpResponseExceptionTest.assertEquals((String)"content", (String)builder.getContent());
        HttpResponseExceptionTest.assertEquals((int)9, (int)builder.getStatusCode());
        HttpResponseExceptionTest.assertEquals((String)"statusMessage", (String)builder.getStatusMessage());
        HttpResponseExceptionTest.assertTrue((headers == builder.getHeaders() ? 1 : 0) != 0);
        HttpResponseException e = builder.build();
        HttpResponseExceptionTest.assertEquals((String)"message", (String)e.getMessage());
        HttpResponseExceptionTest.assertEquals((String)"content", (String)e.getContent());
        HttpResponseExceptionTest.assertEquals((int)9, (int)e.getStatusCode());
        HttpResponseExceptionTest.assertEquals((String)"statusMessage", (String)e.getStatusMessage());
        HttpResponseExceptionTest.assertTrue((headers == e.getHeaders() ? 1 : 0) != 0);
    }

    public void testConstructorWithStatusMessage() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setReasonPhrase("OK");
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseException e = new HttpResponseException(response);
        HttpResponseExceptionTest.assertEquals((String)"OK", (String)e.getStatusMessage());
    }

    public void testConstructor_noStatusCode() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(0);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        try {
            request.execute();
            HttpResponseExceptionTest.fail();
        }
        catch (HttpResponseException e) {
            HttpResponseExceptionTest.assertEquals((String)"", (String)e.getMessage());
        }
    }

    public void testConstructor_messageButNoStatusCode() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(0);
                        result.setReasonPhrase("Foo");
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        try {
            request.execute();
            HttpResponseExceptionTest.fail();
        }
        catch (HttpResponseException e) {
            HttpResponseExceptionTest.assertEquals((String)"Foo", (String)e.getMessage());
        }
    }

    public void testComputeMessage() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setReasonPhrase("Foo");
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseExceptionTest.assertEquals((String)"200 Foo", (String)HttpResponseException.computeMessageBuffer((HttpResponse)response).toString());
    }

    public void testThrown() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(404);
                        result.setReasonPhrase("Not Found");
                        result.setContent("Unable to find resource");
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        try {
            request.execute();
            HttpResponseExceptionTest.fail();
        }
        catch (HttpResponseException e) {
            HttpResponseExceptionTest.assertEquals((String)("404 Not Found" + StringUtils.LINE_SEPARATOR + "Unable to find resource"), (String)e.getMessage());
        }
    }

    public void testSerialization() throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseException e = new HttpResponseException(response);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream s = new ObjectOutputStream(out);
        s.writeObject((Object)e);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(in);
        HttpResponseException e2 = (HttpResponseException)((Object)objectInput.readObject());
        HttpResponseExceptionTest.assertEquals((String)e.getMessage(), (String)e2.getMessage());
        HttpResponseExceptionTest.assertEquals((int)e.getStatusCode(), (int)e2.getStatusCode());
        HttpResponseExceptionTest.assertNull((Object)e2.getHeaders());
    }
}

