/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.testing.util.LogRecordingHandler;
import com.google.api.client.testing.util.TestableByteArrayInputStream;
import com.google.api.client.util.Key;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.logging.Handler;
import java.util.logging.Level;
import junit.framework.TestCase;

public class HttpResponseTest
extends TestCase {
    private static final String SAMPLE = "123\u05d9\u05e0\u05d9\u05d1";
    private static final String SAMPLE2 = "123abc";
    static final String ETAG_VALUE = "\"abc\"";

    public HttpResponseTest() {
    }

    public HttpResponseTest(String name) {
        super(name);
    }

    public void testParseAsString_none() throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)"", (String)response.parseAsString());
    }

    public void testParseAsString_utf8() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContentType("application/json; charset=UTF-8");
                        result.setContent(HttpResponseTest.SAMPLE);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)SAMPLE, (String)response.parseAsString());
    }

    public void testParseAsString_noContentType() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent(HttpResponseTest.SAMPLE2);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)SAMPLE2, (String)response.parseAsString());
    }

    public void testStatusCode_negative_dontThrowException() throws Exception {
        this.subtestStatusCode_negative(false);
    }

    public void testStatusCode_negative_throwException() throws Exception {
        this.subtestStatusCode_negative(true);
    }

    private void subtestStatusCode_negative(boolean throwExceptionOnExecuteError) throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest().setResponse(new MockLowLevelHttpResponse().setStatusCode(-1));
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(throwExceptionOnExecuteError);
        try {
            HttpResponse response = request.execute();
            HttpResponseTest.assertEquals((int)0, (int)response.getStatusCode());
            HttpResponseTest.assertFalse((boolean)throwExceptionOnExecuteError);
        }
        catch (HttpResponseException e) {
            HttpResponseTest.assertTrue((boolean)throwExceptionOnExecuteError);
            HttpResponseTest.assertEquals((int)0, (int)e.getStatusCode());
        }
    }

    public void testHeaderParsing() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.addHeader("accept", "value");
                        result.addHeader("foo", "bar");
                        result.addHeader("goo", "car");
                        result.addHeader("hoo", "dar");
                        result.addHeader("hoo", "far");
                        result.addHeader("obj", "o");
                        result.addHeader("r", "a1");
                        result.addHeader("r", "a2");
                        result.addHeader("ETAG", HttpResponseTest.ETAG_VALUE);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setResponseHeaders((HttpHeaders)new MyHeaders());
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)"value", (String)response.getHeaders().getAccept());
        HttpResponseTest.assertEquals((String)"bar", (String)((MyHeaders)response.getHeaders()).foo);
        HttpResponseTest.assertEquals(Arrays.asList("o"), (Object)((MyHeaders)response.getHeaders()).obj);
        HttpResponseTest.assertEquals(Arrays.asList("a1", "a2"), Arrays.asList(((MyHeaders)response.getHeaders()).r));
        HttpResponseTest.assertEquals(Arrays.asList("car"), (Object)response.getHeaders().get((Object)"goo"));
        HttpResponseTest.assertEquals(Arrays.asList("dar", "far"), (Object)response.getHeaders().get((Object)"hoo"));
        HttpResponseTest.assertEquals((String)ETAG_VALUE, (String)response.getHeaders().getETag());
    }

    public void testParseAs_noParser() throws Exception {
        try {
            new MockHttpTransport().createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL).execute().parseAs(Object.class);
            HttpResponseTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParseAs_classNoContent() throws Exception {
        final MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
        for (final int status : new int[]{204, 304, 102}) {
            MockHttpTransport transport = new MockHttpTransport(){

                public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                    return new MockLowLevelHttpRequest(){

                        public LowLevelHttpResponse execute() throws IOException {
                            result.setStatusCode(status);
                            result.setContentType(null);
                            result.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
                            return result;
                        }
                    };
                }
            };
            Object parsed = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL).setThrowExceptionOnExecuteError(false).execute().parseAs(Object.class);
            HttpResponseTest.assertNull((Object)parsed);
        }
    }

    public void testParseAs_typeNoContent() throws Exception {
        final MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
        for (final int status : new int[]{204, 304, 102}) {
            MockHttpTransport transport = new MockHttpTransport(){

                public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                    return new MockLowLevelHttpRequest(){

                        public LowLevelHttpResponse execute() throws IOException {
                            result.setStatusCode(status);
                            result.setContentType(null);
                            result.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
                            return result;
                        }
                    };
                }
            };
            Object parsed = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL).setThrowExceptionOnExecuteError(false).execute().parseAs(Object.class);
            HttpResponseTest.assertNull((Object)parsed);
        }
    }

    public void testDownload() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContentType("application/json; charset=UTF-8");
                        result.setContent(HttpResponseTest.SAMPLE);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        response.download((OutputStream)outputStream);
        HttpResponseTest.assertEquals((String)SAMPLE, (String)outputStream.toString("UTF-8"));
    }

    public void testDisconnectWithContent() throws Exception {
        final MockLowLevelHttpResponse lowLevelHttpResponse = new MockLowLevelHttpResponse();
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        lowLevelHttpResponse.setContentType("application/json; charset=UTF-8");
                        lowLevelHttpResponse.setContent(HttpResponseTest.SAMPLE);
                        return lowLevelHttpResponse;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertFalse((boolean)lowLevelHttpResponse.isDisconnected());
        TestableByteArrayInputStream content = (TestableByteArrayInputStream)lowLevelHttpResponse.getContent();
        HttpResponseTest.assertFalse((boolean)content.isClosed());
        response.disconnect();
        HttpResponseTest.assertTrue((boolean)lowLevelHttpResponse.isDisconnected());
        HttpResponseTest.assertTrue((boolean)content.isClosed());
    }

    public void testDisconnectWithNoContent() throws Exception {
        final MockLowLevelHttpResponse lowLevelHttpResponse = new MockLowLevelHttpResponse();
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        return lowLevelHttpResponse;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertFalse((boolean)lowLevelHttpResponse.isDisconnected());
        response.disconnect();
        HttpResponseTest.assertTrue((boolean)lowLevelHttpResponse.isDisconnected());
    }

    public void testContentLoggingLimitWithLoggingEnabledAndDisabled() throws Exception {
        this.subtestContentLoggingLimit("", 2, false, new String[0]);
        this.subtestContentLoggingLimit("A", 2, false, new String[0]);
        this.subtestContentLoggingLimit("ABC\u0000DEF", 20, true, "Total: 7 bytes", "ABC DEF");
        this.subtestContentLoggingLimit("A", 2, true, "Total: 1 byte", "A");
        try {
            this.subtestContentLoggingLimit("ABC", -1, true, new String[0]);
            HttpResponseTest.fail((String)("Expected: " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.subtestContentLoggingLimit("ABC", 0, true, "Total: 3 bytes");
        this.subtestContentLoggingLimit("ABC", 2, true, "Total: 3 bytes (logging first 2 bytes)", "AB");
        this.subtestContentLoggingLimit("ABC", 3, true, "Total: 3 bytes", "ABC");
        this.subtestContentLoggingLimit("ABC", 4, true, "Total: 3 bytes", "ABC");
        char[] a = new char[18000];
        Arrays.fill(a, 'x');
        String big = new String(a);
        String formated18kInteger = NumberFormat.getInstance().format(18000L);
        this.subtestContentLoggingLimit(big, Integer.MAX_VALUE, true, String.format("Total: %s bytes", formated18kInteger), big);
        this.subtestContentLoggingLimit(big, 4, true, String.format("Total: %s bytes (logging first 4 bytes)", formated18kInteger), "xxxx");
    }

    public void subtestContentLoggingLimit(final String content, int contentLoggingLimit, boolean loggingEnabled, String ... expectedMessages) throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent(content);
                        result.setContentType("text/plain");
                        return result;
                    }
                };
            }
        };
        HttpTransport.LOGGER.setLevel(Level.CONFIG);
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setLoggingEnabled(loggingEnabled);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((boolean)loggingEnabled, (boolean)response.isLoggingEnabled());
        response.setContentLoggingLimit(contentLoggingLimit);
        LogRecordingHandler recorder = new LogRecordingHandler();
        HttpTransport.LOGGER.addHandler((Handler)recorder);
        response.parseAsString();
        HttpResponseTest.assertEquals(Arrays.asList(expectedMessages), (Object)recorder.messages());
    }

    public void testGetContent_gzipNoContent() throws IOException {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent("");
                        result.setContentEncoding("gzip");
                        result.setContentType("text/plain");
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildHeadRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.execute().getContent();
    }

    public static class MyHeaders
    extends HttpHeaders {
        @Key
        public String foo;
        @Key
        public Object obj;
        @Key
        String[] r;
    }
}

