/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import junit.framework.TestCase;

public class MultipartContentTest
extends TestCase {
    private static final String CRLF = "\r\n";
    private static final String CONTENT_TYPE = "application/json; charset=UTF-8";
    private static final String HEADERS = "Content-Length: 3\r\nContent-Type: application/json; charset=UTF-8\r\ncontent-transfer-encoding: binary\r\n";

    public void testContent() throws Exception {
        this.subtestContent("--__END_OF_PART__--\r\n", null, new String[0]);
        this.subtestContent("--__END_OF_PART__\r\nContent-Length: 3\r\nContent-Type: application/json; charset=UTF-8\r\ncontent-transfer-encoding: binary\r\n\r\nfoo\r\n--__END_OF_PART__--\r\n", null, "foo");
        this.subtestContent("--__END_OF_PART__\r\nContent-Length: 3\r\nContent-Type: application/json; charset=UTF-8\r\ncontent-transfer-encoding: binary\r\n\r\nfoo\r\n--__END_OF_PART__\r\nContent-Length: 3\r\nContent-Type: application/json; charset=UTF-8\r\ncontent-transfer-encoding: binary\r\n\r\nbar\r\n--__END_OF_PART__--\r\n", null, "foo", "bar");
        this.subtestContent("--myboundary\r\nContent-Length: 3\r\nContent-Type: application/json; charset=UTF-8\r\ncontent-transfer-encoding: binary\r\n\r\nfoo\r\n--myboundary\r\nContent-Length: 3\r\nContent-Type: application/json; charset=UTF-8\r\ncontent-transfer-encoding: binary\r\n\r\nbar\r\n--myboundary--\r\n", "myboundary", "foo", "bar");
    }

    private void subtestContent(String expectedContent, String boundaryString, String ... contents) throws Exception {
        MultipartContent content = new MultipartContent();
        for (String contentValue : contents) {
            content.addPart(new MultipartContent.Part((HttpContent)ByteArrayContent.fromString((String)CONTENT_TYPE, (String)contentValue)));
        }
        if (boundaryString != null) {
            content.setBoundary(boundaryString);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        content.writeTo((OutputStream)out);
        MultipartContentTest.assertEquals((String)expectedContent, (String)out.toString());
        MultipartContentTest.assertEquals((long)StringUtils.getBytesUtf8((String)expectedContent).length, (long)content.getLength());
        MultipartContentTest.assertEquals((String)(boundaryString == null ? "multipart/related; boundary=__END_OF_PART__" : "multipart/related; boundary=" + boundaryString), (String)content.getType());
    }
}

