/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache;

import com.google.api.client.http.apache.ApacheHttpRequest;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.util.ByteArrayStreamingContent;
import com.google.api.client.util.StreamingContent;
import com.google.api.client.util.StringUtils;
import junit.framework.TestCase;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ApacheHttpTransportTest
extends TestCase {
    public void testApacheHttpTransport() {
        ApacheHttpTransport transport = new ApacheHttpTransport();
        DefaultHttpClient httpClient = (DefaultHttpClient)transport.getHttpClient();
        this.checkDefaultHttpClient(httpClient);
        this.checkHttpClient((HttpClient)httpClient);
    }

    public void testApacheHttpTransportWithParam() {
        ApacheHttpTransport transport = new ApacheHttpTransport((HttpClient)new DefaultHttpClient());
        this.checkHttpClient(transport.getHttpClient());
    }

    public void testNewDefaultHttpClient() {
        this.checkDefaultHttpClient(ApacheHttpTransport.newDefaultHttpClient());
    }

    public void testRequestsWithContent() throws Exception {
        HttpClient mockClient = (HttpClient)Mockito.mock(HttpClient.class);
        HttpResponse mockResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)mockClient.execute((HttpUriRequest)Matchers.any(HttpUriRequest.class))).thenReturn((Object)mockResponse);
        ApacheHttpTransport transport = new ApacheHttpTransport(mockClient);
        this.subtestUnsupportedRequestsWithContent(transport.buildRequest("GET", "http://www.test.url"), "GET");
        this.subtestUnsupportedRequestsWithContent(transport.buildRequest("DELETE", "http://www.test.url"), "DELETE");
        this.subtestUnsupportedRequestsWithContent(transport.buildRequest("HEAD", "http://www.test.url"), "HEAD");
        this.execute(transport.buildRequest("PUT", "http://www.test.url"));
        this.execute(transport.buildRequest("POST", "http://www.test.url"));
        this.execute(transport.buildRequest("PATCH", "http://www.test.url"));
    }

    private void subtestUnsupportedRequestsWithContent(ApacheHttpRequest request, String method) throws Exception {
        try {
            this.execute(request);
            ApacheHttpTransportTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException e) {
            ApacheHttpTransportTest.assertEquals((String)e.getMessage(), (String)("Apache HTTP client does not support " + method + " requests with content."));
        }
    }

    private void execute(ApacheHttpRequest request) throws Exception {
        byte[] bytes = StringUtils.getBytesUtf8((String)"abc");
        request.setStreamingContent((StreamingContent)new ByteArrayStreamingContent(bytes));
        request.setContentType("text/html");
        request.setContentLength((long)bytes.length);
        request.execute();
    }

    private void checkDefaultHttpClient(DefaultHttpClient client) {
        HttpParams params = client.getParams();
        ApacheHttpTransportTest.assertTrue((boolean)(client.getConnectionManager() instanceof ThreadSafeClientConnManager));
        ApacheHttpTransportTest.assertEquals((int)8192, (int)params.getIntParameter("http.socket.buffer-size", -1));
        DefaultHttpRequestRetryHandler retryHandler = (DefaultHttpRequestRetryHandler)client.getHttpRequestRetryHandler();
        ApacheHttpTransportTest.assertEquals((int)0, (int)retryHandler.getRetryCount());
        ApacheHttpTransportTest.assertFalse((boolean)retryHandler.isRequestSentRetryEnabled());
    }

    private void checkHttpClient(HttpClient client) {
        HttpParams params = client.getParams();
        ApacheHttpTransportTest.assertFalse((boolean)params.getBooleanParameter("http.protocol.handle-redirects", true));
        ApacheHttpTransportTest.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)HttpProtocolParams.getVersion((HttpParams)params));
    }
}

