/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import com.google.api.client.http.javanet.NetHttpRequest;
import com.google.api.client.http.javanet.NetHttpResponse;
import com.google.api.client.testing.http.javanet.MockHttpURLConnection;
import com.google.api.client.util.ByteArrayStreamingContent;
import com.google.api.client.util.StreamingContent;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import junit.framework.TestCase;

public class NetHttpTransportTest
extends TestCase {
    private static final String[] METHODS = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"};

    public void testExecute_mock() throws Exception {
        for (String method : METHODS) {
            boolean isPutOrPost = method.equals("PUT") || method.equals("POST");
            MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/"));
            connection.setRequestMethod(method);
            NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
            this.setContent(request, null, "");
            request.execute();
            NetHttpTransportTest.assertEquals((boolean)isPutOrPost, (boolean)connection.doOutputCalled());
            this.setContent(request, null, " ");
            if (isPutOrPost) {
                request.execute();
            } else {
                try {
                    request.execute();
                    NetHttpTransportTest.fail((String)("expected " + IllegalArgumentException.class));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            NetHttpTransportTest.assertEquals((boolean)isPutOrPost, (boolean)connection.doOutputCalled());
        }
    }

    public void testExecute_methodUnchanged() throws Exception {
        String body = "Arbitrary body";
        byte[] buf = StringUtils.getBytesUtf8((String)body);
        for (String method : METHODS) {
            MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/")).setResponseCode(200).setInputStream((InputStream)new ByteArrayInputStream(buf));
            connection.setRequestMethod(method);
            NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
            this.setContent(request, "text/html", "");
            request.execute().getContent().close();
            NetHttpTransportTest.assertEquals((String)method, (String)connection.getRequestMethod());
        }
    }

    public void testAbruptTerminationIsNoticedWithContentLength() throws Exception {
        String incompleteBody = "Fixed size body test.\r\nIncomplete response.";
        byte[] buf = StringUtils.getBytesUtf8((String)incompleteBody);
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/")).setResponseCode(200).addHeader("Content-Length", "205").setInputStream((InputStream)new ByteArrayInputStream(buf));
        connection.setRequestMethod("GET");
        NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
        this.setContent(request, null, "");
        NetHttpResponse response = (NetHttpResponse)request.execute();
        InputStream in = response.getContent();
        boolean thrown = false;
        try {
            while (in.read() != -1) {
            }
        }
        catch (IOException ioe) {
            thrown = true;
        }
        NetHttpTransportTest.assertTrue((boolean)thrown);
    }

    public void testAbruptTerminationIsNoticedWithContentLengthWithReadToBuf() throws Exception {
        String incompleteBody = "Fixed size body test.\r\nIncomplete response.";
        byte[] buf = StringUtils.getBytesUtf8((String)incompleteBody);
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/")).setResponseCode(200).addHeader("Content-Length", "205").setInputStream((InputStream)new ByteArrayInputStream(buf));
        connection.setRequestMethod("GET");
        NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
        this.setContent(request, null, "");
        NetHttpResponse response = (NetHttpResponse)request.execute();
        InputStream in = response.getContent();
        boolean thrown = false;
        try {
            while (in.read(new byte[100]) != -1) {
            }
        }
        catch (IOException ioe) {
            thrown = true;
        }
        NetHttpTransportTest.assertTrue((boolean)thrown);
    }

    private void setContent(NetHttpRequest request, String type, String value) throws Exception {
        byte[] bytes = StringUtils.getBytesUtf8((String)value);
        request.setStreamingContent((StreamingContent)new ByteArrayStreamingContent(bytes));
        request.setContentType(type);
        request.setContentLength((long)bytes.length);
    }
}

