/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class JsonObjectParserTest
extends TestCase {
    public void testConstructor_null() {
        try {
            new JsonObjectParser((JsonFactory)null);
            JsonObjectParserTest.fail((String)"Did not throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParse_InputStream() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[256]);
        Charset utf8 = Charsets.UTF_8;
        Class<Integer[]> type = Integer[].class;
        Integer[] parsed = new Integer[1];
        JsonParser mockJsonParser = (JsonParser)Mockito.mock(JsonParser.class);
        Mockito.when((Object)mockJsonParser.parse(type, true)).thenReturn((Object)parsed);
        JsonFactory mockJsonFactory = (JsonFactory)Mockito.mock(JsonFactory.class);
        Mockito.when((Object)mockJsonFactory.createJsonParser((InputStream)in, utf8)).thenReturn((Object)mockJsonParser);
        JsonObjectParser jop = new JsonObjectParser(mockJsonFactory);
        JsonObjectParserTest.assertEquals((Object)parsed, (Object)jop.parseAndClose((InputStream)in, utf8, type));
    }

    public void testParse_Reader() throws Exception {
        StringReader in = new StringReader("something");
        Class<Integer[]> type = Integer[].class;
        Integer[] parsed = new Integer[1];
        JsonParser mockJsonParser = (JsonParser)Mockito.mock(JsonParser.class);
        Mockito.when((Object)mockJsonParser.parse(type, true)).thenReturn((Object)parsed);
        JsonFactory mockJsonFactory = (JsonFactory)Mockito.mock(JsonFactory.class);
        Mockito.when((Object)mockJsonFactory.createJsonParser((Reader)in)).thenReturn((Object)mockJsonParser);
        JsonObjectParser jop = new JsonObjectParser(mockJsonFactory);
        JsonObjectParserTest.assertEquals((Object)parsed, (Object)jop.parseAndClose((Reader)in, type));
    }
}

