/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json.webtoken;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.testing.json.MockJsonFactory;
import com.google.api.client.testing.json.webtoken.TestCertificates;
import com.google.api.client.testing.util.SecurityTestUtils;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import javax.net.ssl.X509TrustManager;
import junit.framework.TestCase;

public class JsonWebSignatureTest
extends TestCase {
    public void testSign() throws Exception {
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        payload.setIssuer("issuer").setAudience((Object)"audience").setIssuedAtTimeSeconds(Long.valueOf(0L)).setExpirationTimeSeconds(Long.valueOf(3600L));
        RSAPrivateKey privateKey = SecurityTestUtils.newRsaPrivateKey();
        JsonWebSignatureTest.assertEquals((String)"..kDmKaHNYByLmqAi9ROeLcFmZM7W_emsceKvDZiEGAo-ineCunC6_Nb0HEpAuzIidV-LYTMHS3BvI49KFz9gi6hI3ZndDL5EzplpFJo1ZclVk1_hLn94P2OTAkZ4ydsTfus6Bl98EbCkInpF_2t5Fr8OaHxCZCDdDU7W5DSnOsx4", (String)JsonWebSignature.signUsingRsaSha256((PrivateKey)privateKey, (JsonFactory)new MockJsonFactory(), (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload));
    }

    private X509Certificate verifyX509WithCaCert(TestCertificates.CertData caCert) throws Exception {
        JsonWebSignature signature = TestCertificates.getJsonWebSignature();
        X509TrustManager trustManager = caCert.getTrustManager();
        return signature.verifySignature(trustManager);
    }

    public void testVerifyX509() throws Exception {
        X509Certificate signatureCert = this.verifyX509WithCaCert(TestCertificates.CA_CERT);
        JsonWebSignatureTest.assertNotNull((Object)signatureCert);
        JsonWebSignatureTest.assertTrue((boolean)signatureCert.getSubjectDN().getName().startsWith("CN=foo.bar.com"));
    }

    public void testVerifyX509WrongCa() throws Exception {
        JsonWebSignatureTest.assertNull((Object)this.verifyX509WithCaCert(TestCertificates.BOGUS_CA_CERT));
    }
}

