/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.DateTime;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;

public class DateTimeTest
extends TestCase {
    private TimeZone originalTimeZone;

    public DateTimeTest() {
    }

    public DateTimeTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.originalTimeZone = TimeZone.getDefault();
    }

    protected void tearDown() throws Exception {
        TimeZone.setDefault(this.originalTimeZone);
    }

    public void testToStringRfc3339() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-4"));
        DateTimeTest.assertEquals((String)"Check with explicit Date and Timezone.", (String)"2012-11-06T12:10:44.000-08:00", (String)new DateTime(new Date(1352232644000L), TimeZone.getTimeZone("GMT-8")).toStringRfc3339());
        DateTimeTest.assertEquals((String)"Check with explicit Date but no explicit Timezone.", (String)"2012-11-06T16:10:44.000-04:00", (String)new DateTime(new Date(1352232644000L)).toStringRfc3339());
        DateTimeTest.assertEquals((String)"Check with explicit Date and Timezone-Shift.", (String)"2012-11-06T17:10:44.000-03:00", (String)new DateTime(1352232644000L, -180).toStringRfc3339());
        DateTimeTest.assertEquals((String)"Check with explicit Date and Zulu Timezone Offset.", (String)"2012-11-06T20:10:44.000Z", (String)new DateTime(1352232644000L, 0).toStringRfc3339());
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        DateTimeTest.assertEquals((String)"Check with explicit Date but no explicit Timezone.", (String)"2012-11-06T20:10:44.000Z", (String)new DateTime(new Date(1352232644000L)).toStringRfc3339());
    }

    public void testToStringRfc3339_dateOnly() {
        for (String timeZoneString : new String[]{"GMT-4", "UTC", "UTC-7"}) {
            TimeZone.setDefault(TimeZone.getTimeZone(timeZoneString));
            DateTimeTest.assertEquals((String)"2012-11-06", (String)new DateTime(true, 1352232644000L, Integer.valueOf(1)).toStringRfc3339());
            DateTimeTest.assertEquals((String)"2012-11-06", (String)new DateTime(true, 1352232644000L, null).toStringRfc3339());
            DateTimeTest.assertEquals((String)"2000-01-01", (String)new DateTime("2000-01-01").toStringRfc3339());
        }
    }

    public void testEquals() throws InterruptedException {
        DateTimeTest.assertFalse((String)"Check equals with two different tz specified.", (boolean)new DateTime(1234567890L).equals((Object)new DateTime(1234567890L, 120)));
        DateTimeTest.assertTrue((String)"Check equals with two identical tz specified.", (boolean)new DateTime(1234567890L, -240).equals((Object)new DateTime(1234567890L, -240)));
        DateTimeTest.assertFalse((String)"Check equals with two different tz specified.", (boolean)new DateTime(1234567890L, 60).equals((Object)new DateTime(1234567890L, 240)));
        DateTimeTest.assertFalse((String)"Check not equal.", (boolean)new DateTime(1234567890L).equals((Object)new DateTime(9876543210L)));
        DateTimeTest.assertFalse((String)"Check not equal with tz.", (boolean)new DateTime(1234567890L, 120).equals((Object)new DateTime(9876543210L, 120)));
        DateTimeTest.assertFalse((String)"Check not equal with Date.", (boolean)new DateTime(1234567890L).equals((Object)new Date(9876543210L)));
        DateTime dateTime1 = new DateTime("2011-01-01");
        Thread.sleep(10L);
        DateTime dateTime2 = new DateTime("2011-01-01");
        DateTimeTest.assertEquals((Object)dateTime1, (Object)dateTime2);
    }

    public void testParseRfc3339() {
        this.expectExceptionForParseRfc3339("");
        this.expectExceptionForParseRfc3339("abc");
        this.expectExceptionForParseRfc3339("2013-01-01 09:00:02");
        this.expectExceptionForParseRfc3339("2013-01-01T");
        this.expectExceptionForParseRfc3339("1937--3-55T12:00:27+00:20");
        this.expectExceptionForParseRfc3339("2013-01-01Z");
        DateTime value = DateTime.parseRfc3339((String)"2007-06-01");
        DateTimeTest.assertTrue((boolean)value.isDateOnly());
        value = DateTime.parseRfc3339((String)"2007-06-01T10:11:30.057");
        DateTimeTest.assertFalse((boolean)value.isDateOnly());
        value = DateTime.parseRfc3339((String)"2007-06-01T10:11:30Z");
        DateTimeTest.assertEquals((long)0L, (long)(value.getValue() % 100L));
        value = DateTime.parseRfc3339((String)"1997-01-01T12:00:27.87+00:20");
        DateTimeTest.assertFalse((boolean)value.isDateOnly());
        DateTimeTest.assertEquals((long)870L, (long)(value.getValue() % 1000L));
        value = new DateTime("2007-06-01");
        DateTimeTest.assertTrue((boolean)value.isDateOnly());
        value = new DateTime("2007-06-01T10:11:30.057");
        DateTimeTest.assertFalse((boolean)value.isDateOnly());
        value = new DateTime("2007-06-01T10:11:30Z");
        DateTimeTest.assertEquals((long)0L, (long)(value.getValue() % 100L));
        DateTimeTest.assertEquals((long)DateTime.parseRfc3339((String)"1996-12-19T16:39:57-08:00").getValue(), (long)DateTime.parseRfc3339((String)"1996-12-20T00:39:57Z").getValue());
        DateTimeTest.assertEquals((long)DateTime.parseRfc3339((String)"1990-12-31T23:59:60Z").getValue(), (long)DateTime.parseRfc3339((String)"1990-12-31T15:59:60-08:00").getValue());
        DateTimeTest.assertEquals((long)DateTime.parseRfc3339((String)"2007-06-01t18:50:00-04:00").getValue(), (long)DateTime.parseRfc3339((String)"2007-06-01t22:50:00Z").getValue());
    }

    public void testParseAndFormatRfc3339() {
        String input = "1996-12-19T16:39:57.12-08:00";
        String expected = "1996-12-19T16:39:57.120-08:00";
        DateTime dt = DateTime.parseRfc3339((String)input);
        String output = dt.toStringRfc3339();
        DateTimeTest.assertEquals((String)expected, (String)output);
        input = "1996-12-19T16:39:57.123456789-08:00";
        expected = "1996-12-19T16:39:57.123-08:00";
        dt = DateTime.parseRfc3339((String)input);
        output = dt.toStringRfc3339();
        DateTimeTest.assertEquals((String)expected, (String)output);
    }

    private void expectExceptionForParseRfc3339(String input) {
        try {
            DateTime.parseRfc3339((String)input);
            DateTimeTest.fail((String)"expected NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

