/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import java.util.EnumSet;
import junit.framework.Assert;
import junit.framework.TestCase;

public class GenericDataTest
extends TestCase {
    public void testClone_changingEntrySet() {
        GenericData data = new GenericData();
        GenericDataTest.assertEquals((String)"{}", (String)data.toString());
        GenericData clone = data.clone();
        clone.set("foo", (Object)"bar");
        GenericDataTest.assertEquals((String)"{foo=bar}", (String)clone.toString());
    }

    public void testSetIgnoreCase_unknownKey() {
        GenericData data = new GenericData(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        data.set("Foobar", (Object)"oldValue");
        GenericDataTest.assertEquals((Object)"oldValue", (Object)data.get((Object)"Foobar"));
        GenericDataTest.assertEquals((int)1, (int)data.getUnknownKeys().size());
        data.set("fooBAR", (Object)"newValue");
        GenericDataTest.assertEquals((Object)"newValue", (Object)data.get((Object)"Foobar"));
        GenericDataTest.assertEquals((int)1, (int)data.getUnknownKeys().size());
    }

    public void testSetIgnoreCase_class() {
        MyData data = new MyData();
        data.set("FIELDA", "someValue");
        GenericDataTest.assertEquals((String)"someValue", (String)data.fieldA);
        GenericDataTest.assertEquals((int)0, (int)data.getUnknownKeys().size());
    }

    public void testPutIgnoreCase_class() {
        MyData data = new MyData();
        data.fieldA = "123";
        GenericDataTest.assertEquals((Object)"123", (Object)data.put("FIELDA", "someValue"));
        GenericDataTest.assertEquals((String)"someValue", (String)data.fieldA);
        GenericDataTest.assertEquals((int)0, (int)data.getUnknownKeys().size());
    }

    public void testGetIgnoreCase_class() {
        MyData data = new MyData();
        data.fieldA = "someValue";
        GenericDataTest.assertEquals((Object)"someValue", (Object)data.get("FIELDA"));
    }

    public void testRemoveIgnoreCase_class() {
        MyData data = new MyData();
        data.fieldA = "someValue";
        try {
            data.remove("FIELDA");
            Assert.fail((String)"Tried to remove known field from class");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testPutIgnoreCase_unknownKey() {
        GenericData data = new GenericData(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        GenericDataTest.assertEquals(null, (Object)data.put("fooBAR", (Object)"oldValue"));
        GenericDataTest.assertEquals((Object)"oldValue", (Object)data.get((Object)"fooBAR"));
        GenericDataTest.assertEquals((int)1, (int)data.getUnknownKeys().size());
        GenericDataTest.assertEquals((Object)"oldValue", (Object)data.put("fOObar", (Object)"newValue"));
        GenericDataTest.assertEquals((Object)"newValue", (Object)data.get((Object)"fooBAR"));
        GenericDataTest.assertEquals((int)1, (int)data.getUnknownKeys().size());
    }

    public void testGetIgnoreCase_unknownKey() {
        GenericData data = new GenericData(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        data.set("One", (Object)1);
        GenericDataTest.assertEquals((Object)1, (Object)data.get((Object)"ONE"));
        data.set("one", (Object)2);
        GenericDataTest.assertEquals((Object)2, (Object)data.get((Object)"ONE"));
        GenericDataTest.assertEquals(null, (Object)data.get((Object)"unknownKey"));
    }

    public void testRemoveIgnoreCase_unknownKey() {
        GenericData data = new GenericData(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        data.set("One", (Object)1);
        GenericDataTest.assertEquals((Object)1, (Object)data.remove((Object)"OnE"));
        GenericDataTest.assertEquals((int)0, (int)data.getUnknownKeys().size());
        data.set("testA", (Object)1).set("testa", (Object)2);
        GenericDataTest.assertEquals((Object)2, (Object)data.remove((Object)"TESTA"));
        GenericDataTest.assertEquals(null, (Object)data.remove((Object)"TESTA"));
    }

    private class MyData
    extends GenericData {
        @Key(value="FieldA")
        public String fieldA;

        public MyData() {
            super(EnumSet.of(GenericData.Flags.IGNORE_CASE));
        }
    }
}

