/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.IOUtils;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public class IOUtilsTest
extends TestCase {
    static final String VALUE = "abc";

    public void testSerialize() throws IOException {
        byte[] bytes = IOUtils.serialize((Object)VALUE);
        IOUtilsTest.assertEquals((Object)VALUE, (Object)IOUtils.deserialize((byte[])bytes));
    }

    public void testDeserialize() throws IOException {
        IOUtilsTest.assertNull((Object)IOUtils.deserialize((byte[])null));
    }

    public void testIsSymbolicLink_false() throws IOException {
        File file = File.createTempFile("tmp", null);
        file.deleteOnExit();
        IOUtilsTest.assertFalse((boolean)IOUtils.isSymbolicLink((File)file));
    }

    public void testIsSymbolicLink_true() throws IOException, InterruptedException {
        File file = File.createTempFile("tmp", null);
        file.deleteOnExit();
        File file2 = new File(file.getCanonicalPath() + "2");
        file2.deleteOnExit();
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"ln", "-s", file.getCanonicalPath(), file2.getCanonicalPath()});
            process.waitFor();
            process.destroy();
        }
        catch (IOException e) {
            return;
        }
        boolean jdk6 = System.getProperty("java.version").startsWith("1.6.0_");
        IOUtilsTest.assertTrue((IOUtils.isSymbolicLink((File)file2) || jdk6 ? 1 : 0) != 0);
    }
}

