/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Types;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import junit.framework.TestCase;

public class TypesTest
extends TestCase {
    public void testIsAssignableToOrFrom() {
        TypesTest.assertTrue((boolean)Types.isAssignableToOrFrom(String.class, Object.class));
        TypesTest.assertTrue((boolean)Types.isAssignableToOrFrom(String.class, String.class));
        TypesTest.assertTrue((boolean)Types.isAssignableToOrFrom(Object.class, String.class));
        TypesTest.assertFalse((boolean)Types.isAssignableToOrFrom(String.class, List.class));
    }

    public void testNewInstance() {
        TypesTest.assertEquals(Object.class, Types.newInstance(Object.class).getClass());
        TypesTest.assertEquals(String.class, ((String)Types.newInstance(String.class)).getClass());
        TypesTest.assertEquals(Foo.class, ((Foo)Types.newInstance(Foo.class)).getClass());
        try {
            Types.newInstance(Integer.TYPE);
            TypesTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Types.newInstance(String[].class);
            TypesTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Types.newInstance(Void.class);
            TypesTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetBound() throws Exception {
        this.subtestGetBound((Type)((Object)Object.class), "any");
        this.subtestGetBound((Type)((Object)Number.class), "upper");
        this.subtestGetBound((Type)((Object)Integer.class), "lower");
    }

    public void subtestGetBound(Type expectedBound, String fieldName) throws Exception {
        ParameterizedType collectionType = (ParameterizedType)WildcardBounds.class.getField(fieldName).getGenericType();
        WildcardType wildcardType = (WildcardType)collectionType.getActualTypeArguments()[0];
        TypesTest.assertEquals((Object)expectedBound, (Object)Types.getBound((WildcardType)wildcardType));
    }

    public void testResolveTypeVariable() throws Exception {
        TypeVariable tTypeVar = (TypeVariable)Resolve.class.getField("t").getGenericType();
        TypesTest.assertNull((Object)TypesTest.resolveTypeVariable(new Object().getClass(), tTypeVar));
        TypesTest.assertNull((Object)TypesTest.resolveTypeVariable(new Resolve().getClass(), tTypeVar));
        TypesTest.assertEquals(Integer.class, (Object)TypesTest.resolveTypeVariable(new IntegerResolve().getClass(), tTypeVar));
        TypesTest.assertEquals(Long.class, (Object)TypesTest.resolveTypeVariable(new LongResolve().getClass(), tTypeVar));
        TypesTest.assertEquals(Double.class, (Object)TypesTest.resolveTypeVariable(new DoubleResolve().getClass(), tTypeVar));
        TypesTest.assertEquals(MedResolve.class, ((TypeVariable)TypesTest.resolveTypeVariable(new MedResolve().getClass(), tTypeVar)).getGenericDeclaration());
        TypeVariable xTypeVar = (TypeVariable)Resolve.class.getField("x").getGenericType();
        TypesTest.assertNull((Object)TypesTest.resolveTypeVariable(new Object().getClass(), xTypeVar));
        TypesTest.assertEquals(Boolean.class, (Object)Types.getArrayComponentType((Type)TypesTest.resolveTypeVariable(new ArrayResolve().getClass(), xTypeVar)));
        TypesTest.assertEquals(Collection.class, (Object)Types.getRawClass((ParameterizedType)((ParameterizedType)TypesTest.resolveTypeVariable(new ParameterizedResolve().getClass(), xTypeVar))));
    }

    private static Type resolveTypeVariable(Type context, TypeVariable<?> typeVariable) {
        return Types.resolveTypeVariable(Arrays.asList(context), typeVariable);
    }

    public void testGetIterableParameter() throws Exception {
        TypesTest.assertEquals((String)"T", (String)((TypeVariable)Types.getIterableParameter((Type)A.class.getField("tv").getGenericType())).getName());
        TypesTest.assertEquals((String)"T", (String)((TypeVariable)Types.getIterableParameter((Type)A.class.getField("atv").getGenericType())).getName());
        TypesTest.assertEquals(String.class, (Object)Types.getIterableParameter((Type)A.class.getField("i").getGenericType()));
        TypesTest.assertEquals(String.class, (Object)Types.getIterableParameter((Type)A.class.getField("a").getGenericType()));
        TypesTest.assertEquals((String)"E", (String)((TypeVariable)Types.getIterableParameter((Type)A.class.getField("aNoType").getGenericType())).getName());
        TypesTest.assertEquals(Integer.class, (Object)Types.getArrayComponentType((Type)Types.getIterableParameter((Type)A.class.getField("arr").getGenericType())));
        TypesTest.assertEquals((String)"T", (String)((GenericArrayType)Types.getIterableParameter((Type)A.class.getField("tarr").getGenericType())).getGenericComponentType().toString());
        TypesTest.assertEquals(ArrayList.class, (Object)((ParameterizedType)Types.getIterableParameter((Type)A.class.getField("list").getGenericType())).getRawType());
        TypesTest.assertEquals(Number.class, (Object)((WildcardType)Types.getIterableParameter((Type)A.class.getField("wild").getGenericType())).getUpperBounds()[0]);
    }

    public void testGetMapParameter() throws Exception {
        TypesTest.assertEquals((String)"T", (String)((TypeVariable)Types.getMapValueParameter((Type)C.class.getField("tv").getGenericType())).getName());
        TypesTest.assertEquals((String)"T", (String)((TypeVariable)Types.getMapValueParameter((Type)C.class.getField("atv").getGenericType())).getName());
        TypesTest.assertEquals(String.class, (Object)Types.getMapValueParameter((Type)C.class.getField("i").getGenericType()));
        TypesTest.assertEquals(String.class, (Object)Types.getMapValueParameter((Type)C.class.getField("a").getGenericType()));
        TypesTest.assertEquals((String)"V", (String)((TypeVariable)Types.getMapValueParameter((Type)C.class.getField("aNoType").getGenericType())).getName());
        TypesTest.assertEquals(Integer.class, (Object)Types.getArrayComponentType((Type)Types.getIterableParameter((Type)A.class.getField("arr").getGenericType())));
        TypesTest.assertEquals((String)"T", (String)((GenericArrayType)Types.getMapValueParameter((Type)C.class.getField("tarr").getGenericType())).getGenericComponentType().toString());
        TypesTest.assertEquals(ArrayList.class, (Object)((ParameterizedType)Types.getMapValueParameter((Type)C.class.getField("list").getGenericType())).getRawType());
        TypesTest.assertEquals(Number.class, (Object)((WildcardType)Types.getMapValueParameter((Type)C.class.getField("wild").getGenericType())).getUpperBounds()[0]);
    }

    public void testIterableOf() {
        ImmutableList list = ImmutableList.of((Object)"a");
        TypesTest.assertEquals((Object)list, (Object)Types.iterableOf((Object)list));
        TypesTest.assertEquals((Object)list, (Object)Types.iterableOf((Object)new String[]{"a"}));
        TypesTest.assertTrue((boolean)Iterables.elementsEqual((Iterable)ImmutableList.of((Object)1), (Iterable)Types.iterableOf((Object)new int[]{1})));
    }

    public void testToArray() {
        TypesTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "b"}, (String[])Types.toArray((Collection)ImmutableList.of((Object)"a", (Object)"b"), String.class)));
        TypesTest.assertTrue((boolean)Arrays.equals((Object[])new Integer[]{1, 2}, (Object[])((Integer[])Types.toArray((Collection)ImmutableList.of((Object)1, (Object)2), Integer.class))));
        TypesTest.assertTrue((boolean)Arrays.equals(new int[]{1, 2}, (int[])Types.toArray((Collection)ImmutableList.of((Object)1, (Object)2), Integer.TYPE)));
        int[][] arr = (int[][])Types.toArray((Collection)ImmutableList.of((Object)new int[]{1, 2}), int[].class);
        TypesTest.assertEquals((int)1, (int)arr.length);
        TypesTest.assertTrue((boolean)Arrays.equals(new int[]{1, 2}, arr[0]));
    }

    public class D
    extends C<DateTime> {
    }

    public class C<T> {
        public Map<String, String> i;
        public ArrayMap<String, String> a;
        public ArrayMap aNoType;
        public TreeMap<String, ? extends Number> wild;
        public Vector<Integer[]> arr;
        public HashMap<String, T[]> tarr;
        public ImmutableMap<String, ArrayList<Boolean>> list;
        public Map<String, T> tv;
        public ArrayMap<String, T> atv;
    }

    public class B
    extends A<DateTime> {
    }

    public class A<T> {
        public Iterable<String> i;
        public ArrayList<String> a;
        public ArrayList aNoType;
        public Stack<? extends Number> wild;
        public Vector<Integer[]> arr;
        public Vector<T[]> tarr;
        public LinkedList<ArrayList<Boolean>> list;
        public Iterable<T> tv;
        public ArrayList<T> atv;
    }

    static class ParameterizedResolve
    extends Resolve<Collection<Integer>, Integer> {
        ParameterizedResolve() {
        }
    }

    static class ArrayResolve
    extends Resolve<Boolean[], Integer> {
        ArrayResolve() {
        }
    }

    static class LongResolve
    extends Med2Resolve<Long> {
        LongResolve() {
        }
    }

    static class Med2Resolve<T extends Number>
    extends MedResolve<T> {
        Med2Resolve() {
        }
    }

    static class DoubleResolve
    extends MedResolve<Double> {
        DoubleResolve() {
        }
    }

    static class MedResolve<T extends Number>
    extends Resolve<Boolean, T> {
        MedResolve() {
        }
    }

    static class IntegerResolve
    extends Resolve<Boolean, Integer> {
        IntegerResolve() {
        }
    }

    static class Resolve<X, T extends Number> {
        public T t;
        public X x;

        Resolve() {
        }
    }

    static class WildcardBounds {
        public Collection<?> any;
        public Collection<? extends Number> upper;
        public Collection<? super Integer> lower;

        WildcardBounds() {
        }
    }

    static class IntegerList
    extends ArrayList<Integer> {
        IntegerList() {
        }
    }

    static class Foo {
        Foo() {
        }
    }
}

