/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.testing.util.MockBackOff;
import com.google.api.client.testing.util.MockSleeper;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;

public class HttpBackOffIOExpcetionHandlerTest
extends TestCase {
    public void testHandle() throws IOException {
        this.subsetHandle(0L, 0L, true, BackOff.STOP_BACKOFF);
        this.subsetHandle(0L, 0L, false, (BackOff)new MockBackOff().setBackOffMillis(0L).setMaxTries(5));
        this.subsetHandle(5L, 0L, true, (BackOff)new MockBackOff().setBackOffMillis(0L).setMaxTries(5));
        this.subsetHandle(7L, 10L, true, (BackOff)new MockBackOff().setBackOffMillis(10L).setMaxTries(7));
    }

    public void subsetHandle(long count, long millis, boolean retrySupported, BackOff backOff) throws IOException {
        MockSleeper sleeper = new MockSleeper();
        HttpBackOffIOExceptionHandler handler = new HttpBackOffIOExceptionHandler(backOff).setSleeper((Sleeper)sleeper);
        while (handler.handleIOException(null, retrySupported)) {
            HttpBackOffIOExpcetionHandlerTest.assertEquals((long)millis, (long)sleeper.getLastMillis());
        }
        HttpBackOffIOExpcetionHandlerTest.assertEquals((long)count, (long)sleeper.getCount());
    }

    public void testHandleIOException_returnsFalseAndThreadRemainsInterrupted_whenSleepIsInterrupted() throws Exception {
        final AtomicBoolean stillInterrupted = new AtomicBoolean(false);
        Thread runningThread = new Thread(){

            @Override
            public void run() {
                HttpBackOffIOExceptionHandler testTarget = new HttpBackOffIOExceptionHandler((BackOff)new MockBackOff().setBackOffMillis(Long.MAX_VALUE).setMaxTries(1)).setSleeper(Sleeper.DEFAULT);
                try {
                    testTarget.handleIOException(null, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stillInterrupted.set(Thread.currentThread().isInterrupted());
            }
        };
        runningThread.start();
        Thread.sleep(500L);
        runningThread.interrupt();
        runningThread.join();
        HttpBackOffIOExpcetionHandlerTest.assertTrue((boolean)stillInterrupted.get());
    }
}

