/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpMediaType;
import com.google.common.base.Charsets;
import com.google.common.testing.EqualsTester;
import junit.framework.TestCase;

public class HttpMediaTypeTest
extends TestCase {
    public void testBuild() {
        HttpMediaType m = new HttpMediaType("main", "sub");
        HttpMediaTypeTest.assertEquals((String)"main/sub", (String)m.build());
    }

    public void testBuild_star() {
        HttpMediaType m = new HttpMediaType("*", "*");
        HttpMediaTypeTest.assertEquals((String)"*/*", (String)m.build());
    }

    public void testBuild_parameters() {
        HttpMediaType m = new HttpMediaType("main", "sub");
        m.setParameter("bbb", ";/ ");
        m.setParameter("aaa", "1");
        HttpMediaTypeTest.assertEquals((String)"main/sub; aaa=1; bbb=\";/ \"", (String)m.build());
    }

    public void testBuild_json() {
        HttpMediaType m = new HttpMediaType("application/json").setCharsetParameter(Charsets.UTF_8);
        HttpMediaTypeTest.assertEquals((String)"application/json; charset=UTF-8", (String)m.build());
    }

    public void testBuild_multipartSpec() {
        HttpMediaType m = new HttpMediaType("main", "sub");
        m.setParameter("bbb", "foo=/bar");
        HttpMediaTypeTest.assertEquals((String)"main/sub; bbb=\"foo=/bar\"", (String)m.build());
    }

    public void testBuild_parametersCasing() {
        HttpMediaType m = new HttpMediaType("main", "sub");
        m.setParameter("foo", "FooBar");
        HttpMediaTypeTest.assertEquals((String)"main/sub; foo=FooBar", (String)m.build());
    }

    public void testFromString() {
        HttpMediaType m = new HttpMediaType("main/sub");
        HttpMediaTypeTest.assertEquals((String)"main", (String)m.getType());
        HttpMediaTypeTest.assertEquals((String)"sub", (String)m.getSubType());
    }

    public void testFromString_star() {
        HttpMediaType m = new HttpMediaType("text/*");
        HttpMediaTypeTest.assertEquals((String)"text", (String)m.getType());
        HttpMediaTypeTest.assertEquals((String)"*", (String)m.getSubType());
    }

    public void testFromString_null() {
        try {
            new HttpMediaType(null);
            HttpMediaTypeTest.fail((String)"Method did not NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFromString_multipartSpec() {
        String value = "f00'()+_,-./:=?bar";
        HttpMediaType m = new HttpMediaType("text/plain; boundary=" + value + "; foo=bar");
        HttpMediaTypeTest.assertEquals((String)value, (String)m.getParameter("boundary"));
        HttpMediaTypeTest.assertEquals((String)"bar", (String)m.getParameter("foo"));
    }

    public void testFromString_full() {
        HttpMediaType m = new HttpMediaType("text/plain; charset=utf-8; foo=\"foo; =bar\"");
        HttpMediaTypeTest.assertEquals((String)"text", (String)m.getType());
        HttpMediaTypeTest.assertEquals((String)"plain", (String)m.getSubType());
        HttpMediaTypeTest.assertEquals((String)"utf-8", (String)m.getParameter("charset"));
        HttpMediaTypeTest.assertEquals((String)"foo; =bar", (String)m.getParameter("foo"));
        HttpMediaTypeTest.assertEquals((int)2, (int)m.getParameters().size());
    }

    public void testFromString_case() {
        HttpMediaType m = new HttpMediaType("text/plain; Foo=Bar");
        HttpMediaTypeTest.assertEquals((String)"Bar", (String)m.getParameter("fOO"));
    }

    public void testSetMainType() {
        HttpMediaTypeTest.assertEquals((String)"foo", (String)new HttpMediaType("text", "plain").setType("foo").getType());
    }

    public void testSetMainType_invalid() {
        try {
            new HttpMediaType("text", "plain").setType("foo/bar");
            HttpMediaTypeTest.fail((String)"Method did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetSubType() {
        HttpMediaTypeTest.assertEquals((String)"foo", (String)new HttpMediaType("text", "plain").setSubType("foo").getSubType());
    }

    public void testSetSubType_invalid() {
        try {
            new HttpMediaType("text", "plain").setSubType("foo/bar");
            HttpMediaTypeTest.fail((String)"Method did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetParameter_casing() {
        HttpMediaType mt = new HttpMediaType("text", "plain");
        mt.setParameter("Foo", "Bar");
        HttpMediaTypeTest.assertEquals((String)"Bar", (String)mt.getParameter("FOO"));
    }

    private boolean containsInvalidChar(String str) {
        try {
            new HttpMediaType("text", "plain").setSubType(str);
            return false;
        }
        catch (IllegalArgumentException expected) {
            return true;
        }
    }

    private void assertFullSerialization(String str) {
        HttpMediaTypeTest.assertEquals((String)str, (String)new HttpMediaType(str).build());
    }

    public void testFullSerialization() {
        this.assertFullSerialization("text/plain");
        this.assertFullSerialization("text/plain; foo=bar");
        this.assertFullSerialization("text/plain; bar=bar; foo=foo");
        this.assertFullSerialization("text/plain; bar=\"Bar Bar\"; foo=Foo");
        this.assertFullSerialization("text/*");
        this.assertFullSerialization("*/*");
        this.assertFullSerialization("text/*; charset=utf-8; foo=\"bar bar bar\"");
    }

    public void testInvalidCharsRegex() {
        HttpMediaTypeTest.assertEquals((boolean)false, (boolean)this.containsInvalidChar("foo"));
        HttpMediaTypeTest.assertEquals((boolean)false, (boolean)this.containsInvalidChar("X-Foo-Bar"));
        HttpMediaTypeTest.assertEquals((boolean)true, (boolean)this.containsInvalidChar("foo/bar"));
        HttpMediaTypeTest.assertEquals((boolean)true, (boolean)this.containsInvalidChar("  foo"));
        HttpMediaTypeTest.assertEquals((boolean)true, (boolean)this.containsInvalidChar("foo;bar"));
    }

    public void testCharset() {
        HttpMediaType hmt = new HttpMediaType("foo/bar");
        HttpMediaTypeTest.assertEquals(null, (Object)hmt.getCharsetParameter());
        hmt.setCharsetParameter(Charsets.UTF_8);
        HttpMediaTypeTest.assertEquals((String)Charsets.UTF_8.name(), (String)hmt.getParameter("charset"));
        HttpMediaTypeTest.assertEquals((Object)Charsets.UTF_8, (Object)hmt.getCharsetParameter());
    }

    public void testEqualsIgnoreParameters() {
        HttpMediaTypeTest.assertEquals((boolean)true, (boolean)new HttpMediaType("foo/bar").equalsIgnoreParameters(new HttpMediaType("Foo/bar")));
        HttpMediaTypeTest.assertEquals((boolean)true, (boolean)new HttpMediaType("foo/bar").equalsIgnoreParameters(new HttpMediaType("foo/bar; charset=utf-8")));
        HttpMediaTypeTest.assertEquals((boolean)false, (boolean)new HttpMediaType("foo/bar").equalsIgnoreParameters(new HttpMediaType("bar/foo")));
        HttpMediaTypeTest.assertEquals((boolean)false, (boolean)new HttpMediaType("foo/bar").equalsIgnoreParameters(null));
    }

    public void testEqualsIgnoreParameters_static() {
        HttpMediaTypeTest.assertEquals((boolean)true, (boolean)HttpMediaType.equalsIgnoreParameters(null, null));
        HttpMediaTypeTest.assertEquals((boolean)false, (boolean)HttpMediaType.equalsIgnoreParameters(null, (String)"foo/bar"));
        HttpMediaTypeTest.assertEquals((boolean)true, (boolean)HttpMediaType.equalsIgnoreParameters((String)"foo/bar", (String)"foo/bar"));
        HttpMediaTypeTest.assertEquals((boolean)true, (boolean)HttpMediaType.equalsIgnoreParameters((String)"foo/bar; a=c", (String)"foo/bar; b=d"));
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{new HttpMediaType("foo/bar"), new HttpMediaType("foo/bar")}).addEqualityGroup(new Object[]{new HttpMediaType("foo/bar; a=c"), new HttpMediaType("foo/bar; a=c")}).addEqualityGroup(new Object[]{new HttpMediaType("foo/bar; bar=bar")}).testEquals();
    }
}

