/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.OpenCensusUtils;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import io.opencensus.common.Functions;
import io.opencensus.testing.export.TestHandler;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.config.TraceParams;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import io.opencensus.trace.samplers.Samplers;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpRequestTracingTest {
    private static final TestHandler testHandler = new TestHandler();

    @Before
    public void setupTestTracer() {
        Tracing.getExportComponent().getSpanExporter().registerHandler("test", (SpanExporter.Handler)testHandler);
        TraceParams params = Tracing.getTraceConfig().getActiveTraceParams().toBuilder().setSampler(Samplers.alwaysSample()).build();
        Tracing.getTraceConfig().updateActiveTraceParams(params);
    }

    @After
    public void teardownTestTracer() {
        Tracing.getExportComponent().getSpanExporter().unregisterHandler("test");
    }

    @Test(timeout=20000L)
    public void executeCreatesSpan() throws IOException {
        MockLowLevelHttpResponse mockResponse = new MockLowLevelHttpResponse().setStatusCode(200);
        MockHttpTransport transport = new MockHttpTransport.Builder().setLowLevelHttpResponse(mockResponse).build();
        HttpRequest request = new HttpRequestFactory((HttpTransport)transport, null).buildGetRequest(new GenericUrl("https://google.com/"));
        request.execute();
        List spans = testHandler.waitForExport(1);
        Assert.assertEquals((long)1L, (long)spans.size());
        SpanData span = (SpanData)spans.get(0);
        Assert.assertEquals((Object)OpenCensusUtils.SPAN_NAME_HTTP_REQUEST_EXECUTE, (Object)span.getName());
        this.assertAttributeEquals(span, "http.path", "/");
        this.assertAttributeEquals(span, "http.host", "google.com");
        this.assertAttributeEquals(span, "http.url", "https://google.com/");
        this.assertAttributeEquals(span, "http.method", "GET");
        this.assertAttributeEquals(span, "http.status_code", "200");
        Assert.assertEquals((long)1L, (long)span.getAnnotations().getEvents().size());
        Assert.assertEquals((long)2L, (long)span.getMessageEvents().getEvents().size());
        Assert.assertEquals((Object)MessageEvent.Type.SENT, (Object)((MessageEvent)((SpanData.TimedEvent)span.getMessageEvents().getEvents().get(0)).getEvent()).getType());
        Assert.assertEquals((Object)MessageEvent.Type.RECEIVED, (Object)((MessageEvent)((SpanData.TimedEvent)span.getMessageEvents().getEvents().get(1)).getEvent()).getType());
        Assert.assertEquals((Object)Status.OK, (Object)span.getStatus());
    }

    @Test(timeout=20000L)
    public void executeExceptionCreatesSpan() throws IOException {
        MockHttpTransport transport = new MockHttpTransport.Builder().setLowLevelHttpRequest(new MockLowLevelHttpRequest(){

            public LowLevelHttpResponse execute() throws IOException {
                throw new IOException("some IOException");
            }
        }).build();
        HttpRequest request = new HttpRequestFactory((HttpTransport)transport, null).buildGetRequest(new GenericUrl("https://google.com/"));
        try {
            request.execute();
            Assert.fail((String)"expected to throw an IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        List spans = testHandler.waitForExport(1);
        Assert.assertEquals((long)1L, (long)spans.size());
        SpanData span = (SpanData)spans.get(0);
        Assert.assertEquals((Object)OpenCensusUtils.SPAN_NAME_HTTP_REQUEST_EXECUTE, (Object)span.getName());
        this.assertAttributeEquals(span, "http.path", "/");
        this.assertAttributeEquals(span, "http.host", "google.com");
        this.assertAttributeEquals(span, "http.url", "https://google.com/");
        this.assertAttributeEquals(span, "http.method", "GET");
        Assert.assertEquals((long)1L, (long)span.getAnnotations().getEvents().size());
        Assert.assertEquals((long)1L, (long)span.getMessageEvents().getEvents().size());
        Assert.assertEquals((Object)MessageEvent.Type.SENT, (Object)((MessageEvent)((SpanData.TimedEvent)span.getMessageEvents().getEvents().get(0)).getEvent()).getType());
        Assert.assertEquals((Object)Status.UNKNOWN, (Object)span.getStatus());
    }

    void assertAttributeEquals(SpanData span, String attributeName, String expectedValue) {
        Object attributeValue = span.getAttributes().getAttributeMap().get(attributeName);
        Assert.assertNotNull((String)("expected span to contain attribute: " + attributeName), attributeValue);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValue));
        String value = (String)((AttributeValue)attributeValue).match(Functions.returnToString(), Functions.returnToString(), Functions.returnToString(), Functions.returnToString(), Functions.returnNull());
        Assert.assertEquals((Object)expectedValue, (Object)value);
    }
}

