/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.StringUtils;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.function.ThrowingRunnable;

public class HttpResponseExceptionTest
extends TestCase {
    public void testConstructor() throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpHeaders headers = response.getHeaders();
        HttpResponseException responseException = new HttpResponseException(response);
        Truth.assertThat((Throwable)responseException).hasMessageThat().isEqualTo((Object)("200\nGET " + HttpTesting.SIMPLE_GENERIC_URL));
        HttpResponseExceptionTest.assertNull((Object)responseException.getContent());
        HttpResponseExceptionTest.assertEquals((int)200, (int)responseException.getStatusCode());
        HttpResponseExceptionTest.assertNull((Object)responseException.getStatusMessage());
        HttpResponseExceptionTest.assertTrue((headers == responseException.getHeaders() ? 1 : 0) != 0);
    }

    public void testBuilder() throws Exception {
        HttpHeaders headers = new HttpHeaders();
        HttpResponseException.Builder builder = new HttpResponseException.Builder(9, "statusMessage", headers).setMessage("message").setContent("content");
        HttpResponseExceptionTest.assertEquals((String)"message", (String)builder.getMessage());
        HttpResponseExceptionTest.assertEquals((String)"content", (String)builder.getContent());
        HttpResponseExceptionTest.assertEquals((int)9, (int)builder.getStatusCode());
        HttpResponseExceptionTest.assertEquals((String)"statusMessage", (String)builder.getStatusMessage());
        HttpResponseExceptionTest.assertTrue((headers == builder.getHeaders() ? 1 : 0) != 0);
        HttpResponseException e = builder.build();
        HttpResponseExceptionTest.assertEquals((String)"message", (String)e.getMessage());
        HttpResponseExceptionTest.assertEquals((String)"content", (String)e.getContent());
        HttpResponseExceptionTest.assertEquals((int)9, (int)e.getStatusCode());
        HttpResponseExceptionTest.assertEquals((String)"statusMessage", (String)e.getStatusMessage());
        HttpResponseExceptionTest.assertTrue((headers == e.getHeaders() ? 1 : 0) != 0);
    }

    public void testConstructorWithStatusMessage() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setReasonPhrase("OK");
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseException responseException = new HttpResponseException(response);
        HttpResponseExceptionTest.assertEquals((String)"OK", (String)responseException.getStatusMessage());
    }

    public void testConstructor_noStatusCode() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(0);
                        return result;
                    }
                };
            }
        };
        final HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponseException responseException = (HttpResponseException)Assert.assertThrows(HttpResponseException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                request.execute();
            }
        });
        Truth.assertThat((Throwable)responseException).hasMessageThat().isEqualTo((Object)("GET " + HttpTesting.SIMPLE_GENERIC_URL));
    }

    public void testConstructor_messageButNoStatusCode() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(0);
                        result.setReasonPhrase("Foo");
                        return result;
                    }
                };
            }
        };
        final HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponseException responseException = (HttpResponseException)Assert.assertThrows(HttpResponseException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                request.execute();
            }
        });
        Truth.assertThat((Throwable)responseException).hasMessageThat().isEqualTo((Object)("Foo\nGET " + HttpTesting.SIMPLE_GENERIC_URL));
    }

    public void testComputeMessage() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setReasonPhrase("Foo");
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        Truth.assertThat((String)HttpResponseException.computeMessageBuffer((HttpResponse)response).toString()).isEqualTo((Object)("200 Foo\nGET " + HttpTesting.SIMPLE_GENERIC_URL));
    }

    public void testThrown() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(404);
                        result.setReasonPhrase("Not Found");
                        result.setContent("Unable to find resource");
                        return result;
                    }
                };
            }
        };
        final HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponseException responseException = (HttpResponseException)Assert.assertThrows(HttpResponseException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                request.execute();
            }
        });
        Truth.assertThat((Throwable)responseException).hasMessageThat().isEqualTo((Object)("404 Not Found\nGET " + HttpTesting.SIMPLE_GENERIC_URL + StringUtils.LINE_SEPARATOR + "Unable to find resource"));
        HttpResponseExceptionTest.assertEquals((int)1, (int)responseException.getAttemptCount());
    }

    public void testInvalidCharset() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(404);
                        result.setReasonPhrase("Not Found");
                        result.setContentType("text/plain; charset=");
                        result.setContent("Unable to find resource");
                        return result;
                    }
                };
            }
        };
        final HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponseException responseException = (HttpResponseException)Assert.assertThrows(HttpResponseException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                request.execute();
            }
        });
        Truth.assertThat((Throwable)responseException).hasMessageThat().isEqualTo((Object)("404 Not Found\nGET " + HttpTesting.SIMPLE_GENERIC_URL));
    }

    public void testAttemptCountWithBackOff() throws Exception {
        MockHttpTransport fakeTransport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(500);
                        result.setReasonPhrase("Error");
                        result.setContent("Unknown Error");
                        return result;
                    }
                };
            }
        };
        ExponentialBackOff backoff = new ExponentialBackOff.Builder().build();
        final HttpRequest request = fakeTransport.createRequestFactory().buildGetRequest(new GenericUrl("http://not/used"));
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new HttpBackOffUnsuccessfulResponseHandler((BackOff)backoff).setBackOffRequired(new HttpBackOffUnsuccessfulResponseHandler.BackOffRequired(){

            public boolean isRequired(HttpResponse response) {
                return true;
            }
        }));
        request.setNumberOfRetries(1);
        HttpResponseException responseException = (HttpResponseException)Assert.assertThrows(HttpResponseException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                request.execute();
            }
        });
        Assert.assertEquals((long)500L, (long)responseException.getStatusCode());
        HttpResponseExceptionTest.assertEquals((int)2, (int)responseException.getAttemptCount());
    }

    public void testUnsupportedCharset() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(404);
                        result.setReasonPhrase("Not Found");
                        result.setContentType("text/plain; charset=invalid-charset");
                        result.setContent("Unable to find resource");
                        return result;
                    }
                };
            }
        };
        final HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponseException responseException = (HttpResponseException)Assert.assertThrows(HttpResponseException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                request.execute();
            }
        });
        Truth.assertThat((Throwable)responseException).hasMessageThat().isEqualTo((Object)("404 Not Found\nGET " + HttpTesting.SIMPLE_GENERIC_URL));
    }

    public void testSerialization() throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseException responseException = new HttpResponseException(response);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream s = new ObjectOutputStream(out);
        s.writeObject(responseException);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(in);
        HttpResponseException e2 = (HttpResponseException)objectInput.readObject();
        HttpResponseExceptionTest.assertEquals((String)responseException.getMessage(), (String)e2.getMessage());
        HttpResponseExceptionTest.assertEquals((int)responseException.getStatusCode(), (int)e2.getStatusCode());
        HttpResponseExceptionTest.assertNull((Object)e2.getHeaders());
    }
}

