/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.OpenCensusUtils;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Link;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.propagation.TextFormat;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class OpenCensusUtilsTest
extends TestCase {
    TextFormat mockTextFormat;
    TextFormat.Setter mockTextFormatSetter;
    TextFormat originTextFormat;
    TextFormat.Setter originTextFormatSetter;
    Span mockSpan;
    HttpHeaders headers;
    Tracer tracer;

    public OpenCensusUtilsTest(String testName) {
        super(testName);
    }

    public void setUp() {
        this.mockTextFormat = new TextFormat(){

            public List<String> fields() {
                throw new UnsupportedOperationException("TextFormat.fields");
            }

            public <C> void inject(SpanContext spanContext, C carrier, TextFormat.Setter<C> setter) {
                throw new UnsupportedOperationException("TextFormat.inject");
            }

            public <C> SpanContext extract(C carrier, TextFormat.Getter<C> getter) {
                throw new UnsupportedOperationException("TextFormat.extract");
            }
        };
        this.mockTextFormatSetter = new TextFormat.Setter<HttpHeaders>(){

            public void put(HttpHeaders carrier, String key, String value) {
                throw new UnsupportedOperationException("TextFormat.Setter.put");
            }
        };
        this.headers = new HttpHeaders();
        this.tracer = OpenCensusUtils.getTracer();
        this.mockSpan = new Span(this.tracer.getCurrentSpan().getContext(), null){

            public void addAnnotation(String description, Map<String, AttributeValue> attributes) {
            }

            public void addAnnotation(Annotation annotation) {
            }

            public void addMessageEvent(MessageEvent event) {
                throw new UnsupportedOperationException("Span.addMessageEvent");
            }

            public void addLink(Link link) {
            }

            public void end(EndSpanOptions options) {
            }
        };
        this.originTextFormat = OpenCensusUtils.propagationTextFormat;
        this.originTextFormatSetter = OpenCensusUtils.propagationTextFormatSetter;
    }

    public void tearDown() {
        OpenCensusUtils.setPropagationTextFormat((TextFormat)this.originTextFormat);
        OpenCensusUtils.setPropagationTextFormatSetter((TextFormat.Setter)this.originTextFormatSetter);
    }

    public void testInitializatoin() {
        OpenCensusUtilsTest.assertNotNull((Object)OpenCensusUtils.getTracer());
        OpenCensusUtilsTest.assertNotNull((Object)OpenCensusUtils.propagationTextFormat);
        OpenCensusUtilsTest.assertNotNull((Object)OpenCensusUtils.propagationTextFormatSetter);
    }

    public void testSetPropagationTextFormat() {
        OpenCensusUtils.setPropagationTextFormat((TextFormat)this.mockTextFormat);
        OpenCensusUtilsTest.assertEquals((Object)this.mockTextFormat, (Object)OpenCensusUtils.propagationTextFormat);
    }

    public void testSetPropagationTextFormatSetter() {
        OpenCensusUtils.setPropagationTextFormatSetter((TextFormat.Setter)this.mockTextFormatSetter);
        OpenCensusUtilsTest.assertEquals((Object)this.mockTextFormatSetter, (Object)OpenCensusUtils.propagationTextFormatSetter);
    }

    public void testPropagateTracingContextInjection() {
        OpenCensusUtils.setPropagationTextFormat((TextFormat)this.mockTextFormat);
        try {
            OpenCensusUtils.propagateTracingContext((Span)this.mockSpan, (HttpHeaders)this.headers);
            OpenCensusUtilsTest.fail((String)("expected " + UnsupportedOperationException.class));
        }
        catch (UnsupportedOperationException e) {
            OpenCensusUtilsTest.assertEquals((String)e.getMessage(), (String)"TextFormat.inject");
        }
    }

    public void testPropagateTracingContextHeader() {
        OpenCensusUtils.setPropagationTextFormatSetter((TextFormat.Setter)this.mockTextFormatSetter);
        try {
            OpenCensusUtils.propagateTracingContext((Span)this.mockSpan, (HttpHeaders)this.headers);
            OpenCensusUtilsTest.fail((String)("expected " + UnsupportedOperationException.class));
        }
        catch (UnsupportedOperationException e) {
            OpenCensusUtilsTest.assertEquals((String)e.getMessage(), (String)"TextFormat.Setter.put");
        }
    }

    public void testPropagateTracingContextNullSpan() {
        OpenCensusUtils.setPropagationTextFormat((TextFormat)this.mockTextFormat);
        try {
            OpenCensusUtils.propagateTracingContext(null, (HttpHeaders)this.headers);
            OpenCensusUtilsTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException e) {
            OpenCensusUtilsTest.assertEquals((String)e.getMessage(), (String)"span should not be null.");
        }
    }

    public void testPropagateTracingContextNullHeaders() {
        OpenCensusUtils.setPropagationTextFormat((TextFormat)this.mockTextFormat);
        try {
            OpenCensusUtils.propagateTracingContext((Span)this.mockSpan, null);
            OpenCensusUtilsTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException e) {
            OpenCensusUtilsTest.assertEquals((String)e.getMessage(), (String)"headers should not be null.");
        }
    }

    public void testPropagateTracingContextInvalidSpan() {
        OpenCensusUtils.setPropagationTextFormat((TextFormat)this.mockTextFormat);
        OpenCensusUtils.propagateTracingContext((Span)BlankSpan.INSTANCE, (HttpHeaders)this.headers);
    }

    public void testGetEndSpanOptionsNoResponse() {
        EndSpanOptions expected = EndSpanOptions.builder().setStatus(Status.UNKNOWN).build();
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions(null));
    }

    public void testGetEndSpanOptionsSuccess() {
        EndSpanOptions expected = EndSpanOptions.builder().setStatus(Status.OK).build();
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)200));
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)201));
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)202));
    }

    public void testGetEndSpanOptionsBadRequest() {
        EndSpanOptions expected = EndSpanOptions.builder().setStatus(Status.INVALID_ARGUMENT).build();
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)400));
    }

    public void testGetEndSpanOptionsUnauthorized() {
        EndSpanOptions expected = EndSpanOptions.builder().setStatus(Status.UNAUTHENTICATED).build();
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)401));
    }

    public void testGetEndSpanOptionsForbidden() {
        EndSpanOptions expected = EndSpanOptions.builder().setStatus(Status.PERMISSION_DENIED).build();
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)403));
    }

    public void testGetEndSpanOptionsNotFound() {
        EndSpanOptions expected = EndSpanOptions.builder().setStatus(Status.NOT_FOUND).build();
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)404));
    }

    public void testGetEndSpanOptionsPreconditionFailed() {
        EndSpanOptions expected = EndSpanOptions.builder().setStatus(Status.FAILED_PRECONDITION).build();
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)412));
    }

    public void testGetEndSpanOptionsServerError() {
        EndSpanOptions expected = EndSpanOptions.builder().setStatus(Status.UNAVAILABLE).build();
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)500));
    }

    public void testGetEndSpanOptionsOther() {
        EndSpanOptions expected = EndSpanOptions.builder().setStatus(Status.UNKNOWN).build();
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)301));
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)402));
        OpenCensusUtilsTest.assertEquals((Object)expected, (Object)OpenCensusUtils.getEndSpanOptions((Integer)501));
    }

    public void testRecordMessageEventInNullSpan() {
        try {
            OpenCensusUtils.recordMessageEvent(null, (long)0L, (MessageEvent.Type)MessageEvent.Type.SENT);
            OpenCensusUtilsTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException e) {
            OpenCensusUtilsTest.assertEquals((String)e.getMessage(), (String)"span should not be null.");
        }
    }

    public void testRecordMessageEvent() {
        try {
            OpenCensusUtils.recordMessageEvent((Span)this.mockSpan, (long)0L, (MessageEvent.Type)MessageEvent.Type.SENT);
            OpenCensusUtilsTest.fail((String)("expected " + UnsupportedOperationException.class));
        }
        catch (UnsupportedOperationException e) {
            OpenCensusUtilsTest.assertEquals((String)e.getMessage(), (String)"Span.addMessageEvent");
        }
    }
}

