/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.UriTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.TestCase;

public class UriTemplateTest
extends TestCase {
    private static final String[][] LIST_TESTS = new String[][]{{"{d}", "red,green,blue"}, {"{d*}", "red,green,blue"}, {"{+d}", "red,green,blue"}, {"{+d*}", "red,green,blue"}, {"{#d}", "#red,green,blue"}, {"{#d*}", "#red,green,blue"}, {"X{.d}", "X.red,green,blue"}, {"X{.d*}", "X.red.green.blue"}, {"{/d}", "/red,green,blue"}, {"{/d*}", "/red/green/blue"}, {"{;d}", ";d=red,green,blue"}, {"{;d*}", ";d=red;d=green;d=blue"}, {"{?d}", "?d=red,green,blue"}, {"{?d*}", "?d=red&d=green&d=blue"}, {"{&d}", "&d=red,green,blue"}, {"{&d*}", "&d=red&d=green&d=blue"}};
    private static final String[][] MAP_TESTS = new String[][]{{"{d}", "semi,%3B,dot,.,comma,%2C"}, {"{d*}", "semi=%3B,dot=.,comma=%2C"}, {"{+d}", "semi,;,dot,.,comma,,"}, {"{+d*}", "semi=;,dot=.,comma=,"}, {"{#d}", "#semi,;,dot,.,comma,,"}, {"{#d*}", "#semi=;,dot=.,comma=,"}, {"X{.d}", "X.semi,%3B,dot,.,comma,%2C"}, {"X{.d*}", "X.semi=%3B.dot=..comma=%2C"}, {"{/d}", "/semi,%3B,dot,.,comma,%2C"}, {"{/d*}", "/semi=%3B/dot=./comma=%2C"}, {"{;d}", ";d=semi,%3B,dot,.,comma,%2C"}, {"{;d*}", ";semi=%3B;dot=.;comma=%2C"}, {"{?d}", "?d=semi,%3B,dot,.,comma,%2C"}, {"{?d*}", "?semi=%3B&dot=.&comma=%2C"}, {"{&d}", "&d=semi,%3B,dot,.,comma,%2C"}, {"{&d*}", "&semi=%3B&dot=.&comma=%2C"}};

    public void testExpandTemplates_initialization() {
        TreeMap map = Maps.newTreeMap();
        map.put("id", Arrays.asList("a", "b", "c"));
        UriTemplateTest.assertEquals((String)"/a/b/c", (String)UriTemplate.expand((String)"{/id*}", (Object)map, (boolean)false));
        UriTemplateTest.assertEquals((String)"/a/b/c", (String)UriTemplate.expand((String)"{/id*}", (Object)map, (boolean)false));
    }

    public void testExpandTemplates_basic() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("abc", "xyz");
        requestMap.put("def", "123");
        requestMap.put("unused", "unused parameter");
        UriTemplateTest.assertEquals((String)"foo/xyz/bar/123", (String)UriTemplate.expand((String)"foo/{abc}/bar/{def}", (Object)requestMap, (boolean)false));
        UriTemplateTest.assertEquals((String)"foo/xyz/bar/123?unused=unused%20parameter", (String)UriTemplate.expand((String)"foo/{abc}/bar/{def}", (Object)requestMap, (boolean)true));
        UriTemplateTest.assertEquals((int)3, (int)requestMap.size());
        UriTemplateTest.assertTrue((boolean)requestMap.containsKey("abc"));
        UriTemplateTest.assertTrue((boolean)requestMap.containsKey("def"));
        UriTemplateTest.assertTrue((boolean)requestMap.containsKey("unused"));
    }

    public void testExpandTemplates_basicEncodeValue() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("abc", "xyz;def");
        UriTemplateTest.assertEquals((String)";abc=xyz%3Bdef", (String)UriTemplate.expand((String)"{;abc}", (Object)requestMap, (boolean)false));
        UriTemplateTest.assertEquals((String)"xyz;def", (String)UriTemplate.expand((String)"{+abc}", (Object)requestMap, (boolean)false));
    }

    public void testExpandTemplates_encodeSpace() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("abc", "xyz def");
        UriTemplateTest.assertEquals((String)";abc=xyz%20def", (String)UriTemplate.expand((String)"{;abc}", (Object)requestMap, (boolean)false));
    }

    public void testExpandTemplates_noExpansionsWithQueryParams() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("abc", "xyz");
        requestMap.put("def", "123");
        UriTemplateTest.assertEquals((String)"foo/xyz/bar/123?abc=xyz&def=123", (String)UriTemplate.expand((String)"foo/xyz/bar/123", (Object)requestMap, (boolean)true));
    }

    public void testExpandTemplates_noExpansionsWithoutQueryParams() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("abc", "xyz");
        requestMap.put("def", "123");
        UriTemplateTest.assertEquals((String)"foo/xyz/bar/123", (String)UriTemplate.expand((String)"foo/xyz/bar/123", (Object)requestMap, (boolean)false));
    }

    public void testExpandTemplates_missingParameter() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("abc", "xyz");
        UriTemplateTest.assertEquals((String)"foo/xyz/bar/", (String)UriTemplate.expand((String)"foo/{abc}/bar/{def}", (Object)requestMap, (boolean)true));
    }

    public void testExpandTemplates_nullValue() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("abc", "xyz");
        requestMap.put("def", null);
        UriTemplateTest.assertEquals((String)"foo/xyz/bar/", (String)UriTemplate.expand((String)"foo/{abc}/bar/{def}", (Object)requestMap, (boolean)true));
    }

    public void testExpandTemplates_emptyAndNullRequestMap() {
        TreeMap requestMap = Maps.newTreeMap();
        UriTemplateTest.assertEquals((String)"foo//bar/", (String)UriTemplate.expand((String)"foo/{abc}/bar/{def}", (Object)requestMap, (boolean)true));
        UriTemplateTest.assertEquals((String)"foo//bar/", (String)UriTemplate.expand((String)"foo/{abc}/bar/{def}", null, (boolean)true));
    }

    private Iterable<String> getListIterable() {
        return Arrays.asList("red", "green", "blue");
    }

    public void testExpandTemplates_explodeIterator() {
        for (String[] test : LIST_TESTS) {
            TreeMap requestMap = Maps.newTreeMap();
            requestMap.put("d", this.getListIterable().iterator());
            UriTemplateTest.assertEquals((String)test[1], (String)UriTemplate.expand((String)test[0], (Object)requestMap, (boolean)true));
        }
    }

    public void testExpandTemplates_explodeIterable() {
        for (String[] test : LIST_TESTS) {
            TreeMap requestMap = Maps.newTreeMap();
            requestMap.put("d", this.getListIterable());
            UriTemplateTest.assertEquals((String)test[1], (String)UriTemplate.expand((String)test[0], (Object)requestMap, (boolean)true));
        }
    }

    public void testExpandTemplates_explodeEnum() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("d", testEnum.ONE);
        UriTemplateTest.assertEquals((String)testEnum.ONE.toString(), (String)UriTemplate.expand((String)"{d}", (Object)requestMap, (boolean)true));
    }

    public void testExpandTemplates_missingCompositeParameter() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("abc", "xyz");
        UriTemplateTest.assertEquals((String)"", (String)UriTemplate.expand((String)"{d}", (Object)requestMap, (boolean)false));
        UriTemplateTest.assertEquals((String)"?abc=xyz", (String)UriTemplate.expand((String)"{d}", (Object)requestMap, (boolean)true));
    }

    public void testExpandTemplates_emptyListParameter() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("d", Lists.newArrayList());
        UriTemplateTest.assertEquals((String)"", (String)UriTemplate.expand((String)"{d}", (Object)requestMap, (boolean)true));
    }

    private Map<String, String> getMapParams() {
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put("semi", ";");
        params.put("dot", ".");
        params.put("comma", ",");
        return params;
    }

    public void testExpandTemplates_explodeMap() {
        for (String[] test : MAP_TESTS) {
            TreeMap requestMap = Maps.newTreeMap();
            requestMap.put("d", this.getMapParams());
            UriTemplateTest.assertEquals((String)test[1], (String)UriTemplate.expand((String)test[0], (Object)requestMap, (boolean)true));
        }
    }

    public void testExpandTemplates_emptyMapParameter() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("d", Maps.newTreeMap());
        UriTemplateTest.assertEquals((String)"", (String)UriTemplate.expand((String)"{d}", (Object)requestMap, (boolean)true));
    }

    public void testExpandTemplates_unusedQueryParametersEncoding() {
        LinkedHashMap requestMap = Maps.newLinkedHashMap();
        requestMap.put("unused1", "abc!1234?");
        requestMap.put("unused2", "56$7 8");
        requestMap.put("unused3", "9=&/:@.");
        UriTemplateTest.assertEquals((String)"?unused1=abc!1234?&unused2=56$7%208&unused3=9%3D%26/:@.", (String)UriTemplate.expand((String)"", (Object)requestMap, (boolean)true));
    }

    public void testExpandTemplates_unusedListQueryParameters() {
        LinkedHashMap requestMap = Maps.newLinkedHashMap();
        ArrayList params = Lists.newArrayList();
        params.add("value1");
        params.add("value2");
        requestMap.put("unused1", params);
        requestMap.put("unused2", "56$7 8");
        requestMap.put("unused3", "9=&/:@.");
        UriTemplateTest.assertEquals((String)"?unused1=value1&unused1=value2&unused2=56$7%208&unused3=9%3D%26/:@.", (String)UriTemplate.expand((String)"", (Object)requestMap, (boolean)true));
    }

    public void testExpandTemplates_mixedBagParameters() {
        LinkedHashMap requestMap = Maps.newLinkedHashMap();
        requestMap.put("iterator", this.getListIterable().iterator());
        requestMap.put("iterable", this.getListIterable());
        requestMap.put("map", this.getMapParams());
        requestMap.put("enum", testEnum.ONE);
        requestMap.put("abc", "xyz");
        requestMap.put("unused1", "unused param");
        requestMap.put("unused2", "unused=param");
        UriTemplateTest.assertEquals((String)"foo/xyz/red/green/blue&iterable=red&iterable=green&iterable=blue&map=semi,%3B,dot,.,comma,%2C&enum=ONE?unused1=unused%20param&unused2=unused%3Dparam", (String)UriTemplate.expand((String)"foo/{abc}{/iterator*}{&iterable*}{&map}{&enum}", (Object)requestMap, (boolean)true));
        UriTemplateTest.assertEquals((int)7, (int)requestMap.size());
        UriTemplateTest.assertTrue((boolean)requestMap.containsKey("iterator"));
        UriTemplateTest.assertTrue((boolean)requestMap.containsKey("iterable"));
        UriTemplateTest.assertTrue((boolean)requestMap.containsKey("map"));
        UriTemplateTest.assertTrue((boolean)requestMap.containsKey("abc"));
        UriTemplateTest.assertTrue((boolean)requestMap.containsKey("unused1"));
        UriTemplateTest.assertTrue((boolean)requestMap.containsKey("unused2"));
    }

    public void testExpandTemplates_withBaseUrl() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("abc", "xyz");
        requestMap.put("def", "123");
        UriTemplateTest.assertEquals((String)"https://test/base/path/xyz/123/bar/", (String)UriTemplate.expand((String)"https://test/base/path/", (String)"{abc}/{def}/bar/", (Object)requestMap, (boolean)true));
        UriTemplateTest.assertEquals((String)"https://test/xyz/123/bar/", (String)UriTemplate.expand((String)"https://test/base/path/", (String)"/{abc}/{def}/bar/", (Object)requestMap, (boolean)true));
        UriTemplateTest.assertEquals((String)"http://test3/xyz/123/bar/", (String)UriTemplate.expand((String)"https://test/base/path/", (String)"http://test3/{abc}/{def}/bar/", (Object)requestMap, (boolean)true));
    }

    public void testExpandNonReservedNonComposite() {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("abc", "xyz");
        requestMap.put("def", "a/b?c");
        UriTemplateTest.assertEquals((String)"foo/xyz/bar/a%2Fb%3Fc", (String)UriTemplate.expand((String)"foo/{abc}/bar/{def}", (Object)requestMap, (boolean)false));
        UriTemplateTest.assertEquals((String)"foo/xyz/bar/a/b?c", (String)UriTemplate.expand((String)"foo/{abc}/bar/{+def}", (Object)requestMap, (boolean)false));
    }

    public void testExpandSeveralTemplates() {
        TreeMap map = Maps.newTreeMap();
        map.put("id", "a");
        map.put("uid", "b");
        UriTemplateTest.assertEquals((String)"?id=a&uid=b", (String)UriTemplate.expand((String)"{?id,uid}", (Object)map, (boolean)false));
    }

    public void testExpandSeveralTemplatesUnusedParameterInMiddle() {
        TreeMap map = Maps.newTreeMap();
        map.put("id", "a");
        map.put("uid", "b");
        UriTemplateTest.assertEquals((String)"?id=a&uid=b", (String)UriTemplate.expand((String)"{?id,foo,bar,uid}", (Object)map, (boolean)false));
    }

    public void testExpandSeveralTemplatesFirstParameterUnused() {
        TreeMap map = Maps.newTreeMap();
        map.put("id", "a");
        map.put("uid", "b");
        UriTemplateTest.assertEquals((String)"?id=a&uid=b", (String)UriTemplate.expand((String)"{?foo,id,uid}", (Object)map, (boolean)false));
    }

    public void testExpandSeveralTemplatesNoParametersUsed() {
        TreeMap map = Maps.newTreeMap();
        UriTemplateTest.assertEquals((String)"", (String)UriTemplate.expand((String)"{?id,uid}", (Object)map, (boolean)false));
    }

    public void testExpandTemplates_reservedExpansion_mustNotEscapeReservedCharSet() {
        String reservedSet = ":/?#[]@!$&'()*+,;=";
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("var", reservedSet);
        UriTemplateTest.assertEquals((String)"Reserved expansion must not escape chars from reserved set according to rfc6570#section-3.2.3", (String)reservedSet, (String)UriTemplate.expand((String)"{+var}", (Object)requestMap, (boolean)false));
    }

    public void testExpandTemplates_reservedExpansion_mustNotEscapeUnreservedCharSet() {
        String unReservedSet = "-._~";
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("var", unReservedSet);
        UriTemplateTest.assertEquals((String)"Reserved expansion must not escape chars from unreserved set according to rfc6570#section-3.2.3", (String)unReservedSet, (String)UriTemplate.expand((String)"{+var}", (Object)requestMap, (boolean)false));
    }

    static enum testEnum {
        ONE;

    }
}

