/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.javanet.NetHttpRequest;
import com.google.api.client.testing.http.javanet.MockHttpURLConnection;
import com.google.api.client.util.StreamingContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;

public class NetHttpRequestTest {
    @Test
    public void testHangingWrite() throws InterruptedException {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    NetHttpRequestTest.postWithTimeout(0);
                }
                catch (IOException e) {
                    Assert.assertEquals(e.getCause().getClass(), InterruptedException.class);
                    return;
                }
                catch (Exception e) {
                    Assert.fail();
                }
                Assert.fail((String)"should be interrupted before here");
            }
        };
        thread.start();
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)thread.isAlive());
        thread.interrupt();
    }

    @Test(timeout=1000L)
    public void testOutputStreamWriteTimeout() throws Exception {
        try {
            NetHttpRequestTest.postWithTimeout(100);
            Assert.fail((String)"should have timed out");
        }
        catch (IOException e) {
            Assert.assertEquals(e.getCause().getClass(), TimeoutException.class);
        }
        catch (Exception e) {
            Assert.fail((String)("Expected an IOException not a " + e.getCause().getClass().getName()));
        }
    }

    private static void postWithTimeout(int timeout) throws Exception {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/"));
        connection.setRequestMethod("POST");
        NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
        InputStream is = NetHttpRequestTest.class.getClassLoader().getResourceAsStream("file.txt");
        InputStreamContent content = new InputStreamContent("text/plain", is);
        request.setStreamingContent((StreamingContent)content);
        request.setWriteTimeout(timeout);
        request.execute((NetHttpRequest.OutputWriter)new SleepingOutputWriter(5000L));
    }

    @Test
    public void testInterruptedWriteWithResponse() throws Exception {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/")){

            public OutputStream getOutputStream() throws IOException {
                return new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        throw new IOException("Error writing request body to server");
                    }
                };
            }
        };
        connection.setResponseCode(401);
        connection.setRequestMethod("POST");
        NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
        InputStream is = NetHttpRequestTest.class.getClassLoader().getResourceAsStream("file.txt");
        InputStreamContent content = new InputStreamContent("text/plain", is);
        request.setStreamingContent((StreamingContent)content);
        LowLevelHttpResponse response = request.execute();
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
    }

    @Test
    public void testInterruptedWriteWithoutResponse() throws Exception {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/")){

            public OutputStream getOutputStream() throws IOException {
                return new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        throw new IOException("Error writing request body to server");
                    }
                };
            }
        };
        connection.setRequestMethod("POST");
        NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
        InputStream is = NetHttpRequestTest.class.getClassLoader().getResourceAsStream("file.txt");
        InputStreamContent content = new InputStreamContent("text/plain", is);
        request.setStreamingContent((StreamingContent)content);
        try {
            request.execute();
            Assert.fail((String)"Expected to throw an IOException");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Error writing request body to server", (Object)e.getMessage());
        }
    }

    @Test
    public void testInterruptedWriteErrorOnResponse() throws Exception {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/")){

            public OutputStream getOutputStream() throws IOException {
                return new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        throw new IOException("Error writing request body to server");
                    }
                };
            }

            public int getResponseCode() throws IOException {
                throw new IOException("Error parsing response code");
            }
        };
        connection.setRequestMethod("POST");
        NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
        InputStream is = NetHttpRequestTest.class.getClassLoader().getResourceAsStream("file.txt");
        InputStreamContent content = new InputStreamContent("text/plain", is);
        request.setStreamingContent((StreamingContent)content);
        try {
            request.execute();
            Assert.fail((String)"Expected to throw an IOException");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Error writing request body to server", (Object)e.getMessage());
        }
    }

    @Test
    public void testErrorOnClose() throws Exception {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/")){

            public OutputStream getOutputStream() throws IOException {
                return new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                    }

                    @Override
                    public void close() throws IOException {
                        throw new IOException("Error during close");
                    }
                };
            }
        };
        connection.setRequestMethod("POST");
        NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
        InputStream is = NetHttpRequestTest.class.getClassLoader().getResourceAsStream("file.txt");
        InputStreamContent content = new InputStreamContent("text/plain", is);
        request.setStreamingContent((StreamingContent)content);
        try {
            request.execute();
            Assert.fail((String)"Expected to throw an IOException");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Error during close", (Object)e.getMessage());
        }
    }

    @Test
    public void testChunkedLengthSet() throws Exception {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/"));
        connection.setRequestMethod("POST");
        NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
        InputStream is = NetHttpRequestTest.class.getClassLoader().getResourceAsStream("file.txt");
        InputStreamContent content = new InputStreamContent("text/plain", is);
        request.setStreamingContent((StreamingContent)content);
        request.setContentEncoding("gzip");
        request.execute();
        Assert.assertEquals((long)4096L, (long)connection.getChunkLength());
        Assert.assertNull((Object)request.getRequestProperty("Content-Length"));
    }

    @Test
    public void testChunkedLengthNotSet() throws Exception {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/"));
        connection.setRequestMethod("POST");
        NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
        ByteArrayContent content = new ByteArrayContent("text/plain", "sample".getBytes(StandardCharsets.UTF_8));
        request.setStreamingContent((StreamingContent)content);
        request.setContentLength(content.getLength());
        request.execute();
        Assert.assertEquals((long)connection.getChunkLength(), (long)-1L);
        Assert.assertEquals((Object)"6", (Object)request.getRequestProperty("Content-Length"));
    }

    @Test
    public void testDeleteSetsContentLengthToZeroWithoutContent() throws Exception {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/"));
        connection.setRequestMethod("DELETE");
        NetHttpRequest request = new NetHttpRequest((HttpURLConnection)connection);
        request.execute();
        Assert.assertTrue((boolean)connection.doOutputCalled());
        Assert.assertTrue((boolean)connection.isSetFixedLengthStreamingModeLongCalled());
        Assert.assertFalse((boolean)connection.isSetFixedLengthStreamingModeIntCalled());
    }

    static class SleepingOutputWriter
    implements NetHttpRequest.OutputWriter {
        private long sleepTimeInMs;

        public SleepingOutputWriter(long sleepTimeInMs) {
            this.sleepTimeInMs = sleepTimeInMs;
        }

        public void write(OutputStream outputStream, StreamingContent content) throws IOException {
            try {
                Thread.sleep(this.sleepTimeInMs);
            }
            catch (InterruptedException e) {
                throw new IOException("sleep interrupted", e);
            }
        }
    }
}

