/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http.javanet;

import com.google.api.client.testing.http.javanet.MockHttpURLConnection;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class MockHttpUrlConnectionTest
extends TestCase {
    private static final String RESPONSE_BODY = "body";
    private static final String HEADER_NAME = "Custom-Header";

    public void testSetGetHeaders() throws IOException {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/"));
        connection.addHeader(HEADER_NAME, "100");
        MockHttpUrlConnectionTest.assertEquals((String)"100", (String)connection.getHeaderField(HEADER_NAME));
    }

    public void testSetGetMultipleHeaders() throws IOException {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/"));
        List<String> values = Arrays.asList("value1", "value2", "value3");
        for (String value : values) {
            connection.addHeader(HEADER_NAME, value);
        }
        Map headers = connection.getHeaderFields();
        MockHttpUrlConnectionTest.assertEquals((int)3, (int)((List)headers.get(HEADER_NAME)).size());
        for (int i = 0; i < 3; ++i) {
            MockHttpUrlConnectionTest.assertEquals((String)values.get(i), (String)((String)((List)headers.get(HEADER_NAME)).get(i)));
        }
    }

    public void testGetNonExistingHeader() throws IOException {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/"));
        MockHttpUrlConnectionTest.assertNull((Object)connection.getHeaderField(HEADER_NAME));
    }

    public void testSetInputStreamAndInputStreamImmutable() throws IOException {
        MockHttpURLConnection connection = new MockHttpURLConnection(new URL("http://google.com/"));
        connection.setInputStream((InputStream)new ByteArrayInputStream(StringUtils.getBytesUtf8((String)RESPONSE_BODY)));
        connection.setInputStream((InputStream)new ByteArrayInputStream(StringUtils.getBytesUtf8((String)"override")));
        byte[] buf = new byte[10];
        InputStream in = connection.getInputStream();
        int n = 0;
        int bytes = 0;
        while ((n = in.read(buf)) != -1) {
            bytes += n;
        }
        MockHttpUrlConnectionTest.assertEquals((String)RESPONSE_BODY, (String)new String(buf, 0, bytes));
    }
}

