/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.testing.util.MockBackOff;
import com.google.api.client.testing.util.MockSleeper;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import junit.framework.TestCase;

public class BackOffUtilsTest
extends TestCase {
    public void testNext() throws Exception {
        this.subtestNext(7L);
        this.subtestNext(0L);
        this.subtestNext(-1L);
    }

    public void subtestNext(long millis) throws Exception {
        MockSleeper sleeper = new MockSleeper();
        MockBackOff backOff = new MockBackOff().setBackOffMillis(millis);
        if (millis == -1L) {
            backOff.setMaxTries(0);
        }
        int retries = 0;
        while (retries <= backOff.getMaxTries() + 1) {
            boolean next = BackOffUtils.next((Sleeper)sleeper, (BackOff)backOff);
            BackOffUtilsTest.assertEquals((retries < backOff.getMaxTries() ? 1 : 0) != 0, (boolean)next);
            if (next) {
                ++retries;
            }
            BackOffUtilsTest.assertEquals((int)retries, (int)sleeper.getCount());
            BackOffUtilsTest.assertEquals((int)retries, (int)backOff.getNumberOfTries());
            if (!next) break;
            BackOffUtilsTest.assertEquals((long)millis, (long)sleeper.getLastMillis());
        }
    }
}

