/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Key;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import junit.framework.TestCase;

public class ClassInfoTest
extends TestCase {
    public void testIsEnum() {
        ClassInfoTest.assertTrue((boolean)ClassInfo.of(E.class).isEnum());
        ClassInfoTest.assertFalse((boolean)ClassInfo.of(String.class).isEnum());
    }

    public void testGetFieldInfo_enum() throws Exception {
        ClassInfo classInfo = ClassInfo.of(E.class);
        ClassInfoTest.assertEquals((Object)E.class.getField("NULL"), (Object)classInfo.getFieldInfo(null).getField());
        ClassInfoTest.assertEquals((Object)E.class.getField("OTHER_VALUE"), (Object)classInfo.getFieldInfo("other").getField());
        ClassInfoTest.assertEquals((Object)E.class.getField("VALUE"), (Object)classInfo.getFieldInfo("VALUE").getField());
    }

    public void testNames() {
        ClassInfoTest.assertEquals((Object)ImmutableList.of((Object)"AbC", (Object)"b", (Object)"oc"), (Object)ClassInfo.of(A.class).names);
        ClassInfoTest.assertEquals((Object)ImmutableList.of((Object)"AbC", (Object)"b", (Object)"e", (Object)"oc"), (Object)ClassInfo.of(B.class).names);
    }

    public void testNames_ignoreCase() {
        ClassInfoTest.assertEquals((Object)ImmutableList.of((Object)"abc", (Object)"b", (Object)"oc"), (Object)ClassInfo.of(A.class, (boolean)true).names);
        ClassInfoTest.assertEquals((Object)ImmutableList.of((Object)"abc", (Object)"b", (Object)"e", (Object)"oc"), (Object)ClassInfo.of(B.class, (boolean)true).names);
    }

    public void testNames_enum() {
        ClassInfo classInfo = ClassInfo.of(E.class);
        ClassInfoTest.assertEquals((Object)Lists.newArrayList(Arrays.asList(null, "VALUE", "other")), (Object)classInfo.names);
    }

    public void testOf() {
        try {
            ClassInfo.of(A1.class, (boolean)true);
            ClassInfoTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ClassInfo.of(C.class, (boolean)true);
        try {
            ClassInfo.of(E.class, (boolean)true);
            ClassInfoTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public class A1 {
        @Key
        String foo;
        @Key(value="foo")
        String foo2;
    }

    public class C
    extends B {
        @Key(value="aBc")
        String abc2;
    }

    public class B
    extends A {
        @Key
        String e;
    }

    public class A {
        @Key
        String b;
        @Key(value="oc")
        String c;
        String d;
        @Key(value="AbC")
        String abc;
    }

    public static enum E {
        VALUE,
        OTHER_VALUE,
        NULL,
        IGNORED_VALUE;

    }
}

