/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Types;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import junit.framework.TestCase;

public class DataTest
extends TestCase {
    public void testNullOf() {
        DataTest.assertEquals((String)"java.lang.Object", (String)Data.nullOf(Object.class).getClass().getName());
        DataTest.assertEquals((String)"java.lang.String", (String)((String)Data.nullOf(String.class)).getClass().getName());
        DataTest.assertEquals((String)"java.lang.Integer", (String)((Integer)Data.nullOf(Integer.class)).getClass().getName());
        DataTest.assertEquals((String)"[[[[Ljava.lang.String;", (String)((String[][][][])Data.nullOf(String[][][][].class)).getClass().getName());
        DataTest.assertEquals((String)"[[[I", (String)((int[][][])Data.nullOf(int[][][].class)).getClass().getName());
        DataTest.assertNotNull((Object)Data.nullOf(Object.class));
        DataTest.assertEquals((Object)Data.nullOf(Object.class), (Object)Data.nullOf(Object.class));
        DataTest.assertFalse((boolean)((String)Data.nullOf(String.class)).equals(Data.nullOf(Object.class)));
        try {
            Data.nullOf(Integer.TYPE);
            DataTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Data.nullOf(List.class);
            DataTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullOfTemplateTypes() {
        String nullValue = (String)Data.nullOf(String.class);
        ImmutableMap nullField = ImmutableMap.of((Object)"v", (Object)nullValue);
        DataTest.assertEquals((String)nullValue, (String)((String)nullField.get("v")));
    }

    public void testIsNull() {
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_BOOLEAN));
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_STRING));
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_CHARACTER));
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_BYTE));
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_SHORT));
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_INTEGER));
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_LONG));
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_FLOAT));
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_DOUBLE));
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_BIG_INTEGER));
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_BIG_DECIMAL));
        DataTest.assertTrue((boolean)Data.isNull((Object)Data.NULL_DATE_TIME));
        DataTest.assertFalse((boolean)Data.isNull(null));
        DataTest.assertFalse((boolean)Data.isNull((Object)""));
        DataTest.assertFalse((boolean)Data.isNull((Object)false));
        DataTest.assertFalse((boolean)Data.isNull((Object)true));
        DataTest.assertFalse((boolean)Data.isNull((Object)0));
        DataTest.assertFalse((boolean)Data.isNull((Object)0));
        DataTest.assertFalse((boolean)Data.isNull((Object)0));
        DataTest.assertFalse((boolean)Data.isNull((Object)0L));
        DataTest.assertFalse((boolean)Data.isNull((Object)Float.valueOf(0.0f)));
        DataTest.assertFalse((boolean)Data.isNull((Object)0.0));
        DataTest.assertFalse((boolean)Data.isNull((Object)BigDecimal.ZERO));
        DataTest.assertFalse((boolean)Data.isNull((Object)BigInteger.ZERO));
    }

    public void testClone_array() {
        Object[] orig = new String[]{"a", "b", "c"};
        Object[] result = (String[])Data.clone((Object)orig);
        DataTest.assertTrue((orig != result ? 1 : 0) != 0);
        DataTest.assertTrue((boolean)Arrays.equals(orig, result));
    }

    public void testClone_intArray() {
        int[] orig = new int[]{1, 2, 3};
        int[] result = (int[])Data.clone((Object)orig);
        DataTest.assertTrue((orig != result ? 1 : 0) != 0);
        DataTest.assertTrue((boolean)Arrays.equals(orig, result));
    }

    public void testClone_arrayMap() {
        ArrayMap map = ArrayMap.of((Object[])new Object[0]);
        map.add((Object)"a", (Object)1);
        DataTest.assertEquals((Object)map, (Object)Data.clone((Object)map));
    }

    public void testClone_ArraysAsList() {
        List result;
        List<Object> orig = Arrays.asList("a", "b", "c", new ArrayList());
        DataTest.assertTrue((orig != (result = (List)Data.clone(orig)) ? 1 : 0) != 0);
        DataTest.assertEquals(orig, (Object)result);
        DataTest.assertTrue((orig.get(3) != result.get(3) ? 1 : 0) != 0);
        orig = Arrays.asList("a", "b", "c");
        result = (List)Data.clone(orig);
        DataTest.assertTrue((orig != result ? 1 : 0) != 0);
        DataTest.assertEquals(orig, (Object)result);
    }

    public void testNewCollectionInstance() throws Exception {
        DataTest.assertEquals(ArrayList.class, Data.newCollectionInstance(null).getClass());
        DataTest.assertEquals(ArrayList.class, Data.newCollectionInstance(String[].class).getClass());
        DataTest.assertEquals(ArrayList.class, Data.newCollectionInstance(Object.class).getClass());
        DataTest.assertEquals(ArrayList.class, Data.newCollectionInstance(List.class).getClass());
        DataTest.assertEquals(ArrayList.class, Data.newCollectionInstance(AbstractList.class).getClass());
        DataTest.assertEquals(ArrayList.class, Data.newCollectionInstance(ArrayList.class).getClass());
        DataTest.assertEquals(LinkedList.class, Data.newCollectionInstance(LinkedList.class).getClass());
        DataTest.assertEquals(HashSet.class, Data.newCollectionInstance(Set.class).getClass());
        DataTest.assertEquals(HashSet.class, Data.newCollectionInstance(AbstractSet.class).getClass());
        DataTest.assertEquals(HashSet.class, Data.newCollectionInstance(HashSet.class).getClass());
        DataTest.assertEquals(TreeSet.class, Data.newCollectionInstance(SortedSet.class).getClass());
        DataTest.assertEquals(TreeSet.class, Data.newCollectionInstance(TreeSet.class).getClass());
        try {
            Data.newMapInstance(AbstractQueue.class);
            DataTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Data.newMapInstance(String.class);
            DataTest.fail((String)("expected " + ClassCastException.class));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        TypeVariable tTypeVar = (TypeVariable)Resolve.class.getField("t").getGenericType();
        try {
            DataTest.assertNull((Object)Data.newCollectionInstance((Type)tTypeVar));
            DataTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNewMapInstance() {
        DataTest.assertEquals(ArrayMap.class, Data.newMapInstance(Object.class).getClass());
        DataTest.assertEquals(ArrayMap.class, Data.newMapInstance(Map.class).getClass());
        DataTest.assertEquals(ArrayMap.class, Data.newMapInstance(Cloneable.class).getClass());
        DataTest.assertEquals(ArrayMap.class, Data.newMapInstance(AbstractMap.class).getClass());
        DataTest.assertEquals(ArrayMap.class, Data.newMapInstance(ArrayMap.class).getClass());
        DataTest.assertEquals(TreeMap.class, Data.newMapInstance(SortedMap.class).getClass());
        DataTest.assertEquals(TreeMap.class, Data.newMapInstance(TreeMap.class).getClass());
        DataTest.assertEquals(HashMap.class, Data.newMapInstance(HashMap.class).getClass());
        try {
            Data.newMapInstance(ConcurrentMap.class);
            DataTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Data.newMapInstance(String.class);
            DataTest.fail((String)("expected " + ClassCastException.class));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testIsPrimitive() {
        DataTest.assertFalse((boolean)Data.isPrimitive(null));
        DataTest.assertTrue((boolean)Data.isPrimitive(Integer.TYPE));
        DataTest.assertTrue((boolean)Data.isPrimitive(Integer.class));
    }

    public void testParsePrimitiveValue() {
        DataTest.assertNull((Object)Data.parsePrimitiveValue(Boolean.class, null));
        DataTest.assertEquals((Object)"abc", (Object)Data.parsePrimitiveValue(null, (String)"abc"));
        DataTest.assertEquals((Object)"abc", (Object)Data.parsePrimitiveValue(String.class, (String)"abc"));
        DataTest.assertEquals((Object)"abc", (Object)Data.parsePrimitiveValue(Object.class, (String)"abc"));
        DataTest.assertEquals((Object)Character.valueOf('a'), (Object)Data.parsePrimitiveValue(Character.class, (String)"a"));
        DataTest.assertEquals((Object)true, (Object)Data.parsePrimitiveValue(Boolean.TYPE, (String)"true"));
        DataTest.assertEquals((Object)true, (Object)Data.parsePrimitiveValue(Boolean.class, (String)"true"));
        DataTest.assertEquals((Object)new Byte(127), (Object)Data.parsePrimitiveValue(Byte.class, (String)String.valueOf(127)));
        DataTest.assertEquals((Object)new Byte(127), (Object)Data.parsePrimitiveValue(Byte.TYPE, (String)String.valueOf(127)));
        DataTest.assertEquals((Object)new Short(Short.MAX_VALUE), (Object)Data.parsePrimitiveValue(Short.class, (String)String.valueOf(Short.MAX_VALUE)));
        DataTest.assertEquals((Object)new Short(Short.MAX_VALUE), (Object)Data.parsePrimitiveValue(Short.TYPE, (String)String.valueOf(Short.MAX_VALUE)));
        DataTest.assertEquals((Object)new Integer(Integer.MAX_VALUE), (Object)Data.parsePrimitiveValue(Integer.class, (String)String.valueOf(Integer.MAX_VALUE)));
        DataTest.assertEquals((Object)new Integer(Integer.MAX_VALUE), (Object)Data.parsePrimitiveValue(Integer.TYPE, (String)String.valueOf(Integer.MAX_VALUE)));
        DataTest.assertEquals((Object)new Long(Long.MAX_VALUE), (Object)Data.parsePrimitiveValue(Long.class, (String)String.valueOf(Long.MAX_VALUE)));
        DataTest.assertEquals((Object)new Long(Long.MAX_VALUE), (Object)Data.parsePrimitiveValue(Long.TYPE, (String)String.valueOf(Long.MAX_VALUE)));
        DataTest.assertEquals((Object)new Float(Float.MAX_VALUE), (Object)Data.parsePrimitiveValue(Float.class, (String)String.valueOf(Float.MAX_VALUE)));
        DataTest.assertEquals((Object)new Float(Float.MAX_VALUE), (Object)Data.parsePrimitiveValue(Float.TYPE, (String)String.valueOf(Float.MAX_VALUE)));
        DataTest.assertEquals((Object)new Double(Double.MAX_VALUE), (Object)Data.parsePrimitiveValue(Double.class, (String)String.valueOf(Double.MAX_VALUE)));
        DataTest.assertEquals((Object)new Double(Double.MAX_VALUE), (Object)Data.parsePrimitiveValue(Double.TYPE, (String)String.valueOf(Double.MAX_VALUE)));
        BigInteger bigint = BigInteger.valueOf(Long.MAX_VALUE);
        DataTest.assertEquals((Object)bigint, (Object)Data.parsePrimitiveValue(BigInteger.class, (String)String.valueOf(Long.MAX_VALUE)));
        BigDecimal bigdec = BigDecimal.valueOf(Double.MAX_VALUE);
        DataTest.assertEquals((Object)bigdec, (Object)Data.parsePrimitiveValue(BigDecimal.class, (String)String.valueOf(Double.MAX_VALUE)));
        DateTime now = new DateTime(new Date());
        DataTest.assertEquals((Object)now, (Object)Data.parsePrimitiveValue(DateTime.class, (String)now.toStringRfc3339()));
        try {
            Data.parsePrimitiveValue(Character.TYPE, (String)"abc");
            DataTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DataTest.assertNull((Object)Data.parsePrimitiveValue(Void.class, (String)"abc"));
        DataTest.assertNull((Object)Data.parsePrimitiveValue(Enum.class, null));
    }

    public void testParsePrimitiveValueWithUnknownEnum() {
        try {
            Data.parsePrimitiveValue(MyEnum.class, (String)"foo");
            DataTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testResolveWildcardTypeOrTypeVariable() throws Exception {
        TypeVariable tTypeVar = (TypeVariable)Resolve.class.getField("t").getGenericType();
        DataTest.assertEquals(Number.class, (Object)DataTest.resolveWildcardTypeOrTypeVariable(Object.class, tTypeVar));
        DataTest.assertEquals(Number.class, (Object)DataTest.resolveWildcardTypeOrTypeVariable(Resolve.class, tTypeVar));
        DataTest.assertEquals(Integer.class, (Object)DataTest.resolveWildcardTypeOrTypeVariable(IntegerResolve.class, tTypeVar));
        DataTest.assertEquals(Long.class, (Object)DataTest.resolveWildcardTypeOrTypeVariable(LongResolve.class, tTypeVar));
        DataTest.assertEquals(Double.class, (Object)DataTest.resolveWildcardTypeOrTypeVariable(DoubleResolve.class, tTypeVar));
        DataTest.assertEquals(Number.class, (Object)DataTest.resolveWildcardTypeOrTypeVariable(MedResolve.class, tTypeVar));
        TypeVariable xTypeVar = (TypeVariable)Resolve.class.getField("x").getGenericType();
        DataTest.assertEquals(Object.class, (Object)DataTest.resolveWildcardTypeOrTypeVariable(Object.class, xTypeVar));
        DataTest.assertEquals(Boolean.class, (Object)Types.getArrayComponentType((Type)DataTest.resolveWildcardTypeOrTypeVariable(ArrayResolve.class, xTypeVar)));
        DataTest.assertEquals(Collection.class, (Object)Types.getRawClass((ParameterizedType)((ParameterizedType)DataTest.resolveWildcardTypeOrTypeVariable(ParameterizedResolve.class, xTypeVar))));
        DataTest.assertEquals(Number.class, (Object)DataTest.resolveWildcardTypeOrTypeVariable(MedXResolve.class, xTypeVar));
    }

    private static Type resolveWildcardTypeOrTypeVariable(Type context, TypeVariable<?> typeVariable) {
        return Data.resolveWildcardTypeOrTypeVariable(Arrays.asList(context), typeVariable);
    }

    static class MedXResolve<Y extends Number, X extends Y>
    extends Resolve<X, Integer> {
        MedXResolve() {
        }
    }

    static class ParameterizedResolve
    extends Resolve<Collection<Integer>, Integer> {
        ParameterizedResolve() {
        }
    }

    static class ArrayResolve
    extends Resolve<Boolean[], Integer> {
        ArrayResolve() {
        }
    }

    static class LongResolve
    extends Med2Resolve<Long> {
        LongResolve() {
        }
    }

    static class Med2Resolve<T extends Number>
    extends MedResolve<T> {
        Med2Resolve() {
        }
    }

    static class DoubleResolve
    extends MedResolve<Double> {
        DoubleResolve() {
        }
    }

    static class MedResolve<T extends Number>
    extends Resolve<Boolean, T> {
        MedResolve() {
        }
    }

    static class IntegerResolve
    extends Resolve<Boolean, Integer> {
        IntegerResolve() {
        }
    }

    static class Resolve<X, T extends Number> {
        public T t;
        public X x;

        Resolve() {
        }
    }

    private static enum MyEnum {
        A("a");

        private final String s;

        private MyEnum(String s) {
            this.s = s;
        }
    }
}

