/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.NanoClock;
import junit.framework.TestCase;

public class ExponentialBackOffTest
extends TestCase {
    public ExponentialBackOffTest(String name) {
        super(name);
    }

    public void testConstructor() {
        ExponentialBackOff backOffPolicy = new ExponentialBackOff();
        ExponentialBackOffTest.assertEquals((int)500, (int)backOffPolicy.getInitialIntervalMillis());
        ExponentialBackOffTest.assertEquals((int)500, (int)backOffPolicy.getCurrentIntervalMillis());
        ExponentialBackOffTest.assertEquals((Object)0.5, (Object)backOffPolicy.getRandomizationFactor());
        ExponentialBackOffTest.assertEquals((Object)1.5, (Object)backOffPolicy.getMultiplier());
        ExponentialBackOffTest.assertEquals((int)60000, (int)backOffPolicy.getMaxIntervalMillis());
        ExponentialBackOffTest.assertEquals((int)900000, (int)backOffPolicy.getMaxElapsedTimeMillis());
    }

    public void testBuilder() {
        ExponentialBackOff backOffPolicy = new ExponentialBackOff.Builder().build();
        ExponentialBackOffTest.assertEquals((int)500, (int)backOffPolicy.getInitialIntervalMillis());
        ExponentialBackOffTest.assertEquals((int)500, (int)backOffPolicy.getCurrentIntervalMillis());
        ExponentialBackOffTest.assertEquals((Object)0.5, (Object)backOffPolicy.getRandomizationFactor());
        ExponentialBackOffTest.assertEquals((Object)1.5, (Object)backOffPolicy.getMultiplier());
        ExponentialBackOffTest.assertEquals((int)60000, (int)backOffPolicy.getMaxIntervalMillis());
        ExponentialBackOffTest.assertEquals((int)900000, (int)backOffPolicy.getMaxElapsedTimeMillis());
        int testInitialInterval = 1;
        double testRandomizationFactor = 0.1;
        double testMultiplier = 5.0;
        int testMaxInterval = 10;
        int testMaxElapsedTime = 900000;
        backOffPolicy = new ExponentialBackOff.Builder().setInitialIntervalMillis(testInitialInterval).setRandomizationFactor(testRandomizationFactor).setMultiplier(testMultiplier).setMaxIntervalMillis(testMaxInterval).setMaxElapsedTimeMillis(testMaxElapsedTime).build();
        ExponentialBackOffTest.assertEquals((int)testInitialInterval, (int)backOffPolicy.getInitialIntervalMillis());
        ExponentialBackOffTest.assertEquals((int)testInitialInterval, (int)backOffPolicy.getCurrentIntervalMillis());
        ExponentialBackOffTest.assertEquals((Object)testRandomizationFactor, (Object)backOffPolicy.getRandomizationFactor());
        ExponentialBackOffTest.assertEquals((Object)testMultiplier, (Object)backOffPolicy.getMultiplier());
        ExponentialBackOffTest.assertEquals((int)testMaxInterval, (int)backOffPolicy.getMaxIntervalMillis());
        ExponentialBackOffTest.assertEquals((int)testMaxElapsedTime, (int)backOffPolicy.getMaxElapsedTimeMillis());
    }

    public void testBackOff() throws Exception {
        int[] expectedResults;
        int testInitialInterval = 500;
        double testRandomizationFactor = 0.1;
        double testMultiplier = 2.0;
        int testMaxInterval = 5000;
        int testMaxElapsedTime = 900000;
        ExponentialBackOff backOffPolicy = new ExponentialBackOff.Builder().setInitialIntervalMillis(testInitialInterval).setRandomizationFactor(testRandomizationFactor).setMultiplier(testMultiplier).setMaxIntervalMillis(testMaxInterval).setMaxElapsedTimeMillis(testMaxElapsedTime).build();
        for (int expected : expectedResults = new int[]{500, 1000, 2000, 4000, 5000, 5000, 5000, 5000, 5000, 5000}) {
            ExponentialBackOffTest.assertEquals((int)expected, (int)backOffPolicy.getCurrentIntervalMillis());
            int minInterval = (int)((double)expected - testRandomizationFactor * (double)expected);
            int maxInterval = (int)((double)expected + testRandomizationFactor * (double)expected);
            long actualInterval = backOffPolicy.nextBackOffMillis();
            ExponentialBackOffTest.assertTrue(((long)minInterval <= actualInterval && actualInterval <= (long)maxInterval ? 1 : 0) != 0);
        }
    }

    public void testGetRandomizedInterval() {
        ExponentialBackOffTest.assertEquals((int)1, (int)ExponentialBackOff.getRandomValueFromInterval((double)0.5, (double)0.0, (int)2));
        ExponentialBackOffTest.assertEquals((int)1, (int)ExponentialBackOff.getRandomValueFromInterval((double)0.5, (double)0.33, (int)2));
        ExponentialBackOffTest.assertEquals((int)2, (int)ExponentialBackOff.getRandomValueFromInterval((double)0.5, (double)0.34, (int)2));
        ExponentialBackOffTest.assertEquals((int)2, (int)ExponentialBackOff.getRandomValueFromInterval((double)0.5, (double)0.66, (int)2));
        ExponentialBackOffTest.assertEquals((int)3, (int)ExponentialBackOff.getRandomValueFromInterval((double)0.5, (double)0.67, (int)2));
        ExponentialBackOffTest.assertEquals((int)3, (int)ExponentialBackOff.getRandomValueFromInterval((double)0.5, (double)0.99, (int)2));
    }

    public void testGetElapsedTimeMillis() {
        ExponentialBackOff backOffPolicy = new ExponentialBackOff.Builder().setNanoClock((NanoClock)new MyNanoClock()).build();
        long elapsedTimeMillis = backOffPolicy.getElapsedTimeMillis();
        ExponentialBackOffTest.assertEquals((String)("elapsedTimeMillis=" + elapsedTimeMillis), (long)1000L, (long)elapsedTimeMillis);
    }

    public void testMaxElapsedTime() throws Exception {
        ExponentialBackOff backOffPolicy = new ExponentialBackOff.Builder().setNanoClock((NanoClock)new MyNanoClock(10000L)).build();
        ExponentialBackOffTest.assertTrue((backOffPolicy.nextBackOffMillis() != -1L ? 1 : 0) != 0);
        backOffPolicy.startTimeNanos = 0L;
        ExponentialBackOffTest.assertEquals((long)-1L, (long)backOffPolicy.nextBackOffMillis());
    }

    public void testBackOffOverflow() throws Exception {
        int testInitialInterval = 0x3FFFFFFF;
        double testMultiplier = 2.1;
        int testMaxInterval = Integer.MAX_VALUE;
        ExponentialBackOff backOffPolicy = new ExponentialBackOff.Builder().setInitialIntervalMillis(testInitialInterval).setMultiplier(testMultiplier).setMaxIntervalMillis(testMaxInterval).build();
        backOffPolicy.nextBackOffMillis();
        ExponentialBackOffTest.assertEquals((int)testMaxInterval, (int)backOffPolicy.getCurrentIntervalMillis());
    }

    static class MyNanoClock
    implements NanoClock {
        private int i = 0;
        private long startSeconds;

        MyNanoClock() {
        }

        MyNanoClock(long startSeconds) {
            this.startSeconds = startSeconds;
        }

        public long nanoTime() {
            return (this.startSeconds + (long)this.i++) * 1000000000L;
        }
    }
}

