/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.util.IOUtils;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;

public class ByteArrayContentTest
extends TestCase {
    private static final byte[] FOO = StringUtils.getBytesUtf8((String)"foo");

    public void testConstructor() throws IOException {
        this.subtestConstructor(new ByteArrayContent("type", FOO), "foo");
        this.subtestConstructor(new ByteArrayContent("type", FOO, 0, 3), "foo");
        this.subtestConstructor(new ByteArrayContent("type", FOO, 1, 2), "oo");
        this.subtestConstructor(new ByteArrayContent("type", FOO, 0, 0), "");
        try {
            new ByteArrayContent(null, FOO, -1, 2);
            ByteArrayContentTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException e) {
            ByteArrayContentTest.assertEquals((String)"offset -1, length 2, array length 3", (String)e.getMessage());
        }
        try {
            new ByteArrayContent(null, FOO, 2, 2);
            ByteArrayContentTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException e) {
            ByteArrayContentTest.assertEquals((String)"offset 2, length 2, array length 3", (String)e.getMessage());
        }
        try {
            new ByteArrayContent(null, FOO, 3, 1);
            ByteArrayContentTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException e) {
            ByteArrayContentTest.assertEquals((String)"offset 3, length 1, array length 3", (String)e.getMessage());
        }
    }

    public void subtestConstructor(ByteArrayContent content, String expected) throws IOException {
        ByteArrayContentTest.assertEquals((String)"type", (String)content.getType());
        ByteArrayContentTest.assertTrue((boolean)content.retrySupported());
        ByteArrayContentTest.assertEquals((long)expected.length(), (long)content.getLength());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)content.getInputStream(), (OutputStream)out);
        ByteArrayContentTest.assertEquals((String)expected, (String)out.toString());
    }
}

