/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.testing.util.MockBackOff;
import com.google.api.client.testing.util.MockSleeper;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;

public class HttpBackOffUnsuccessfulResponseHandlerTest
extends TestCase {
    public void testHandleResponse_retryFalse() throws IOException {
        this.subsetHandleResponse(0, 0, false, (BackOff)new MockBackOff(), HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ALWAYS);
    }

    public void testHandleResponse_requiredFalse() throws IOException {
        this.subsetHandleResponse(0, 0, true, (BackOff)new MockBackOff(), new HttpBackOffUnsuccessfulResponseHandler.BackOffRequired(){

            public boolean isRequired(HttpResponse response) {
                return false;
            }
        });
    }

    public void testHandleResponse_requiredTrue() throws IOException {
        MockBackOff backOff = new MockBackOff().setBackOffMillis(4L).setMaxTries(7);
        this.subsetHandleResponse(7, 4, true, (BackOff)backOff, HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ALWAYS);
        backOff = new MockBackOff().setBackOffMillis(2L).setMaxTries(10);
        this.subsetHandleResponse(10, 2, true, (BackOff)backOff, HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ALWAYS);
    }

    private void subsetHandleResponse(int count, int millis, boolean retry, BackOff backOff, HttpBackOffUnsuccessfulResponseHandler.BackOffRequired backOffRequired) throws IOException {
        MockSleeper sleeper = new MockSleeper();
        HttpBackOffUnsuccessfulResponseHandler handler = new HttpBackOffUnsuccessfulResponseHandler(backOff).setSleeper((Sleeper)sleeper).setBackOffRequired(backOffRequired);
        while (handler.handleResponse(null, null, retry)) {
            HttpBackOffUnsuccessfulResponseHandlerTest.assertEquals((long)millis, (long)sleeper.getLastMillis());
        }
        HttpBackOffUnsuccessfulResponseHandlerTest.assertEquals((int)count, (int)sleeper.getCount());
    }

    public void testHandleResponse_returnsFalseAndThreadRemainsInterrupted_whenSleepIsInterrupted() throws Exception {
        final AtomicBoolean stillInterrupted = new AtomicBoolean(false);
        Thread runningThread = new Thread(){

            @Override
            public void run() {
                HttpBackOffUnsuccessfulResponseHandler testTarget = new HttpBackOffUnsuccessfulResponseHandler((BackOff)new MockBackOff().setBackOffMillis(Long.MAX_VALUE).setMaxTries(1)).setSleeper(Sleeper.DEFAULT).setBackOffRequired(HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ALWAYS);
                try {
                    testTarget.handleResponse(null, null, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stillInterrupted.set(Thread.currentThread().isInterrupted());
            }
        };
        runningThread.start();
        Thread.sleep(500L);
        runningThread.interrupt();
        runningThread.join();
        HttpBackOffUnsuccessfulResponseHandlerTest.assertTrue((boolean)stillInterrupted.get());
    }
}

