/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.util.ArrayMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.TestCase;

public class UrlEncodedContentTest
extends TestCase {
    public void testWriteTo() throws IOException {
        this.subtestWriteTo("a=x", ArrayMap.of((Object[])new Object[]{"a", "x"}), false);
        this.subtestWriteTo("noval", ArrayMap.of((Object[])new Object[]{"noval", ""}), false);
        this.subtestWriteTo("multi=a&multi=b&multi=c", ArrayMap.of((Object[])new Object[]{"multi", Arrays.asList("a", "b", "c")}), false);
        this.subtestWriteTo("multi=a&multi=b&multi=c", ArrayMap.of((Object[])new Object[]{"multi", new String[]{"a", "b", "c"}}), false);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("username", "un");
        params.put("password", "password123;{}");
        this.subtestWriteTo("username=un&password=password123%3B%7B%7D", params, false);
        this.subtestWriteTo("additionkey=add%2Btion", ArrayMap.of((Object[])new Object[]{"additionkey", "add+tion"}), false);
        this.subtestWriteTo("a=x", ArrayMap.of((Object[])new Object[]{"a", "x"}), true);
        this.subtestWriteTo("noval", ArrayMap.of((Object[])new Object[]{"noval", ""}), true);
        this.subtestWriteTo("multi=a&multi=b&multi=c", ArrayMap.of((Object[])new Object[]{"multi", Arrays.asList("a", "b", "c")}), true);
        this.subtestWriteTo("multi=a&multi=b&multi=c", ArrayMap.of((Object[])new Object[]{"multi", new String[]{"a", "b", "c"}}), true);
        this.subtestWriteTo("username=un&password=password123;%7B%7D", params, true);
        this.subtestWriteTo("additionkey=add+tion", ArrayMap.of((Object[])new Object[]{"additionkey", "add+tion"}), true);
    }

    private void subtestWriteTo(String expected, Object data, boolean useEscapeUriPathEncoding) throws IOException {
        UrlEncodedContent content = new UrlEncodedContent(data, useEscapeUriPathEncoding);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        content.writeTo((OutputStream)out);
        UrlEncodedContentTest.assertEquals((String)expected, (String)out.toString());
    }

    public void testGetContent() throws Exception {
        HttpRequest request = new MockHttpTransport().createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        UrlEncodedContent content = UrlEncodedContent.getContent((HttpRequest)request);
        UrlEncodedContentTest.assertNotNull((Object)content);
        UrlEncodedContentTest.assertTrue((boolean)(content.getData() instanceof Map));
        UrlEncodedContentTest.assertEquals((Object)content, (Object)UrlEncodedContent.getContent((HttpRequest)request));
    }

    public void testGetData() {
        try {
            new UrlEncodedContent(null);
            UrlEncodedContentTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        HashMap map = new HashMap();
        UrlEncodedContent content = new UrlEncodedContent(map);
        UrlEncodedContentTest.assertEquals(map, (Object)content.getData());
    }
}

