/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import com.google.api.client.http.javanet.NetHttpResponse;
import com.google.api.client.testing.http.javanet.MockHttpURLConnection;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import junit.framework.TestCase;

public class NetHttpResponseTest
extends TestCase {
    private static final String VALID_RESPONSE = "This is a valid response.";
    private static final String ERROR_RESPONSE = "This is an error response.";

    public void testGetStatusCode() throws IOException {
        this.subtestGetStatusCode(0, -1);
        this.subtestGetStatusCode(200, 200);
        this.subtestGetStatusCode(404, 404);
    }

    public void subtestGetStatusCode(int expectedCode, int responseCode) throws IOException {
        NetHttpResponseTest.assertEquals((int)expectedCode, (int)new NetHttpResponse((HttpURLConnection)new MockHttpURLConnection(null).setResponseCode(responseCode)).getStatusCode());
    }

    public void testGetContent() throws IOException {
        this.subtestGetContent(0);
        this.subtestGetContent(200);
        this.subtestGetContent(304);
        this.subtestGetContent(307);
        this.subtestGetContent(404);
        this.subtestGetContent(503);
        this.subtestGetContentWithShortRead(0);
        this.subtestGetContentWithShortRead(200);
        this.subtestGetContentWithShortRead(304);
        this.subtestGetContentWithShortRead(307);
        this.subtestGetContentWithShortRead(404);
        this.subtestGetContentWithShortRead(503);
    }

    public void subtestGetContent(int responseCode) throws IOException {
        NetHttpResponse response = new NetHttpResponse((HttpURLConnection)new MockHttpURLConnection(null).setResponseCode(responseCode).setInputStream((InputStream)new ByteArrayInputStream(StringUtils.getBytesUtf8((String)VALID_RESPONSE))).setErrorStream((InputStream)new ByteArrayInputStream(StringUtils.getBytesUtf8((String)ERROR_RESPONSE))));
        InputStream is = response.getContent();
        byte[] buf = new byte[100];
        int bytes = 0;
        int n = 0;
        while ((n = is.read(buf)) != -1) {
            bytes += n;
        }
        if (responseCode < 400) {
            NetHttpResponseTest.assertEquals((String)VALID_RESPONSE, (String)new String(buf, 0, bytes, Charset.forName("UTF-8")));
        } else {
            NetHttpResponseTest.assertEquals((String)ERROR_RESPONSE, (String)new String(buf, 0, bytes, Charset.forName("UTF-8")));
        }
    }

    public void subtestGetContentWithShortRead(int responseCode) throws IOException {
        NetHttpResponse response = new NetHttpResponse((HttpURLConnection)new MockHttpURLConnection(null).setResponseCode(responseCode).setInputStream((InputStream)new ByteArrayInputStream(StringUtils.getBytesUtf8((String)VALID_RESPONSE))).setErrorStream((InputStream)new ByteArrayInputStream(StringUtils.getBytesUtf8((String)ERROR_RESPONSE))));
        InputStream is = response.getContent();
        byte[] buf = new byte[100];
        int bytes = 0;
        int b = 0;
        while ((b = is.read()) != -1) {
            buf[bytes++] = (byte)b;
        }
        if (responseCode < 400) {
            NetHttpResponseTest.assertEquals((String)VALID_RESPONSE, (String)new String(buf, 0, bytes, Charset.forName("UTF-8")));
        } else {
            NetHttpResponseTest.assertEquals((String)ERROR_RESPONSE, (String)new String(buf, 0, bytes, Charset.forName("UTF-8")));
        }
    }

    public void testSkippingBytes() throws IOException {
        MockHttpURLConnection connection = new MockHttpURLConnection(null).setResponseCode(200).setInputStream((InputStream)new ByteArrayInputStream(StringUtils.getBytesUtf8((String)"0123456789"))).addHeader("Content-Length", "10");
        NetHttpResponse response = new NetHttpResponse((HttpURLConnection)connection);
        InputStream is = response.getContent();
        NetHttpResponseTest.assertEquals((int)48, (int)is.read());
        NetHttpResponseTest.assertEquals((long)9L, (long)is.skip(9L));
        NetHttpResponseTest.assertEquals((int)-1, (int)is.read());
    }
}

