/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.testing.json.MockJsonFactory;
import com.google.api.client.testing.json.MockJsonParser;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import junit.framework.TestCase;
import org.junit.Test;

public class JsonObjectParserTest
extends TestCase {
    @Test
    public void testConstructor_null() {
        try {
            new JsonObjectParser((JsonFactory)null);
            JsonObjectParserTest.fail((String)"Did not throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testParse_InputStream() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);
        Integer[] parsed = new Integer[1];
        JsonObjectParser jop = new JsonObjectParser(JsonObjectParserTest.setUpMockJsonFactory(Integer[].class, parsed));
        JsonObjectParserTest.assertEquals((Object)parsed, (Object)jop.parseAndClose((InputStream)in, Charsets.UTF_8, Integer[].class));
    }

    @Test
    public void testParse_Reader() throws Exception {
        StringReader in = new StringReader("something");
        Integer[] parsed = new Integer[1];
        JsonObjectParser jop = new JsonObjectParser(JsonObjectParserTest.setUpMockJsonFactory(Integer[].class, parsed));
        JsonObjectParserTest.assertEquals((Object)parsed, (Object)jop.parseAndClose((Reader)in, Integer[].class));
    }

    private static final <T> JsonFactory setUpMockJsonFactory(final Class<T> clazz, final T parsedResult) {
        final MockJsonParser jsonParser = new MockJsonParser(null){

            public Object parse(Type dataType, boolean close) throws IOException {
                TestCase.assertEquals((Object)clazz, (Object)dataType);
                return parsedResult;
            }
        };
        return new MockJsonFactory(){

            public JsonParser createJsonParser(Reader in) throws IOException {
                return jsonParser;
            }

            public JsonParser createJsonParser(InputStream in, Charset charset) throws IOException {
                TestCase.assertEquals((Object)Charsets.UTF_8, (Object)charset);
                return jsonParser;
            }
        };
    }
}

