/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.common.truth.Truth;
import java.util.Map;
import junit.framework.TestCase;

public final class MockHttpTransportTest
extends TestCase {
    public void testBuildGetRequest_preservesLoLevelHttpRequest() throws Exception {
        MockHttpTransport httpTransport = new MockHttpTransport();
        GenericUrl url = new GenericUrl("http://example.org");
        HttpRequestFactory requestFactory = httpTransport.createRequestFactory();
        HttpRequest request = requestFactory.buildGetRequest(url);
        request.getHeaders().set("foo", (Object)"bar");
        HttpResponse unusedOnlyInspectingSideEffects = request.execute();
        MockLowLevelHttpRequest actualRequest = httpTransport.getLowLevelHttpRequest();
        Truth.assertThat((Map)actualRequest.getHeaders()).containsKey((Object)"foo");
        Truth.assertThat((Iterable)((Iterable)actualRequest.getHeaders().get("foo"))).containsExactly(new Object[]{"bar"});
    }
}

