/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Key;
import junit.framework.TestCase;

public class FieldInfoTest
extends TestCase {
    public void testOf_enum() throws Exception {
        FieldInfoTest.assertEquals((Object)E.class.getField("VALUE"), (Object)FieldInfo.of((Enum)E.VALUE).getField());
        FieldInfoTest.assertEquals((Object)E.class.getField("OTHER_VALUE"), (Object)FieldInfo.of((Enum)E.OTHER_VALUE).getField());
        FieldInfoTest.assertEquals((Object)E.class.getField("NULL"), (Object)FieldInfo.of((Enum)E.NULL).getField());
        try {
            FieldInfo.of((Enum)E.IGNORED_VALUE);
            FieldInfoTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEnumValue() {
        FieldInfoTest.assertEquals((Object)((Object)E.VALUE), (Object)FieldInfo.of((Enum)E.VALUE).enumValue());
        FieldInfoTest.assertEquals((Object)((Object)E.OTHER_VALUE), (Object)FieldInfo.of((Enum)E.OTHER_VALUE).enumValue());
        FieldInfoTest.assertEquals((Object)((Object)E.NULL), (Object)FieldInfo.of((Enum)E.NULL).enumValue());
    }

    public void testSetValueCaseSensitivityPriority() {
        Data data = new Data();
        data.setPasscode("pass1");
        data.setPassCode("pass2");
        data.set("passCode", "passX");
        FieldInfoTest.assertEquals((String)data.passcode, (String)"pass1");
        FieldInfoTest.assertEquals((String)data.passCode, (String)"passX");
        data.setPasscode("pass1");
        data.setPassCode("pass2");
        data.set("passcode", "passX");
        FieldInfoTest.assertEquals((String)data.passcode, (String)"passX");
        FieldInfoTest.assertEquals((String)data.passCode, (String)"pass2");
    }

    public static final class Data
    extends GenericJson {
        @Key
        String passcode;
        @Key
        String passCode;

        public Data setPasscode(String passcode) {
            this.passcode = passcode;
            return this;
        }

        public Data setPassCode(String passCode) {
            this.passCode = passCode;
            return this;
        }
    }

    public static enum E {
        VALUE,
        OTHER_VALUE,
        NULL,
        IGNORED_VALUE;

    }
}

